/*
 * Decompiled with CFR 0.152.
 */
package com.thanlinardos.spring_enterprise_library.time;

import com.thanlinardos.spring_enterprise_library.time.api.TimeProvider;
import com.thanlinardos.spring_enterprise_library.time.model.InstantInterval;
import com.thanlinardos.spring_enterprise_library.time.model.TimeInterval;
import java.time.Instant;
import java.time.LocalDate;
import java.time.LocalDateTime;
import java.time.ZoneId;
import java.time.ZoneOffset;
import java.time.temporal.ChronoUnit;
import java.time.temporal.TemporalAdjusters;
import java.util.concurrent.TimeUnit;

public record TimeProviderImpl(ZoneId zoneId, TimeUnit accuracy, LocalDate maxDate, LocalDate minDate, LocalDateTime maxDateTime, LocalDateTime minDateTime) implements TimeProvider
{
    @Override
    public ZoneOffset getDefaultZone() {
        return this.zoneId.getRules().getOffset(Instant.now());
    }

    @Override
    public ChronoUnit getChronoAccuracy() {
        return this.accuracy.toChronoUnit();
    }

    @Override
    public LocalDateTime getCurrentDateTime() {
        return LocalDateTime.now(this.zoneId);
    }

    @Override
    public Instant getCurrentInstant() {
        return this.getCurrentDateTime().toInstant(this.getDefaultZone());
    }

    @Override
    public LocalDate getCurrentDate() {
        return this.getCurrentDateTime().toLocalDate();
    }

    @Override
    public long getCurrentTimeMillis() {
        return this.toMillis(this.getCurrentDateTime());
    }

    @Override
    public LocalDateTime fromMillis(long milliseconds) {
        return LocalDateTime.ofInstant(Instant.ofEpochMilli(milliseconds), this.zoneId);
    }

    @Override
    public long toMillis(LocalDateTime ldt) {
        return ldt.atZone(this.zoneId).toInstant().toEpochMilli();
    }

    @Override
    public LocalDateTime getEndOfDay(LocalDate date) {
        LocalDateTime start = this.getStartOfDay(date);
        return start.isAfter(LocalDateTime.MIN) ? start.minusSeconds(1L).plusDays(1L) : start.plusDays(1L).minusSeconds(1L);
    }

    @Override
    public LocalDateTime getStartOfDay(LocalDate date) {
        return date.atStartOfDay();
    }

    @Override
    public LocalDate getFirstDayOfQuarter(LocalDate dateInQuarter) {
        LocalDate result = this.getCurrentDate();
        return result.withYear(dateInQuarter.getYear()).with(dateInQuarter.getMonth().firstMonthOfQuarter()).with(TemporalAdjusters.firstDayOfMonth());
    }

    @Override
    public LocalDate getLastDayOfQuarter(LocalDate dateInQuarter) {
        LocalDate result = this.getFirstDayOfQuarter(dateInQuarter);
        return result.plusMonths(2L).with(TemporalAdjusters.lastDayOfMonth());
    }

    @Override
    public LocalDate getFirstDayOfYear(LocalDate date) {
        return date.with(TemporalAdjusters.firstDayOfYear());
    }

    @Override
    public LocalDate getLastDayOfYear(LocalDate date) {
        return date.with(TemporalAdjusters.lastDayOfYear());
    }

    @Override
    public InstantInterval instantFromNowPlusSeconds(long seconds) {
        Instant now = this.getCurrentInstant();
        return new InstantInterval(now, now.plusSeconds(seconds));
    }

    @Override
    public TimeInterval timeFromNowPlusSeconds(long seconds) {
        LocalDateTime now = this.getCurrentDateTime();
        return new TimeInterval(now, now.plusSeconds(seconds));
    }
}

