/*
 * Decompiled with CFR 0.152.
 */
package com.thanlinardos.spring_enterprise_library.time.api;

import com.thanlinardos.spring_enterprise_library.time.model.Interval;
import com.thanlinardos.spring_enterprise_library.time.utils.DateUtils;
import java.time.LocalDate;
import java.time.Year;
import java.time.YearMonth;

public interface DateTemporal {
    public Interval getInterval();

    default public boolean isInRange(LocalDate from, LocalDate to) {
        return new Interval(from, to).contains(this.getInterval());
    }

    default public boolean isContainedIn(DateTemporal interval) {
        return interval.getInterval().contains(this.getInterval());
    }

    default public boolean isContainedIn(LocalDate from, LocalDate to) {
        return new Interval(from, to).contains(this.getInterval());
    }

    default public boolean containsInterval(DateTemporal interval) {
        return this.getInterval().contains(interval.getInterval());
    }

    default public boolean containsDate(LocalDate date) {
        return this.getInterval().contains(date);
    }

    default public boolean containsMonth(YearMonth yearMonth) {
        return this.getInterval().contains(yearMonth);
    }

    default public boolean equalsInterval(DateTemporal interval) {
        return this.getInterval().equals(interval.getInterval());
    }

    default public boolean overlapsInterval(DateTemporal interval) {
        return this.getInterval().overlaps(interval.getInterval());
    }

    default public boolean overlapsMonth(YearMonth yearMonth) {
        return this.getInterval().overlaps(yearMonth);
    }

    default public boolean overlapsYear(Year year) {
        return this.getInterval().overlaps(year);
    }

    default public boolean overlapsYear(LocalDate yearDate) {
        return this.getInterval().overlaps(Year.from(yearDate));
    }

    default public boolean overlapsInterval(LocalDate start, LocalDate end) {
        return this.getInterval().overlaps(new Interval(start, end));
    }

    default public boolean startsAfter(LocalDate date) {
        return DateUtils.isAfterNullAsMax(this.getInterval().start(), date);
    }

    default public boolean endsAfter(LocalDate date) {
        return DateUtils.isAfterNullAsMax(this.getInterval().end(), date);
    }

    default public boolean endsAfterOrOn(LocalDate date) {
        return DateUtils.isAfterOrEqual(this.getInterval().end(), date);
    }

    default public boolean startsBefore(LocalDate date) {
        return DateUtils.isBeforeNullAsMin(this.getInterval().start(), date);
    }

    default public boolean startsBeforeOrOn(LocalDate date) {
        return DateUtils.isBeforeOrEqual(this.getInterval().start(), date);
    }
}

