/*
 * Decompiled with CFR 0.152.
 */
package com.thanlinardos.spring_enterprise_library.time.model;

import com.thanlinardos.spring_enterprise_library.objects.utils.ObjectUtils;
import com.thanlinardos.spring_enterprise_library.time.TimeFactory;
import com.thanlinardos.spring_enterprise_library.time.constants.TimeConstants;
import com.thanlinardos.spring_enterprise_library.time.model.Interval;
import com.thanlinardos.spring_enterprise_library.time.utils.DateUtils;
import com.thanlinardos.spring_enterprise_library.time.utils.InstantUtils;
import jakarta.annotation.Nonnull;
import jakarta.annotation.Nullable;
import java.time.Instant;
import java.time.LocalDate;
import java.time.Year;
import java.time.YearMonth;
import java.time.ZoneOffset;
import java.util.ArrayList;
import java.util.Collection;
import java.util.Comparator;
import java.util.List;
import java.util.Optional;
import java.util.concurrent.TimeUnit;
import java.util.function.BiPredicate;
import java.util.function.Function;
import java.util.function.Predicate;
import java.util.stream.Stream;

public record InstantInterval(@Nullable Instant start, @Nullable Instant end) implements Comparable<InstantInterval>
{
    public InstantInterval {
        if (InstantInterval.isNotValid(start, end)) {
            throw new IllegalArgumentException("Start date must be before or equal to end date");
        }
    }

    public InstantInterval(LocalDate date) {
        this(InstantUtils.fromLocalDate(date), InstantUtils.fromEndOfLocalDate(date));
    }

    public InstantInterval(LocalDate startDate, LocalDate endDate) {
        this(InstantUtils.fromLocalDate(startDate), InstantUtils.fromEndOfLocalDate(endDate));
    }

    public InstantInterval(LocalDate startDate, LocalDate endDate, TimeUnit accuracy, ZoneOffset zoneOffset) {
        this(InstantUtils.fromLocalDate(startDate, zoneOffset), InstantUtils.fromEndOfLocalDate(endDate, accuracy, zoneOffset));
    }

    public InstantInterval(Interval interval) {
        this(interval.start(), interval.end());
    }

    public InstantInterval(YearMonth yearMonth) {
        this(InstantUtils.fromLocalDate(yearMonth.atDay(1)), InstantUtils.fromLocalDate(yearMonth.atEndOfMonth()));
    }

    public InstantInterval(Year year) {
        this(InstantUtils.fromLocalDate(year.atDay(1)), InstantUtils.fromLocalDate(DateUtils.getLastDayOfYear(year)));
    }

    public static boolean isNotValid(@Nullable Instant start, @Nullable Instant end) {
        return start != null && end != null && start.isAfter(end);
    }

    public static boolean isValid(@Nullable Instant start, @Nullable Instant end) {
        return !InstantInterval.isNotValid(start, end);
    }

    public static InstantInterval forIsoInstants(@Nullable String start, @Nullable String end) {
        return new InstantInterval(InstantUtils.parseInstant(start), InstantUtils.parseInstant(end));
    }

    public static InstantInterval forIsoDates(@Nullable String startDate, @Nullable String endDate) {
        return new InstantInterval(DateUtils.parseLocalDate(startDate), DateUtils.parseLocalDate(endDate));
    }

    public static InstantInterval forIsoDates(@Nullable String startDate, @Nullable String endDate, TimeUnit accuracy, ZoneOffset zoneOffset) {
        return new InstantInterval(DateUtils.parseLocalDate(startDate), DateUtils.parseLocalDate(endDate), accuracy, zoneOffset);
    }

    public static InstantInterval forIsoDatesMilliUTC(@Nullable String startDate, @Nullable String endDate) {
        return InstantInterval.forIsoDates(startDate, endDate, TimeUnit.MILLISECONDS, ZoneOffset.UTC);
    }

    public static InstantInterval fromIsoDateToNullMilliUTC(@Nullable String startDate) {
        return InstantInterval.forIsoDates(startDate, null, TimeUnit.MILLISECONDS, ZoneOffset.UTC);
    }

    public static InstantInterval forIsoMonth(@Nonnull String month) {
        return new InstantInterval(YearMonth.parse(month));
    }

    public static InstantInterval forIsoYear(int year) {
        return new InstantInterval(Year.of(year));
    }

    public Instant getStartNullAsMin() {
        return this.hasNullStart() ? TimeFactory.getMinInstant() : this.start;
    }

    public Instant getEndNullAsMax() {
        return this.hasNullEnd() ? TimeFactory.getMaxInstant() : this.end;
    }

    public static List<InstantInterval> split(Collection<InstantInterval> intervals) {
        if (intervals.size() <= 1) {
            return new ArrayList<InstantInterval>(intervals);
        }
        List<Instant> startInstants = InstantInterval.getSortedDatesWithFunctionsPredicateAndComparator(intervals, InstantInterval::start, i -> InstantUtils.addSingle(i.end()), TimeConstants.NULL_AS_MIN_INSTANT_COMPARATOR, InstantInterval::containsNullAsMin);
        List<Instant> endInstants = InstantInterval.getSortedDatesWithFunctionsPredicateAndComparator(intervals, InstantInterval::end, i -> InstantUtils.subtractSingle(i.start()), TimeConstants.NULL_AS_MAX_INSTANT_COMPARATOR, InstantInterval::containsNullAsMax);
        if (startInstants.size() != endInstants.size()) {
            throw new IllegalStateException(String.format("Unable to split collection of intervals: %s", intervals));
        }
        ArrayList<InstantInterval> splittedIntervals = new ArrayList<InstantInterval>();
        for (int i2 = 0; i2 < startInstants.size(); ++i2) {
            splittedIntervals.add(new InstantInterval(startInstants.get(i2), endInstants.get(i2)));
        }
        return splittedIntervals;
    }

    private static List<Instant> getSortedDatesWithFunctionsPredicateAndComparator(Collection<InstantInterval> intervals, Function<InstantInterval, Instant> keepNull, Function<InstantInterval, Instant> discardNull, Comparator<Instant> comparator, BiPredicate<InstantInterval, Instant> predicate) {
        return intervals.stream().flatMap(interval -> Stream.concat(Stream.of((Instant)keepNull.apply((InstantInterval)interval)), Stream.ofNullable((Instant)discardNull.apply((InstantInterval)interval)))).filter(date -> InstantInterval.isAnyMatchForPredicateOnDate(intervals, predicate, date)).distinct().sorted(comparator).toList();
    }

    private static boolean isAnyMatchForPredicateOnDate(Collection<InstantInterval> intervals, BiPredicate<InstantInterval, Instant> predicate, Instant instant) {
        return intervals.stream().anyMatch(interval -> predicate.test((InstantInterval)interval, instant));
    }

    private boolean hasNullStart() {
        return this.start == null;
    }

    private boolean hasNullEnd() {
        return this.end == null;
    }

    public boolean containsNullAsMin(@Nullable Instant instant) {
        Instant nonNullInstant = instant == null ? TimeFactory.getMinInstant() : instant;
        return !(!this.hasNullStart() && nonNullInstant.isBefore(this.start) || !this.hasNullEnd() && nonNullInstant.isAfter(this.end));
    }

    public boolean containsNullAsMax(@Nullable Instant instant) {
        Instant nonNullInstant = instant == null ? TimeFactory.getMaxInstant() : instant;
        return !(!this.hasNullStart() && nonNullInstant.isBefore(this.start) || !this.hasNullEnd() && nonNullInstant.isAfter(this.end));
    }

    public boolean contains(@Nonnull Instant instant) {
        return !(!this.hasNullStart() && instant.isBefore(this.start) || !this.hasNullEnd() && instant.isAfter(this.end));
    }

    public boolean contains(@Nonnull YearMonth yearMonth) {
        return this.contains(new InstantInterval(yearMonth));
    }

    public boolean contains(@Nonnull InstantInterval interval) {
        return !(!this.hasNullStart() && !interval.hasNullStart() && InstantUtils.isBeforeNullAsMin(interval.start(), this.start()) || !this.hasNullEnd() && !interval.hasNullEnd() && InstantUtils.isAfterNullAsMax(interval.end(), this.end()));
    }

    public boolean overlaps(@Nonnull InstantInterval interval) {
        return !(!this.hasNullStart() && InstantUtils.isAfterNullAsMax(this.start(), interval.end()) || !this.hasNullEnd() && InstantUtils.isBeforeNullAsMin(this.end(), interval.start()));
    }

    public boolean overlaps(Collection<InstantInterval> intervals) {
        return intervals.stream().anyMatch(this::overlaps);
    }

    public boolean overlaps(@Nonnull YearMonth yearMonth) {
        return this.overlaps(new InstantInterval(yearMonth));
    }

    public static boolean anyOverlaps(Collection<InstantInterval> intervals) {
        return intervals.stream().anyMatch(interval -> interval.overlaps(interval.relativeComplement(intervals)));
    }

    public List<InstantInterval> relativeComplement(Collection<InstantInterval> intervals) {
        return intervals.stream().filter(Predicate.not(this::equals)).toList();
    }

    public boolean partiallyOverlaps(@Nonnull InstantInterval interval) {
        return this.overlaps(interval) && !this.contains(interval) && !interval.contains(this);
    }

    public Optional<InstantInterval> getOverlap(@Nonnull InstantInterval interval) {
        if (this.overlaps(interval)) {
            return Optional.of(new InstantInterval(InstantUtils.maxNullAsMin(this.start(), interval.start()), InstantUtils.minNullAsMax(this.end(), interval.end())));
        }
        return Optional.empty();
    }

    public Optional<InstantInterval> boundEnd(@Nullable Instant upperBound) {
        return this.getOverlap(new InstantInterval(null, upperBound));
    }

    public Optional<InstantInterval> boundStart(@Nullable Instant lowerBound) {
        return this.getOverlap(new InstantInterval(lowerBound, null));
    }

    public InstantInterval boundStartDateIfValid(@Nullable Instant lowerBound) {
        return this.boundStart(lowerBound).orElse(this);
    }

    public List<InstantInterval> getOverlaps(Collection<InstantInterval> intervals) {
        return this.getOverlaps(intervals, true);
    }

    public List<InstantInterval> getOverlaps(InstantInterval ... intervals) {
        return this.getOverlaps(List.of(intervals));
    }

    public List<InstantInterval> getOverlaps(Collection<InstantInterval> intervals, boolean mergeAdjacentIntervals) {
        List<InstantInterval> overlaps = intervals.stream().map(this::getOverlap).flatMap(Optional::stream).toList();
        return InstantInterval.normalize(overlaps, mergeAdjacentIntervals);
    }

    public List<InstantInterval> getNotOverlaps(Collection<InstantInterval> intervals) {
        List<InstantInterval> overlaps = this.getOverlaps(intervals);
        List<InstantInterval> notOverlaps = intervals.stream().map(interval -> interval.subtract(overlaps)).flatMap(Collection::stream).toList();
        return InstantInterval.normalize(notOverlaps);
    }

    public List<InstantInterval> getNotOverlaps(InstantInterval ... intervals) {
        return this.getNotOverlaps(List.of(intervals));
    }

    public static List<InstantInterval> normalize(Collection<InstantInterval> intervals) {
        return InstantInterval.normalize(intervals, true);
    }

    public static List<InstantInterval> normalize(Collection<InstantInterval> intervals, boolean mergeAdjacentIntervals) {
        if (intervals.size() <= 1) {
            return new ArrayList<InstantInterval>(intervals);
        }
        List<InstantInterval> sortedIntervals = InstantInterval.sort(intervals);
        ArrayList<InstantInterval> result = new ArrayList<InstantInterval>();
        InstantInterval current = sortedIntervals.getFirst();
        for (InstantInterval interval : sortedIntervals) {
            if (InstantInterval.shouldMergeCurrentInstantIntervalWithNextInstantInterval(current, interval, mergeAdjacentIntervals)) {
                current = new InstantInterval(current.start(), InstantUtils.maxNullAsMax(current.end(), interval.end()));
                continue;
            }
            result.add(current);
            current = interval;
        }
        result.add(current);
        return result.stream().distinct().toList();
    }

    private static boolean shouldMergeCurrentInstantIntervalWithNextInstantInterval(InstantInterval current, InstantInterval next, boolean mergeAdjacentIntervals) {
        Instant adjustedEnd = mergeAdjacentIntervals ? InstantUtils.addSingle(current.end()) : current.end();
        return !InstantUtils.isAfterNullAsMax(next.start(), adjustedEnd);
    }

    private static List<InstantInterval> sort(Collection<InstantInterval> intervals) {
        return intervals.stream().sorted().toList();
    }

    public boolean adjacent(@Nonnull InstantInterval interval) {
        return ObjectUtils.isAllObjectsNotNullAndEquals(InstantUtils.subtractSingle(this.start()), interval.end()) || ObjectUtils.isAllObjectsNotNullAndEquals(this.end(), InstantUtils.subtractSingle(interval.start()));
    }

    public List<InstantInterval> subtract(InstantInterval interval) {
        return this.subtract(List.of(interval));
    }

    public List<InstantInterval> subtract(Collection<InstantInterval> intervals) {
        Instant nextPossibleStart = this.start();
        boolean endCrossed = false;
        ArrayList<InstantInterval> resultIntervals = new ArrayList<InstantInterval>();
        for (InstantInterval overlap : this.getOverlaps(intervals)) {
            if (InstantUtils.isBeforeNullAsMin(nextPossibleStart, overlap.start())) {
                resultIntervals.add(new InstantInterval(nextPossibleStart, InstantUtils.minNullAsMax(this.end(), InstantUtils.subtractSingle(overlap.start()))));
            }
            if (InstantUtils.isAfterOrEqual(overlap.end(), this.end())) {
                endCrossed = true;
                break;
            }
            if (!InstantUtils.isBeforeOrEqual(nextPossibleStart, overlap.end())) continue;
            nextPossibleStart = InstantUtils.addSingle(overlap.end());
        }
        if (!endCrossed) {
            resultIntervals.add(new InstantInterval(nextPossibleStart, this.end()));
        }
        return resultIntervals;
    }

    @Override
    public int compareTo(@Nonnull InstantInterval o) {
        int startComparisonResult = TimeConstants.NULL_AS_MIN_INSTANT_COMPARATOR.compare(this.start(), o.start());
        if (startComparisonResult == 0) {
            return TimeConstants.NULL_AS_MAX_INSTANT_COMPARATOR.compare(this.end(), o.end());
        }
        return startComparisonResult;
    }
}

