/*
 * Decompiled with CFR 0.152.
 */
package com.thanlinardos.spring_enterprise_library.time.model;

import com.thanlinardos.spring_enterprise_library.objects.utils.ObjectUtils;
import com.thanlinardos.spring_enterprise_library.time.TimeFactory;
import com.thanlinardos.spring_enterprise_library.time.api.DateTemporal;
import com.thanlinardos.spring_enterprise_library.time.constants.TimeConstants;
import com.thanlinardos.spring_enterprise_library.time.utils.DateUtils;
import jakarta.annotation.Nonnull;
import jakarta.annotation.Nullable;
import java.time.LocalDate;
import java.time.Year;
import java.time.YearMonth;
import java.util.ArrayList;
import java.util.Collection;
import java.util.Comparator;
import java.util.List;
import java.util.Optional;
import java.util.function.BiPredicate;
import java.util.function.Function;
import java.util.function.Predicate;
import java.util.stream.Stream;

public record Interval(@Nullable LocalDate start, @Nullable LocalDate end) implements Comparable<Interval>,
DateTemporal
{
    public Interval {
        if (Interval.isNotValid(start, end)) {
            throw new IllegalArgumentException("Start date must be before or equal to end date");
        }
    }

    public Interval(YearMonth yearMonth) {
        this(yearMonth.atDay(1), yearMonth.atEndOfMonth());
    }

    public Interval(Year year) {
        this(year.atDay(1), DateUtils.getLastDayOfYear(year));
    }

    @Override
    public Interval getInterval() {
        return this;
    }

    public static boolean isNotValid(@Nullable LocalDate start, @Nullable LocalDate end) {
        return start != null && end != null && start.isAfter(end);
    }

    public static boolean isValid(@Nullable LocalDate start, @Nullable LocalDate end) {
        return !Interval.isNotValid(start, end);
    }

    public static Interval forIsoDates(@Nullable String startDate, @Nullable String endDate) {
        return new Interval(DateUtils.parseLocalDate(startDate), DateUtils.parseLocalDate(endDate));
    }

    public static Interval forIsoMonth(@Nonnull String month) {
        return new Interval(YearMonth.parse(month));
    }

    public static Interval forIsoYear(int year) {
        return new Interval(Year.of(year));
    }

    public LocalDate getStartNullAsMin() {
        return this.hasNullStart() ? TimeFactory.getMinDate() : this.start;
    }

    public LocalDate getEndNullAsMax() {
        return this.hasNullEnd() ? TimeFactory.getMaxDate() : this.end;
    }

    public static List<Interval> split(Collection<Interval> intervals) {
        if (intervals.size() <= 1) {
            return new ArrayList<Interval>(intervals);
        }
        List<LocalDate> startDates = Interval.getSortedDatesWithFunctionsPredicateAndComparator(intervals, Interval::start, i -> DateUtils.addDay(i.end()), TimeConstants.NULL_AS_MIN_COMPARATOR, Interval::containsNullAsMin);
        List<LocalDate> endDates = Interval.getSortedDatesWithFunctionsPredicateAndComparator(intervals, Interval::end, i -> DateUtils.subtractDay(i.start()), TimeConstants.NULL_AS_MAX_COMPARATOR, Interval::containsNullAsMax);
        if (startDates.size() != endDates.size()) {
            throw new IllegalStateException(String.format("Unable to split collection of intervals: %s", intervals));
        }
        ArrayList<Interval> splittedIntervals = new ArrayList<Interval>();
        for (int i2 = 0; i2 < startDates.size(); ++i2) {
            splittedIntervals.add(new Interval(startDates.get(i2), endDates.get(i2)));
        }
        return splittedIntervals;
    }

    private static List<LocalDate> getSortedDatesWithFunctionsPredicateAndComparator(Collection<Interval> intervals, Function<Interval, LocalDate> keepNull, Function<Interval, LocalDate> discardNull, Comparator<LocalDate> comparator, BiPredicate<Interval, LocalDate> predicate) {
        return intervals.stream().flatMap(interval -> Stream.concat(Stream.of((LocalDate)keepNull.apply((Interval)interval)), Stream.ofNullable((LocalDate)discardNull.apply((Interval)interval)))).filter(date -> Interval.isAnyMatchForPredicateOnDate(intervals, predicate, date)).distinct().sorted(comparator).toList();
    }

    private static boolean isAnyMatchForPredicateOnDate(Collection<Interval> intervals, BiPredicate<Interval, LocalDate> predicate, LocalDate date) {
        return intervals.stream().anyMatch(interval -> predicate.test((Interval)interval, date));
    }

    private boolean hasNullStart() {
        return this.start == null;
    }

    private boolean hasNullEnd() {
        return this.end == null;
    }

    public boolean containsNullAsMin(@Nullable LocalDate date) {
        LocalDate nonNullDate = date == null ? TimeFactory.getMinDate() : date;
        return !(!this.hasNullStart() && nonNullDate.isBefore(this.start) || !this.hasNullEnd() && nonNullDate.isAfter(this.end));
    }

    public boolean containsNullAsMax(@Nullable LocalDate date) {
        LocalDate nonNullDate = date == null ? TimeFactory.getMaxDate() : date;
        return !(!this.hasNullStart() && nonNullDate.isBefore(this.start) || !this.hasNullEnd() && nonNullDate.isAfter(this.end));
    }

    public boolean contains(@Nonnull LocalDate date) {
        return !(!this.hasNullStart() && date.isBefore(this.start) || !this.hasNullEnd() && date.isAfter(this.end));
    }

    public boolean contains(@Nonnull YearMonth yearMonth) {
        return this.contains(new Interval(yearMonth));
    }

    public boolean contains(@Nonnull Interval interval) {
        return !(!this.hasNullStart() && !interval.hasNullStart() && DateUtils.isBeforeNullAsMin(interval.start(), this.start()) || !this.hasNullEnd() && !interval.hasNullEnd() && DateUtils.isAfterNullAsMax(interval.end(), this.end()));
    }

    public boolean overlaps(@Nonnull Interval interval) {
        return !(!this.hasNullStart() && DateUtils.isAfterNullAsMax(this.start(), interval.end()) || !this.hasNullEnd() && DateUtils.isBeforeNullAsMin(this.end(), interval.start()));
    }

    public boolean overlaps(Collection<Interval> intervals) {
        return intervals.stream().anyMatch(this::overlaps);
    }

    public boolean overlaps(@Nonnull YearMonth yearMonth) {
        return this.overlaps(new Interval(yearMonth));
    }

    public boolean overlaps(@Nonnull Year year) {
        return this.overlaps(new Interval(year));
    }

    public static boolean anyOverlaps(Collection<Interval> intervals) {
        return intervals.stream().anyMatch(interval -> interval.overlaps(interval.relativeComplement(intervals)));
    }

    public List<Interval> relativeComplement(Collection<Interval> intervals) {
        return intervals.stream().filter(Predicate.not(this::equals)).toList();
    }

    public boolean partiallyOverlaps(@Nonnull Interval interval) {
        return this.overlaps(interval) && !this.contains(interval) && !interval.contains(this);
    }

    public Optional<Interval> getOverlap(@Nonnull Interval interval) {
        if (this.overlaps(interval)) {
            return Optional.of(new Interval(DateUtils.maxNullAsMin(this.start(), interval.start()), DateUtils.minNullAsMax(this.end(), interval.end())));
        }
        return Optional.empty();
    }

    public Optional<Interval> boundEndDate(@Nullable LocalDate upperBound) {
        return this.getOverlap(new Interval(null, upperBound));
    }

    public Optional<Interval> boundStartDate(@Nullable LocalDate lowerBound) {
        return this.getOverlap(new Interval(lowerBound, null));
    }

    public Interval boundStartDateIfValid(@Nullable LocalDate lowerBound) {
        return this.boundStartDate(lowerBound).orElse(this);
    }

    public List<Interval> getOverlaps(Collection<Interval> intervals) {
        return this.getOverlaps(intervals, true);
    }

    public List<Interval> getOverlaps(Interval ... intervals) {
        return this.getOverlaps(List.of(intervals));
    }

    public List<Interval> getOverlaps(Collection<Interval> intervals, boolean mergeAdjacentIntervals) {
        List<Interval> overlaps = intervals.stream().map(this::getOverlap).flatMap(Optional::stream).toList();
        return Interval.normalize(overlaps, mergeAdjacentIntervals);
    }

    public List<Interval> getNotOverlaps(Collection<Interval> intervals) {
        List<Interval> overlaps = this.getOverlaps(intervals);
        List<Interval> notOverlaps = intervals.stream().map(interval -> interval.subtract(overlaps)).flatMap(Collection::stream).toList();
        return Interval.normalize(notOverlaps);
    }

    public List<Interval> getNotOverlaps(Interval ... intervals) {
        return this.getNotOverlaps(List.of(intervals));
    }

    public static List<Interval> normalize(Collection<Interval> intervals) {
        return Interval.normalize(intervals, true);
    }

    public static List<Interval> normalize(Collection<Interval> intervals, boolean mergeAdjacentIntervals) {
        if (intervals.size() <= 1) {
            return new ArrayList<Interval>(intervals);
        }
        List<Interval> sortedIntervals = Interval.sort(intervals);
        ArrayList<Interval> result = new ArrayList<Interval>();
        Interval current = sortedIntervals.getFirst();
        for (Interval interval : sortedIntervals) {
            if (Interval.shouldMergeCurrentIntervalWithNextInterval(current, interval, mergeAdjacentIntervals)) {
                current = new Interval(current.start(), DateUtils.maxNullAsMax(current.end(), interval.end()));
                continue;
            }
            result.add(current);
            current = interval;
        }
        result.add(current);
        return result.stream().distinct().toList();
    }

    private static boolean shouldMergeCurrentIntervalWithNextInterval(Interval current, Interval next, boolean mergeAdjacentIntervals) {
        LocalDate adjustedEndDate = mergeAdjacentIntervals ? DateUtils.addDay(current.end()) : current.end();
        return !DateUtils.isAfterNullAsMax(next.start(), adjustedEndDate);
    }

    private static List<Interval> sort(Collection<Interval> intervals) {
        return intervals.stream().sorted().toList();
    }

    public boolean adjacent(@Nonnull Interval interval) {
        return ObjectUtils.isAllObjectsNotNullAndEquals(DateUtils.subtractDay(this.start()), interval.end()) || ObjectUtils.isAllObjectsNotNullAndEquals(this.end(), DateUtils.subtractDay(interval.start()));
    }

    public List<Interval> subtract(Interval interval) {
        return this.subtract(List.of(interval));
    }

    public List<Interval> subtract(Collection<Interval> intervals) {
        LocalDate nextPossibleStartDate = this.start();
        boolean endCrossed = false;
        ArrayList<Interval> resultIntervals = new ArrayList<Interval>();
        for (Interval overlap : this.getOverlaps(intervals)) {
            if (DateUtils.isBeforeNullAsMin(nextPossibleStartDate, overlap.start())) {
                resultIntervals.add(new Interval(nextPossibleStartDate, DateUtils.minNullAsMax(this.end(), DateUtils.subtractDay(overlap.start()))));
            }
            if (DateUtils.isAfterOrEqual(overlap.end(), this.end())) {
                endCrossed = true;
                break;
            }
            if (!DateUtils.isBeforeOrEqual(nextPossibleStartDate, overlap.end())) continue;
            nextPossibleStartDate = DateUtils.addDay(overlap.end());
        }
        if (!endCrossed) {
            resultIntervals.add(new Interval(nextPossibleStartDate, this.end()));
        }
        return resultIntervals;
    }

    @Override
    public int compareTo(@Nonnull Interval o) {
        int startComparisonResult = TimeConstants.NULL_AS_MIN_COMPARATOR.compare(this.start(), o.start());
        if (startComparisonResult == 0) {
            return TimeConstants.NULL_AS_MAX_COMPARATOR.compare(this.end(), o.end());
        }
        return startComparisonResult;
    }
}

