/*
 * Decompiled with CFR 0.152.
 */
package com.thanlinardos.spring_enterprise_library.time.model;

import com.thanlinardos.spring_enterprise_library.objects.utils.ObjectUtils;
import com.thanlinardos.spring_enterprise_library.time.TimeFactory;
import com.thanlinardos.spring_enterprise_library.time.constants.TimeConstants;
import com.thanlinardos.spring_enterprise_library.time.model.Interval;
import com.thanlinardos.spring_enterprise_library.time.utils.DateTimeUtils;
import com.thanlinardos.spring_enterprise_library.time.utils.DateUtils;
import jakarta.annotation.Nonnull;
import jakarta.annotation.Nullable;
import java.time.LocalDate;
import java.time.LocalDateTime;
import java.time.Year;
import java.time.YearMonth;
import java.util.ArrayList;
import java.util.Collection;
import java.util.Comparator;
import java.util.List;
import java.util.Optional;
import java.util.concurrent.TimeUnit;
import java.util.function.BiPredicate;
import java.util.function.Function;
import java.util.function.Predicate;
import java.util.stream.Stream;

public record TimeInterval(@Nullable LocalDateTime start, @Nullable LocalDateTime end) implements Comparable<TimeInterval>
{
    public TimeInterval {
        if (TimeInterval.isNotValid(start, end)) {
            throw new IllegalArgumentException("Start date must be before or equal to end date");
        }
    }

    public TimeInterval(LocalDate date) {
        this(DateTimeUtils.fromLocalDate(date), DateTimeUtils.fromEndOfLocalDate(date));
    }

    public TimeInterval(LocalDate startDate, LocalDate endDate) {
        this(DateTimeUtils.fromLocalDate(startDate), DateTimeUtils.fromEndOfLocalDate(endDate));
    }

    public TimeInterval(LocalDate startDate, LocalDate endDate, TimeUnit accuracy) {
        this(DateTimeUtils.fromLocalDate(startDate), DateTimeUtils.fromEndOfLocalDate(endDate, accuracy));
    }

    public TimeInterval(Interval interval) {
        this(interval.start(), interval.end());
    }

    public TimeInterval(YearMonth yearMonth) {
        this(DateTimeUtils.fromLocalDate(yearMonth.atDay(1)), DateTimeUtils.fromLocalDate(yearMonth.atEndOfMonth()));
    }

    public TimeInterval(Year year) {
        this(DateTimeUtils.fromLocalDate(year.atDay(1)), DateTimeUtils.fromLocalDate(DateUtils.getLastDayOfYear(year)));
    }

    public static boolean isNotValid(@Nullable LocalDateTime start, @Nullable LocalDateTime end) {
        return start != null && end != null && start.isAfter(end);
    }

    public static boolean isValid(@Nullable LocalDateTime start, @Nullable LocalDateTime end) {
        return !TimeInterval.isNotValid(start, end);
    }

    public static TimeInterval forIsoDateToNull(String startDate) {
        return TimeInterval.forIsoDates(startDate, null);
    }

    public static TimeInterval forIsoDateMilliToNull(String startDate) {
        return TimeInterval.forIsoDates(startDate, null, TimeUnit.MILLISECONDS);
    }

    public static TimeInterval forIsoDateTimes(@Nullable String start, @Nullable String end) {
        return new TimeInterval(DateTimeUtils.parseDateTime(start), DateTimeUtils.parseDateTime(end));
    }

    public static TimeInterval forIsoDates(@Nullable String startDate, @Nullable String endDate) {
        return new TimeInterval(DateUtils.parseLocalDate(startDate), DateUtils.parseLocalDate(endDate));
    }

    public static TimeInterval forIsoDates(@Nullable String startDate, @Nullable String endDate, TimeUnit accuracy) {
        return new TimeInterval(DateUtils.parseLocalDate(startDate), DateUtils.parseLocalDate(endDate), accuracy);
    }

    public static TimeInterval forIsoDatesMilli(@Nullable String startDate, @Nullable String endDate) {
        return TimeInterval.forIsoDates(startDate, endDate, TimeUnit.MILLISECONDS);
    }

    public static TimeInterval forIsoMonth(@Nonnull String month) {
        return new TimeInterval(YearMonth.parse(month));
    }

    public static TimeInterval forIsoYear(int year) {
        return new TimeInterval(Year.of(year));
    }

    public LocalDateTime getStartNullAsMin() {
        return this.hasNullStart() ? TimeFactory.getMinDateTime() : this.start;
    }

    public LocalDateTime getEndNullAsMax() {
        return this.hasNullEnd() ? TimeFactory.getMaxDateTime() : this.end;
    }

    public static List<TimeInterval> split(Collection<TimeInterval> intervals) {
        if (intervals.size() <= 1) {
            return new ArrayList<TimeInterval>(intervals);
        }
        List<LocalDateTime> startDateTimes = TimeInterval.getSortedDatesWithFunctionsPredicateAndComparator(intervals, TimeInterval::start, i -> DateTimeUtils.addSingle(i.end()), TimeConstants.NULL_AS_MIN_DATE_TIME_COMPARATOR, TimeInterval::containsNullAsMin);
        List<LocalDateTime> endDateTimes = TimeInterval.getSortedDatesWithFunctionsPredicateAndComparator(intervals, TimeInterval::end, i -> DateTimeUtils.subtractSingle(i.start()), TimeConstants.NULL_AS_MAX_DATE_TIME_COMPARATOR, TimeInterval::containsNullAsMax);
        if (startDateTimes.size() != endDateTimes.size()) {
            throw new IllegalStateException(String.format("Unable to split collection of intervals: %s", intervals));
        }
        ArrayList<TimeInterval> splittedIntervals = new ArrayList<TimeInterval>();
        for (int i2 = 0; i2 < startDateTimes.size(); ++i2) {
            splittedIntervals.add(new TimeInterval(startDateTimes.get(i2), endDateTimes.get(i2)));
        }
        return splittedIntervals;
    }

    private static List<LocalDateTime> getSortedDatesWithFunctionsPredicateAndComparator(Collection<TimeInterval> intervals, Function<TimeInterval, LocalDateTime> keepNull, Function<TimeInterval, LocalDateTime> discardNull, Comparator<LocalDateTime> comparator, BiPredicate<TimeInterval, LocalDateTime> predicate) {
        return intervals.stream().flatMap(interval -> Stream.concat(Stream.of((LocalDateTime)keepNull.apply((TimeInterval)interval)), Stream.ofNullable((LocalDateTime)discardNull.apply((TimeInterval)interval)))).filter(date -> TimeInterval.isAnyMatchForPredicateOnDate(intervals, predicate, date)).distinct().sorted(comparator).toList();
    }

    private static boolean isAnyMatchForPredicateOnDate(Collection<TimeInterval> intervals, BiPredicate<TimeInterval, LocalDateTime> predicate, LocalDateTime dateTime) {
        return intervals.stream().anyMatch(interval -> predicate.test((TimeInterval)interval, dateTime));
    }

    private boolean hasNullStart() {
        return this.start == null;
    }

    private boolean hasNullEnd() {
        return this.end == null;
    }

    public boolean containsNullAsMin(@Nullable LocalDateTime dateTime) {
        LocalDateTime nonNullDateTime = dateTime == null ? TimeFactory.getMinDateTime() : dateTime;
        return !(!this.hasNullStart() && nonNullDateTime.isBefore(this.start) || !this.hasNullEnd() && nonNullDateTime.isAfter(this.end));
    }

    public boolean containsNullAsMax(@Nullable LocalDateTime dateTime) {
        LocalDateTime nonNullDateTime = dateTime == null ? TimeFactory.getMaxDateTime() : dateTime;
        return !(!this.hasNullStart() && nonNullDateTime.isBefore(this.start) || !this.hasNullEnd() && nonNullDateTime.isAfter(this.end));
    }

    public boolean contains(@Nonnull LocalDateTime dateTime) {
        return !(!this.hasNullStart() && dateTime.isBefore(this.start) || !this.hasNullEnd() && dateTime.isAfter(this.end));
    }

    public boolean contains(@Nonnull YearMonth yearMonth) {
        return this.contains(new TimeInterval(yearMonth));
    }

    public boolean contains(@Nonnull TimeInterval interval) {
        return !(!this.hasNullStart() && !interval.hasNullStart() && DateTimeUtils.isBeforeNullAsMin(interval.start(), this.start()) || !this.hasNullEnd() && !interval.hasNullEnd() && DateTimeUtils.isAfterNullAsMax(interval.end(), this.end()));
    }

    public boolean overlaps(@Nonnull TimeInterval interval) {
        return !(!this.hasNullStart() && DateTimeUtils.isAfterNullAsMax(this.start(), interval.end()) || !this.hasNullEnd() && DateTimeUtils.isBeforeNullAsMin(this.end(), interval.start()));
    }

    public boolean overlaps(Collection<TimeInterval> intervals) {
        return intervals.stream().anyMatch(this::overlaps);
    }

    public boolean overlaps(@Nonnull YearMonth yearMonth) {
        return this.overlaps(new TimeInterval(yearMonth));
    }

    public static boolean anyOverlaps(Collection<TimeInterval> intervals) {
        return intervals.stream().anyMatch(interval -> interval.overlaps(interval.relativeComplement(intervals)));
    }

    public List<TimeInterval> relativeComplement(Collection<TimeInterval> intervals) {
        return intervals.stream().filter(Predicate.not(this::equals)).toList();
    }

    public boolean partiallyOverlaps(@Nonnull TimeInterval interval) {
        return this.overlaps(interval) && !this.contains(interval) && !interval.contains(this);
    }

    public Optional<TimeInterval> getOverlap(@Nonnull TimeInterval interval) {
        if (this.overlaps(interval)) {
            return Optional.of(new TimeInterval(DateTimeUtils.maxNullAsMin(this.start(), interval.start()), DateTimeUtils.minNullAsMax(this.end(), interval.end())));
        }
        return Optional.empty();
    }

    public Optional<TimeInterval> boundEnd(@Nullable LocalDateTime upperBound) {
        return this.getOverlap(new TimeInterval(null, upperBound));
    }

    public Optional<TimeInterval> boundStart(@Nullable LocalDateTime lowerBound) {
        return this.getOverlap(new TimeInterval(lowerBound, null));
    }

    public TimeInterval boundStartDateIfValid(@Nullable LocalDateTime lowerBound) {
        return this.boundStart(lowerBound).orElse(this);
    }

    public List<TimeInterval> getOverlaps(Collection<TimeInterval> intervals) {
        return this.getOverlaps(intervals, true);
    }

    public List<TimeInterval> getOverlaps(TimeInterval ... intervals) {
        return this.getOverlaps(List.of(intervals));
    }

    public List<TimeInterval> getOverlaps(Collection<TimeInterval> intervals, boolean mergeAdjacentIntervals) {
        List<TimeInterval> overlaps = intervals.stream().map(this::getOverlap).flatMap(Optional::stream).toList();
        return TimeInterval.normalize(overlaps, mergeAdjacentIntervals);
    }

    public List<TimeInterval> getNotOverlaps(Collection<TimeInterval> intervals) {
        List<TimeInterval> overlaps = this.getOverlaps(intervals);
        List<TimeInterval> notOverlaps = intervals.stream().map(interval -> interval.subtract(overlaps)).flatMap(Collection::stream).toList();
        return TimeInterval.normalize(notOverlaps);
    }

    public List<TimeInterval> getNotOverlaps(TimeInterval ... intervals) {
        return this.getNotOverlaps(List.of(intervals));
    }

    public static List<TimeInterval> normalize(Collection<TimeInterval> intervals) {
        return TimeInterval.normalize(intervals, true);
    }

    public static List<TimeInterval> normalize(Collection<TimeInterval> intervals, boolean mergeAdjacentIntervals) {
        if (intervals.size() <= 1) {
            return new ArrayList<TimeInterval>(intervals);
        }
        List<TimeInterval> sortedIntervals = TimeInterval.sort(intervals);
        ArrayList<TimeInterval> result = new ArrayList<TimeInterval>();
        TimeInterval current = sortedIntervals.getFirst();
        for (TimeInterval interval : sortedIntervals) {
            if (TimeInterval.shouldMergeCurrentIntervalWithNextInterval(current, interval, mergeAdjacentIntervals)) {
                current = new TimeInterval(current.start(), DateTimeUtils.maxNullAsMax(current.end(), interval.end()));
                continue;
            }
            result.add(current);
            current = interval;
        }
        result.add(current);
        return result.stream().distinct().toList();
    }

    private static boolean shouldMergeCurrentIntervalWithNextInterval(TimeInterval current, TimeInterval next, boolean mergeAdjacentIntervals) {
        LocalDateTime adjustedEnd = mergeAdjacentIntervals ? DateTimeUtils.addSingle(current.end()) : current.end();
        return !DateTimeUtils.isAfterNullAsMax(next.start(), adjustedEnd);
    }

    private static List<TimeInterval> sort(Collection<TimeInterval> intervals) {
        return intervals.stream().sorted().toList();
    }

    public boolean adjacent(@Nonnull TimeInterval interval) {
        return ObjectUtils.isAllObjectsNotNullAndEquals(DateTimeUtils.subtractSingle(this.start()), interval.end()) || ObjectUtils.isAllObjectsNotNullAndEquals(this.end(), DateTimeUtils.subtractSingle(interval.start()));
    }

    public List<TimeInterval> subtract(TimeInterval interval) {
        return this.subtract(List.of(interval));
    }

    public List<TimeInterval> subtract(Collection<TimeInterval> intervals) {
        LocalDateTime nextPossibleStart = this.start();
        boolean endCrossed = false;
        ArrayList<TimeInterval> resultIntervals = new ArrayList<TimeInterval>();
        for (TimeInterval overlap : this.getOverlaps(intervals)) {
            if (DateTimeUtils.isBeforeNullAsMin(nextPossibleStart, overlap.start())) {
                resultIntervals.add(new TimeInterval(nextPossibleStart, DateTimeUtils.minNullAsMax(this.end(), DateTimeUtils.subtractSingle(overlap.start()))));
            }
            if (DateTimeUtils.isAfterOrEqual(overlap.end(), this.end())) {
                endCrossed = true;
                break;
            }
            if (!DateTimeUtils.isBeforeOrEqual(nextPossibleStart, overlap.end())) continue;
            nextPossibleStart = DateTimeUtils.addSingle(overlap.end());
        }
        if (!endCrossed) {
            resultIntervals.add(new TimeInterval(nextPossibleStart, this.end()));
        }
        return resultIntervals;
    }

    @Override
    public int compareTo(@Nonnull TimeInterval o) {
        int startComparisonResult = TimeConstants.NULL_AS_MIN_DATE_TIME_COMPARATOR.compare(this.start(), o.start());
        if (startComparisonResult == 0) {
            return TimeConstants.NULL_AS_MAX_DATE_TIME_COMPARATOR.compare(this.end(), o.end());
        }
        return startComparisonResult;
    }
}

