/*
 * Decompiled with CFR 0.152.
 */
package com.thanlinardos.spring_enterprise_library.time.properties;

import java.time.LocalDate;
import java.time.LocalDateTime;
import java.time.ZoneId;
import java.util.concurrent.TimeUnit;
import lombok.Generated;
import org.springframework.boot.context.properties.ConfigurationProperties;

@ConfigurationProperties(prefix="thanlinardos.springenterpriselibrary.time")
public class TimeProviderProperties {
    private static final String DEFAULT_TIME_ZONE = ZoneId.systemDefault().toString();
    private static final LocalDate MAX_DATE = LocalDate.MAX;
    private static final LocalDate MIN_DATE = LocalDate.MIN;
    private static final LocalDateTime MAX_DATE_TIME = LocalDateTime.MAX;
    private static final LocalDateTime MIN_DATE_TIME = LocalDateTime.MIN;
    private static final String DEFAULT_TIME_ACCURACY = "MILLISECONDS";
    private String timeZone = DEFAULT_TIME_ZONE;
    private String accuracy = "MILLISECONDS";
    private LocalDate maxDate = MAX_DATE;
    private LocalDate minDate = MIN_DATE;
    private LocalDateTime maxDateTime = MAX_DATE_TIME;
    private LocalDateTime minDateTime = MIN_DATE_TIME;

    public ZoneId getTimeZoneId() {
        return ZoneId.of(this.timeZone);
    }

    public TimeUnit getAccuracy() {
        return TimeUnit.valueOf(this.accuracy);
    }

    @Generated
    public String getTimeZone() {
        return this.timeZone;
    }

    @Generated
    public LocalDate getMaxDate() {
        return this.maxDate;
    }

    @Generated
    public LocalDate getMinDate() {
        return this.minDate;
    }

    @Generated
    public LocalDateTime getMaxDateTime() {
        return this.maxDateTime;
    }

    @Generated
    public LocalDateTime getMinDateTime() {
        return this.minDateTime;
    }

    @Generated
    public void setTimeZone(String timeZone) {
        this.timeZone = timeZone;
    }

    @Generated
    public void setAccuracy(String accuracy) {
        this.accuracy = accuracy;
    }

    @Generated
    public void setMaxDate(LocalDate maxDate) {
        this.maxDate = maxDate;
    }

    @Generated
    public void setMinDate(LocalDate minDate) {
        this.minDate = minDate;
    }

    @Generated
    public void setMaxDateTime(LocalDateTime maxDateTime) {
        this.maxDateTime = maxDateTime;
    }

    @Generated
    public void setMinDateTime(LocalDateTime minDateTime) {
        this.minDateTime = minDateTime;
    }
}

