/*
 * Decompiled with CFR 0.152.
 */
package com.thanlinardos.spring_enterprise_library.time.utils;

import com.thanlinardos.spring_enterprise_library.time.TimeFactory;
import com.thanlinardos.spring_enterprise_library.time.constants.TimeConstants;
import jakarta.annotation.Nullable;
import java.time.LocalDate;
import java.time.LocalDateTime;
import java.util.Objects;
import java.util.concurrent.TimeUnit;
import java.util.function.Function;
import lombok.Generated;
import org.springframework.util.StringUtils;

public abstract class DateTimeUtils {
    public static LocalDateTime parseDateTime(String start) {
        return DateTimeUtils.parseDateTime(start, LocalDateTime::parse);
    }

    public static LocalDateTime parseDateTime(@Nullable String date, Function<String, LocalDateTime> parser) {
        return StringUtils.hasLength((String)date) ? parser.apply(date) : null;
    }

    @Nullable
    public static LocalDateTime fromLocalDate(@Nullable LocalDate date) {
        return date == null ? null : date.atStartOfDay();
    }

    @Nullable
    public static LocalDateTime fromEndOfLocalDate(@Nullable LocalDate date) {
        return date == null ? null : DateTimeUtils.subtractSingle(DateTimeUtils.fromLocalDate(date.plusDays(1L)));
    }

    @Nullable
    public static LocalDateTime fromEndOfLocalDate(@Nullable LocalDate date, TimeUnit accuracy) {
        return date == null ? null : DateTimeUtils.subtractSingle(DateTimeUtils.fromLocalDate(date.plusDays(1L)), accuracy);
    }

    @Nullable
    public static LocalDate toLocalDate(@Nullable LocalDateTime dateTime) {
        return dateTime == null ? null : dateTime.atZone(TimeFactory.getDefaultZone()).toLocalDate();
    }

    public static boolean isBeforeNullAsMin(@Nullable LocalDateTime dateTime1, @Nullable LocalDateTime dateTime2) {
        return dateTime1 == null || dateTime2 != null && dateTime1.isBefore(dateTime2);
    }

    public static boolean isAfterNullAsMax(@Nullable LocalDateTime dateTime1, @Nullable LocalDateTime dateTime2) {
        return dateTime1 == null || dateTime2 != null && dateTime1.isAfter(dateTime2);
    }

    public static boolean isBeforeOrEqual(@Nullable LocalDateTime dateTime1, @Nullable LocalDateTime dateTime2) {
        return Objects.equals(dateTime1, dateTime2) || DateTimeUtils.isBeforeNullAsMin(dateTime1, dateTime2);
    }

    public static boolean isAfterOrEqual(@Nullable LocalDateTime dateTime1, @Nullable LocalDateTime dateTime2) {
        return Objects.equals(dateTime1, dateTime2) || DateTimeUtils.isAfterNullAsMax(dateTime1, dateTime2);
    }

    public static LocalDateTime maxNullAsMax(@Nullable LocalDateTime dateTime1, @Nullable LocalDateTime dateTime2) {
        return TimeConstants.NULL_AS_MAX_DATE_TIME_COMPARATOR.compare(dateTime1, dateTime2) >= 0 ? dateTime1 : dateTime2;
    }

    public static LocalDateTime minNullAsMin(@Nullable LocalDateTime dateTime1, @Nullable LocalDateTime dateTime2) {
        return TimeConstants.NULL_AS_MIN_DATE_TIME_COMPARATOR.compare(dateTime1, dateTime2) <= 0 ? dateTime1 : dateTime2;
    }

    public static LocalDateTime maxNullAsMin(@Nullable LocalDateTime dateTime1, @Nullable LocalDateTime dateTime2) {
        return TimeConstants.NULL_AS_MIN_DATE_TIME_COMPARATOR.compare(dateTime1, dateTime2) >= 0 ? dateTime1 : dateTime2;
    }

    public static LocalDateTime minNullAsMax(@Nullable LocalDateTime dateTime1, @Nullable LocalDateTime dateTime2) {
        return TimeConstants.NULL_AS_MAX_DATE_TIME_COMPARATOR.compare(dateTime1, dateTime2) <= 0 ? dateTime1 : dateTime2;
    }

    @Nullable
    public static LocalDateTime addDefault(@Nullable LocalDateTime dateTime, long amount) {
        return dateTime == null ? null : dateTime.plus(amount, TimeFactory.getAccuracy().toChronoUnit());
    }

    @Nullable
    public static LocalDateTime addSingle(@Nullable LocalDateTime dateTime) {
        return DateTimeUtils.addDefault(dateTime, 1L);
    }

    @Nullable
    public static LocalDateTime subtractDefault(@Nullable LocalDateTime dateTime, long amount) {
        return dateTime == null ? null : dateTime.minus(amount, TimeFactory.getAccuracy().toChronoUnit());
    }

    @Nullable
    public static LocalDateTime subtractSingle(@Nullable LocalDateTime dateTime) {
        return DateTimeUtils.subtractDefault(dateTime, 1L);
    }

    @Nullable
    public static LocalDateTime subtractDefault(@Nullable LocalDateTime dateTime, long amount, TimeUnit accuracy) {
        return dateTime == null ? null : dateTime.minus(amount, accuracy.toChronoUnit());
    }

    @Nullable
    public static LocalDateTime subtractSingle(@Nullable LocalDateTime dateTime, TimeUnit accuracy) {
        return DateTimeUtils.subtractDefault(dateTime, 1L, accuracy);
    }

    @Generated
    private DateTimeUtils() {
    }
}

