/*
 * Decompiled with CFR 0.152.
 */
package com.thanlinardos.spring_enterprise_library.time.utils;

import com.thanlinardos.spring_enterprise_library.time.TimeFactory;
import com.thanlinardos.spring_enterprise_library.time.constants.TimeConstants;
import jakarta.annotation.Nonnull;
import jakarta.annotation.Nullable;
import java.time.Instant;
import java.time.LocalDate;
import java.time.LocalDateTime;
import java.time.Year;
import java.time.ZonedDateTime;
import java.util.Objects;
import java.util.function.Function;
import lombok.Generated;
import org.springframework.util.StringUtils;

public abstract class DateUtils {
    public static LocalDate getLastDayOfYear(Year year) {
        return year.plusYears(1L).atDay(1).minusDays(1L);
    }

    public static LocalDateTime getLocalDateTimeFromEpochMilli(Long epochMilli) {
        return DateUtils.epochMilliToZonedDateTime(epochMilli).toLocalDateTime();
    }

    public static LocalDate getLocalDateFromEpochMilli(Long epochMilli) {
        return DateUtils.epochMilliToZonedDateTime(epochMilli).toLocalDate();
    }

    public static ZonedDateTime epochMilliToZonedDateTime(Long epochMilli) {
        return Instant.ofEpochMilli(epochMilli).atZone(TimeFactory.getDefaultZoneId());
    }

    public static long getEpochMilliFromLocalDateTime(@Nonnull LocalDateTime localDateTime) {
        return localDateTime.atZone(TimeFactory.getDefaultZoneId()).toInstant().toEpochMilli();
    }

    public static boolean isBeforeNullAsMin(@Nullable LocalDate date1, @Nullable LocalDate date2) {
        return date1 == null || date2 != null && date1.isBefore(date2);
    }

    public static boolean isAfterNullAsMax(@Nullable LocalDate date1, @Nullable LocalDate date2) {
        return date1 == null || date2 != null && date1.isAfter(date2);
    }

    public static boolean isBeforeOrEqual(@Nullable LocalDate date1, @Nullable LocalDate date2) {
        return Objects.equals(date1, date2) || DateUtils.isBeforeNullAsMin(date1, date2);
    }

    public static boolean isAfterOrEqual(@Nullable LocalDate date1, @Nullable LocalDate date2) {
        return Objects.equals(date1, date2) || DateUtils.isAfterNullAsMax(date1, date2);
    }

    public static LocalDate maxNullAsMax(@Nullable LocalDate date1, @Nullable LocalDate date2) {
        return TimeConstants.NULL_AS_MAX_COMPARATOR.compare(date1, date2) >= 0 ? date1 : date2;
    }

    public static LocalDate minNullAsMin(@Nullable LocalDate date1, @Nullable LocalDate date2) {
        return TimeConstants.NULL_AS_MIN_COMPARATOR.compare(date1, date2) <= 0 ? date1 : date2;
    }

    public static LocalDate maxNullAsMin(@Nullable LocalDate date1, @Nullable LocalDate date2) {
        return TimeConstants.NULL_AS_MIN_COMPARATOR.compare(date1, date2) >= 0 ? date1 : date2;
    }

    public static LocalDate minNullAsMax(@Nullable LocalDate date1, @Nullable LocalDate date2) {
        return TimeConstants.NULL_AS_MAX_COMPARATOR.compare(date1, date2) <= 0 ? date1 : date2;
    }

    @Nullable
    public static LocalDate addDays(@Nullable LocalDate date, int days) {
        return date == null ? null : date.plusDays(days);
    }

    @Nullable
    public static LocalDate addDay(@Nullable LocalDate date) {
        return DateUtils.addDays(date, 1);
    }

    @Nullable
    public static LocalDate subtractDay(@Nullable LocalDate date) {
        return DateUtils.addDays(date, -1);
    }

    public static LocalDate parseLocalDate(String startDate) {
        return DateUtils.parseDate(startDate, LocalDate::parse);
    }

    public static LocalDate parseDate(@Nullable String date, Function<String, LocalDate> parser) {
        return StringUtils.hasLength((String)date) ? parser.apply(date) : null;
    }

    @Generated
    private DateUtils() {
    }
}

