/*
 * Decompiled with CFR 0.152.
 */
package com.thanlinardos.spring_enterprise_library.time.utils;

import com.thanlinardos.spring_enterprise_library.time.TimeFactory;
import com.thanlinardos.spring_enterprise_library.time.constants.TimeConstants;
import jakarta.annotation.Nullable;
import java.time.Instant;
import java.time.LocalDate;
import java.time.ZoneOffset;
import java.util.Objects;
import java.util.concurrent.TimeUnit;
import java.util.function.Function;
import lombok.Generated;
import org.springframework.util.StringUtils;

public abstract class InstantUtils {
    public static Instant parseInstant(String start) {
        return InstantUtils.parseInstant(start, Instant::parse);
    }

    public static Instant parseInstant(@Nullable String date, Function<String, Instant> parser) {
        return StringUtils.hasLength((String)date) ? parser.apply(date) : null;
    }

    @Nullable
    public static Instant fromLocalDate(@Nullable LocalDate date) {
        return date == null ? null : date.atStartOfDay().toInstant(TimeFactory.getDefaultZone());
    }

    @Nullable
    public static Instant fromLocalDate(@Nullable LocalDate date, ZoneOffset zoneOffset) {
        return date == null ? null : date.atStartOfDay().toInstant(zoneOffset);
    }

    @Nullable
    public static Instant fromEndOfLocalDate(@Nullable LocalDate date) {
        return date == null ? null : InstantUtils.subtractSingle(InstantUtils.fromLocalDate(date.plusDays(1L)));
    }

    @Nullable
    public static Instant fromEndOfLocalDate(@Nullable LocalDate date, TimeUnit accuracy, ZoneOffset zoneOffset) {
        return date == null ? null : InstantUtils.subtractSingle(InstantUtils.fromLocalDate(date.plusDays(1L), zoneOffset), accuracy);
    }

    @Nullable
    public static LocalDate toLocalDate(@Nullable Instant instant) {
        return instant == null ? null : instant.atZone(TimeFactory.getDefaultZone()).toLocalDate();
    }

    public static boolean isBeforeNullAsMin(@Nullable Instant instant1, @Nullable Instant instant2) {
        return instant1 == null || instant2 != null && instant1.isBefore(instant2);
    }

    public static boolean isAfterNullAsMax(@Nullable Instant instant1, @Nullable Instant instant2) {
        return instant1 == null || instant2 != null && instant1.isAfter(instant2);
    }

    public static boolean isBeforeOrEqual(@Nullable Instant instant1, @Nullable Instant instant2) {
        return Objects.equals(instant1, instant2) || InstantUtils.isBeforeNullAsMin(instant1, instant2);
    }

    public static boolean isAfterOrEqual(@Nullable Instant instant1, @Nullable Instant instant2) {
        return Objects.equals(instant1, instant2) || InstantUtils.isAfterNullAsMax(instant1, instant2);
    }

    public static Instant maxNullAsMax(@Nullable Instant instant1, @Nullable Instant instant2) {
        return TimeConstants.NULL_AS_MAX_INSTANT_COMPARATOR.compare(instant1, instant2) >= 0 ? instant1 : instant2;
    }

    public static Instant minNullAsMin(@Nullable Instant instant1, @Nullable Instant instant2) {
        return TimeConstants.NULL_AS_MIN_INSTANT_COMPARATOR.compare(instant1, instant2) <= 0 ? instant1 : instant2;
    }

    public static Instant maxNullAsMin(@Nullable Instant instant1, @Nullable Instant instant2) {
        return TimeConstants.NULL_AS_MIN_INSTANT_COMPARATOR.compare(instant1, instant2) >= 0 ? instant1 : instant2;
    }

    public static Instant minNullAsMax(@Nullable Instant instant1, @Nullable Instant instant2) {
        return TimeConstants.NULL_AS_MAX_INSTANT_COMPARATOR.compare(instant1, instant2) <= 0 ? instant1 : instant2;
    }

    @Nullable
    public static Instant addDefault(@Nullable Instant instant, long amount) {
        return instant == null ? null : instant.plus(amount, TimeFactory.getAccuracy().toChronoUnit());
    }

    @Nullable
    public static Instant addSingle(@Nullable Instant instant) {
        return InstantUtils.addDefault(instant, 1L);
    }

    @Nullable
    public static Instant subtractDefault(@Nullable Instant instant, long amount) {
        return instant == null ? null : instant.minus(amount, TimeFactory.getAccuracy().toChronoUnit());
    }

    @Nullable
    public static Instant subtractSingle(@Nullable Instant instant) {
        return InstantUtils.subtractDefault(instant, 1L);
    }

    @Nullable
    public static Instant subtractDefault(@Nullable Instant temporal, long amount, TimeUnit accuracy) {
        return temporal == null ? null : temporal.minus(amount, accuracy.toChronoUnit());
    }

    @Nullable
    public static Instant subtractSingle(@Nullable Instant temporal, TimeUnit accuracy) {
        return InstantUtils.subtractDefault(temporal, 1L, accuracy);
    }

    @Generated
    private InstantUtils() {
    }
}

