/*
 * Decompiled with CFR 0.152.
 */
package com.thanlinardos.spring_enterprise_library.tuple;

import jakarta.annotation.Nonnull;
import jakarta.annotation.Nullable;
import java.util.Map;
import java.util.Objects;
import java.util.stream.Collector;
import java.util.stream.Collectors;
import org.springframework.util.Assert;

public record Pair<S, T>(S first, T second) {
    public Pair {
        Assert.notNull(first, (String)"First must not be null");
        Assert.notNull(second, (String)"Second must not be null");
    }

    public static <S, T> Pair<S, T> of(S first, T second) {
        return new Pair<S, T>(first, second);
    }

    public static <S, T> Collector<Pair<S, T>, ?, Map<S, T>> toMap() {
        return Collectors.toMap(Pair::first, Pair::second);
    }

    /*
     * Enabled force condition propagation
     * Lifted jumps to return sites
     */
    @Override
    public boolean equals(@Nullable Object o) {
        S first1;
        Object object;
        if (this == o) {
            return true;
        }
        if (!(o instanceof Pair)) return false;
        Pair pair = (Pair)o;
        try {
            first1 = object = pair.first();
        }
        catch (Throwable throwable) {
            throw new MatchException(throwable.toString(), throwable);
        }
        Object second1 = object = pair.second();
        if (Objects.equals(this.first, first1)) return Objects.equals(this.second, second1);
        return false;
    }

    @Override
    public int hashCode() {
        return Objects.hashCode(this.first) + 31 * Objects.hashCode(this.second);
    }

    @Override
    @Nonnull
    public String toString() {
        return String.format("%s->%s", this.first, this.second);
    }
}

