/*
 * Decompiled with CFR 0.152.
 */
package com.tigerbrokers.stock.openapi.client.util;

import com.tigerbrokers.stock.openapi.client.struct.enums.TimeZoneId;
import java.text.ParseException;
import java.text.SimpleDateFormat;
import java.util.Date;
import java.util.TimeZone;

public class DateUtils {
    public static final String FORMAT_FULL = "yyyy-MM-dd HH:mm:ss";
    public static final String FORMAT_YYYYMMDD = "yyyy-MM-dd";

    public static boolean isCustomizedFormat(String str, String format) {
        SimpleDateFormat dateFormat = new SimpleDateFormat(format);
        try {
            dateFormat.setLenient(false);
            dateFormat.parse(str);
            return true;
        }
        catch (Exception e) {
            return false;
        }
    }

    public static Date setZoneDate(String time, TimeZoneId zoneId) {
        String formatString;
        if (time == null || time.length() != 10 && time.length() != 19) {
            return null;
        }
        String string = formatString = time.length() == 10 ? FORMAT_YYYYMMDD : FORMAT_FULL;
        if (DateUtils.isCustomizedFormat(time, formatString)) {
            SimpleDateFormat format = new SimpleDateFormat(formatString);
            format.setTimeZone(TimeZone.getTimeZone(zoneId.getZoneId()));
            try {
                return format.parse(time);
            }
            catch (ParseException e) {
                return null;
            }
        }
        return null;
    }
}

