/*
 * Decompiled with CFR 0.152.
 */
package com.tigerbrokers.stock.openapi.client.util;

import com.tigerbrokers.stock.openapi.client.struct.OptionFundamentals;
import java.text.NumberFormat;

class OptionResult {
    OptionIndex index;
    double timeValue;
    double premiumRate;
    double profitRate;
    double volatility;
    double leverage;
    double insideValue;

    public String getTimeValueString() {
        return OptionResult.formatDoubleString(this.timeValue, 2);
    }

    public String getPremiumRateString() {
        return OptionResult.doubleToPercentageString(this.premiumRate, 2);
    }

    public String getProfitRateString() {
        return OptionResult.doubleToPercentageString(this.profitRate, 2);
    }

    public String getVolatilityString() {
        return OptionResult.doubleToPercentageString(this.volatility, 2);
    }

    public String getLeverageString() {
        return OptionResult.formatDoubleString(this.leverage, 2);
    }

    public String getInsideValueString() {
        return OptionResult.formatDoubleString(this.insideValue, 2);
    }

    private static String doubleToPercentageString(double src, int fractionDigits) {
        NumberFormat nf = NumberFormat.getPercentInstance();
        nf.setMinimumFractionDigits(fractionDigits);
        nf.setMaximumFractionDigits(fractionDigits);
        String res = nf.format(src);
        return res;
    }

    private static String formatDoubleString(double src, int fractionDigits) {
        NumberFormat nf = NumberFormat.getNumberInstance();
        nf.setMinimumFractionDigits(fractionDigits);
        nf.setMaximumFractionDigits(fractionDigits);
        String res = nf.format(src);
        return res;
    }

    public OptionFundamentals toOptionFundamentals(int openInterest, String volatility) {
        OptionFundamentals optionFundamentals = new OptionFundamentals();
        optionFundamentals.setPremiumRate(this.getPremiumRateString());
        optionFundamentals.setOpenInterest(openInterest + "");
        optionFundamentals.setVolatility(this.getVolatilityString());
        optionFundamentals.setHistoryVolatility(volatility);
        optionFundamentals.setDelta(this.getIndex().getDeltaString());
        optionFundamentals.setTheta(this.getIndex().getThetaString());
        optionFundamentals.setGamma(this.getIndex().getGammaString());
        optionFundamentals.setVega(this.getIndex().getVegaString());
        optionFundamentals.setTimeValue(this.getTimeValueString());
        optionFundamentals.setInsideValue(this.getInsideValueString());
        optionFundamentals.setLeverage(this.getLeverageString());
        optionFundamentals.setProfitRate(this.getProfitRateString());
        return optionFundamentals;
    }

    public OptionIndex getIndex() {
        return this.index;
    }

    public double getTimeValue() {
        return this.timeValue;
    }

    public double getPremiumRate() {
        return this.premiumRate;
    }

    public double getProfitRate() {
        return this.profitRate;
    }

    public double getVolatility() {
        return this.volatility;
    }

    public double getLeverage() {
        return this.leverage;
    }

    public double getInsideValue() {
        return this.insideValue;
    }

    public void setIndex(OptionIndex index) {
        this.index = index;
    }

    public void setTimeValue(double timeValue) {
        this.timeValue = timeValue;
    }

    public void setPremiumRate(double premiumRate) {
        this.premiumRate = premiumRate;
    }

    public void setProfitRate(double profitRate) {
        this.profitRate = profitRate;
    }

    public void setVolatility(double volatility) {
        this.volatility = volatility;
    }

    public void setLeverage(double leverage) {
        this.leverage = leverage;
    }

    public void setInsideValue(double insideValue) {
        this.insideValue = insideValue;
    }

    public boolean equals(Object o) {
        if (o == this) {
            return true;
        }
        if (!(o instanceof OptionResult)) {
            return false;
        }
        OptionResult other = (OptionResult)o;
        if (!other.canEqual(this)) {
            return false;
        }
        OptionIndex this$index = this.getIndex();
        OptionIndex other$index = other.getIndex();
        if (this$index == null ? other$index != null : !((Object)this$index).equals(other$index)) {
            return false;
        }
        if (Double.compare(this.getTimeValue(), other.getTimeValue()) != 0) {
            return false;
        }
        if (Double.compare(this.getPremiumRate(), other.getPremiumRate()) != 0) {
            return false;
        }
        if (Double.compare(this.getProfitRate(), other.getProfitRate()) != 0) {
            return false;
        }
        if (Double.compare(this.getVolatility(), other.getVolatility()) != 0) {
            return false;
        }
        if (Double.compare(this.getLeverage(), other.getLeverage()) != 0) {
            return false;
        }
        return Double.compare(this.getInsideValue(), other.getInsideValue()) == 0;
    }

    protected boolean canEqual(Object other) {
        return other instanceof OptionResult;
    }

    public int hashCode() {
        int PRIME = 59;
        int result = 1;
        OptionIndex $index = this.getIndex();
        result = result * 59 + ($index == null ? 43 : ((Object)$index).hashCode());
        long $timeValue = Double.doubleToLongBits(this.getTimeValue());
        result = result * 59 + (int)($timeValue >>> 32 ^ $timeValue);
        long $premiumRate = Double.doubleToLongBits(this.getPremiumRate());
        result = result * 59 + (int)($premiumRate >>> 32 ^ $premiumRate);
        long $profitRate = Double.doubleToLongBits(this.getProfitRate());
        result = result * 59 + (int)($profitRate >>> 32 ^ $profitRate);
        long $volatility = Double.doubleToLongBits(this.getVolatility());
        result = result * 59 + (int)($volatility >>> 32 ^ $volatility);
        long $leverage = Double.doubleToLongBits(this.getLeverage());
        result = result * 59 + (int)($leverage >>> 32 ^ $leverage);
        long $insideValue = Double.doubleToLongBits(this.getInsideValue());
        result = result * 59 + (int)($insideValue >>> 32 ^ $insideValue);
        return result;
    }

    public String toString() {
        return "OptionResult(index=" + this.getIndex() + ", timeValue=" + this.getTimeValue() + ", premiumRate=" + this.getPremiumRate() + ", profitRate=" + this.getProfitRate() + ", volatility=" + this.getVolatility() + ", leverage=" + this.getLeverage() + ", insideValue=" + this.getInsideValue() + ")";
    }

    static class OptionIndex {
        double Delta;
        double Gamma;
        double Theta;
        double Vega;
        double Rho;

        public String getDeltaString() {
            return OptionResult.formatDoubleString(this.Delta, 3);
        }

        public String getGammaString() {
            return OptionResult.formatDoubleString(this.Gamma, 3);
        }

        public String getThetaString() {
            return OptionResult.formatDoubleString(this.Theta, 3);
        }

        public String getVegaString() {
            return OptionResult.formatDoubleString(this.Vega, 3);
        }

        public String getRhoString() {
            return OptionResult.formatDoubleString(this.Rho, 3);
        }

        public double getDelta() {
            return this.Delta;
        }

        public double getGamma() {
            return this.Gamma;
        }

        public double getTheta() {
            return this.Theta;
        }

        public double getVega() {
            return this.Vega;
        }

        public double getRho() {
            return this.Rho;
        }

        public void setDelta(double Delta) {
            this.Delta = Delta;
        }

        public void setGamma(double Gamma) {
            this.Gamma = Gamma;
        }

        public void setTheta(double Theta) {
            this.Theta = Theta;
        }

        public void setVega(double Vega) {
            this.Vega = Vega;
        }

        public void setRho(double Rho) {
            this.Rho = Rho;
        }

        public boolean equals(Object o) {
            if (o == this) {
                return true;
            }
            if (!(o instanceof OptionIndex)) {
                return false;
            }
            OptionIndex other = (OptionIndex)o;
            if (!other.canEqual(this)) {
                return false;
            }
            if (Double.compare(this.getDelta(), other.getDelta()) != 0) {
                return false;
            }
            if (Double.compare(this.getGamma(), other.getGamma()) != 0) {
                return false;
            }
            if (Double.compare(this.getTheta(), other.getTheta()) != 0) {
                return false;
            }
            if (Double.compare(this.getVega(), other.getVega()) != 0) {
                return false;
            }
            return Double.compare(this.getRho(), other.getRho()) == 0;
        }

        protected boolean canEqual(Object other) {
            return other instanceof OptionIndex;
        }

        public int hashCode() {
            int PRIME = 59;
            int result = 1;
            long $Delta = Double.doubleToLongBits(this.getDelta());
            result = result * 59 + (int)($Delta >>> 32 ^ $Delta);
            long $Gamma = Double.doubleToLongBits(this.getGamma());
            result = result * 59 + (int)($Gamma >>> 32 ^ $Gamma);
            long $Theta = Double.doubleToLongBits(this.getTheta());
            result = result * 59 + (int)($Theta >>> 32 ^ $Theta);
            long $Vega = Double.doubleToLongBits(this.getVega());
            result = result * 59 + (int)($Vega >>> 32 ^ $Vega);
            long $Rho = Double.doubleToLongBits(this.getRho());
            result = result * 59 + (int)($Rho >>> 32 ^ $Rho);
            return result;
        }

        public String toString() {
            return "OptionResult.OptionIndex(Delta=" + this.getDelta() + ", Gamma=" + this.getGamma() + ", Theta=" + this.getTheta() + ", Vega=" + this.getVega() + ", Rho=" + this.getRho() + ")";
        }

        public OptionIndex(double Delta, double Gamma, double Theta, double Vega, double Rho) {
            this.Delta = Delta;
            this.Gamma = Gamma;
            this.Theta = Theta;
            this.Vega = Vega;
            this.Rho = Rho;
        }
    }
}

