/*
 * Decompiled with CFR 0.152.
 */
package com.tigerbrokers.stock.openapi.client.socket;

import com.alibaba.fastjson.JSONObject;
import com.alibaba.fastjson.serializer.SerializeFilter;
import com.alibaba.fastjson.serializer.SerializerFeature;
import com.tigerbrokers.stock.openapi.client.socket.ApiAuthentication;
import com.tigerbrokers.stock.openapi.client.socket.ApiComposeCallback;
import com.tigerbrokers.stock.openapi.client.socket.OrderIdPassport;
import com.tigerbrokers.stock.openapi.client.socket.QuoteAsyncApi;
import com.tigerbrokers.stock.openapi.client.socket.SubscribeAsyncApi;
import com.tigerbrokers.stock.openapi.client.socket.TradeAsyncApi;
import com.tigerbrokers.stock.openapi.client.socket.WebSocketHandler;
import com.tigerbrokers.stock.openapi.client.struct.enums.Market;
import com.tigerbrokers.stock.openapi.client.struct.enums.Subject;
import com.tigerbrokers.stock.openapi.client.struct.param.AssetParameter;
import com.tigerbrokers.stock.openapi.client.struct.param.OrderParameter;
import com.tigerbrokers.stock.openapi.client.struct.param.PositionParameter;
import com.tigerbrokers.stock.openapi.client.struct.param.QuoteParameter;
import com.tigerbrokers.stock.openapi.client.util.FastJsonPropertyFilter;
import com.tigerbrokers.stock.openapi.client.util.StompMessageUtil;
import com.tigerbrokers.stock.openapi.client.util.StringUtils;
import io.netty.bootstrap.Bootstrap;
import io.netty.channel.Channel;
import io.netty.channel.ChannelFuture;
import io.netty.channel.ChannelHandler;
import io.netty.channel.ChannelInitializer;
import io.netty.channel.ChannelOption;
import io.netty.channel.ChannelPipeline;
import io.netty.channel.EventLoopGroup;
import io.netty.channel.nio.NioEventLoopGroup;
import io.netty.channel.socket.SocketChannel;
import io.netty.channel.socket.nio.NioSocketChannel;
import io.netty.handler.codec.stomp.StompFrame;
import io.netty.handler.codec.stomp.StompHeaders;
import io.netty.handler.codec.stomp.StompSubframeAggregator;
import io.netty.handler.codec.stomp.StompSubframeDecoder;
import io.netty.handler.codec.stomp.StompSubframeEncoder;
import io.netty.handler.ssl.SslContext;
import io.netty.handler.ssl.SslContextBuilder;
import io.netty.handler.ssl.util.InsecureTrustManagerFactory;
import io.netty.util.internal.ConcurrentSet;
import java.net.InetSocketAddress;
import java.net.SocketAddress;
import java.net.URI;
import java.net.URISyntaxException;
import java.util.HashMap;
import java.util.HashSet;
import java.util.List;
import java.util.Set;
import java.util.concurrent.BrokenBarrierException;
import java.util.concurrent.CopyOnWriteArraySet;
import java.util.concurrent.CyclicBarrier;
import java.util.concurrent.ScheduledFuture;
import java.util.concurrent.ScheduledThreadPoolExecutor;
import java.util.concurrent.TimeUnit;
import java.util.concurrent.TimeoutException;
import java.util.concurrent.atomic.AtomicBoolean;
import java.util.concurrent.atomic.AtomicInteger;
import javax.net.ssl.SSLException;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;

public class WebSocketClient
implements TradeAsyncApi,
QuoteAsyncApi,
SubscribeAsyncApi {
    private static Logger logger = LoggerFactory.getLogger(WebSocketClient.class);
    private String url;
    private boolean async;
    private ApiAuthentication authentication;
    private ApiComposeCallback apiComposeCallback;
    private Set<Subject> subscribeList = new CopyOnWriteArraySet<Subject>();
    private Set<String> subscribeSymbols = new ConcurrentSet();
    private CyclicBarrier orderNoBarrier = new CyclicBarrier(2);
    public OrderIdPassport orderIdPassport = new OrderIdPassport();
    private EventLoopGroup group = null;
    private Bootstrap bootstrap = null;
    private Channel channel = null;
    private ChannelFuture future = null;
    private boolean inited = false;
    private volatile ScheduledFuture<?> reconnectExecutorFuture = null;
    private static final ScheduledThreadPoolExecutor reconnectExecutorService = new ScheduledThreadPoolExecutor(2);
    private long lastConnectedTime = System.currentTimeMillis();
    private AtomicInteger reconnectCount = new AtomicInteger(0);
    private AtomicBoolean reconnectErrorLogFlag = new AtomicBoolean(false);
    private static final int CONNECT_TIMEOUT = 3000;
    private static final long SHUTDOWN_TIMEOUT = 900000L;
    private static final int RECONNECT_WARNING_PERIOD = 1800;

    public WebSocketClient(String url, ApiAuthentication authentication, ApiComposeCallback apiComposeCallback) {
        this.url = url;
        this.authentication = authentication;
        this.apiComposeCallback = apiComposeCallback;
        this.async = true;
        this.init();
    }

    public WebSocketClient(String url, ApiAuthentication authentication, ApiComposeCallback apiComposeCallback, boolean async) {
        this.url = url;
        this.authentication = authentication;
        this.apiComposeCallback = apiComposeCallback;
        this.async = async;
        this.init();
    }

    private void init() {
        final InetSocketAddress address = this.getServerAddress();
        if (address == null) {
            throw new RuntimeException("get connect address error.");
        }
        this.group = new NioEventLoopGroup(1);
        this.bootstrap = new Bootstrap();
        final WebSocketHandler handler = new WebSocketHandler(this.authentication, this.apiComposeCallback, this.async, this.orderNoBarrier, this.orderIdPassport);
        ((Bootstrap)((Bootstrap)((Bootstrap)this.bootstrap.group(this.group)).option(ChannelOption.TCP_NODELAY, (Object)true)).channel(NioSocketChannel.class)).handler((ChannelHandler)new ChannelInitializer<SocketChannel>(){

            protected void initChannel(SocketChannel ch) throws SSLException {
                ChannelPipeline p = ch.pipeline();
                SslContext sslCtx = SslContextBuilder.forClient().trustManager(InsecureTrustManagerFactory.INSTANCE).build();
                p.addLast(new ChannelHandler[]{sslCtx.newHandler(ch.alloc(), address.getHostName(), address.getPort())});
                p.addLast("stompEncoder", (ChannelHandler)new StompSubframeEncoder());
                p.addLast("stompDecoder", (ChannelHandler)new StompSubframeDecoder());
                p.addLast("aggregator", (ChannelHandler)new StompSubframeAggregator(65535));
                p.addLast("webSocketHandler", (ChannelHandler)handler);
            }
        });
        this.apiComposeCallback.client(this);
        this.inited = true;
    }

    public void connect() {
        try {
            if (this.isConnected()) {
                return;
            }
            this.initReconnectCommand();
            this.doConnect();
            if (!this.isConnected()) {
                throw new Exception("Failed connect to server.");
            }
            logger.info("Success connect to server, channel is: {}", (Object)this.channel);
            this.reconnectCount.set(0);
            this.reconnectErrorLogFlag.set(false);
        }
        catch (Throwable e) {
            logger.error("Failed connect to server, cause: ", e);
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    private void doConnect() {
        block14: {
            try {
                InetSocketAddress address;
                long start = System.currentTimeMillis();
                if (!this.inited) {
                    this.init();
                }
                if ((address = this.getServerAddress()) == null) {
                    throw new RuntimeException("get connect address error.");
                }
                this.future = this.bootstrap.connect((SocketAddress)address).sync();
                boolean completed = this.future.awaitUninterruptibly(3000L, TimeUnit.MILLISECONDS);
                if (completed && this.future.isSuccess()) {
                    Channel newChannel = this.future.channel();
                    try {
                        Channel oldChannel = this.channel;
                        if (oldChannel != null) {
                            logger.info("close old netty channel:{} , create new netty channel:{} ", (Object)oldChannel, (Object)newChannel);
                            oldChannel.close();
                        }
                        break block14;
                    }
                    finally {
                        this.channel = newChannel;
                    }
                }
                if (this.future.cause() != null) {
                    throw new Exception("client failed to connect to server, error message is:" + this.future.cause().getMessage(), this.future.cause());
                }
                throw new Exception("client failed to connect to server, client-side timeout: " + (System.currentTimeMillis() - start) + "ms ");
            }
            catch (Exception e) {
                logger.error("client failed to connect to server: ", (Throwable)e);
            }
            finally {
                if (!this.isConnected()) {
                    this.future.cancel(true);
                }
            }
        }
    }

    private InetSocketAddress getServerAddress() {
        URI uri;
        if (StringUtils.isEmpty(this.url)) {
            logger.error("url is empty.");
            return null;
        }
        try {
            uri = new URI(this.url);
        }
        catch (URISyntaxException e) {
            logger.error("uri syntax exception:", (Throwable)e);
            return null;
        }
        return new InetSocketAddress(uri.getHost(), uri.getPort());
    }

    public void disconnect() {
        this.destroyConnectCommand();
        try {
            if (this.channel != null) {
                this.channel.close();
            }
        }
        catch (Throwable e) {
            logger.warn(e.getMessage(), e);
        }
        try {
            this.group.shutdownGracefully();
        }
        catch (Throwable t) {
            logger.warn(t.getMessage());
        }
        finally {
            this.inited = false;
        }
    }

    private synchronized void destroyConnectCommand() {
        try {
            if (this.reconnectExecutorFuture != null && !this.reconnectExecutorFuture.isDone()) {
                this.reconnectExecutorFuture.cancel(true);
                reconnectExecutorService.purge();
            }
        }
        catch (Throwable e) {
            logger.warn(e.getMessage(), e);
        }
    }

    public boolean isConnected() {
        if (this.channel == null) {
            return false;
        }
        return this.channel.isActive();
    }

    private synchronized void initReconnectCommand() {
        if (this.reconnectExecutorFuture == null || this.reconnectExecutorFuture.isCancelled()) {
            Runnable reconnectCommand = () -> {
                block5: {
                    try {
                        if (!this.isConnected()) {
                            this.connect();
                        } else {
                            this.lastConnectedTime = System.currentTimeMillis();
                        }
                    }
                    catch (Throwable t) {
                        if (System.currentTimeMillis() - this.lastConnectedTime > 900000L && !this.reconnectErrorLogFlag.get()) {
                            this.reconnectErrorLogFlag.set(true);
                            logger.error("client reconnect to server error, lastConnectedTime:{}, currentTime:{}", new Object[]{this.lastConnectedTime, System.currentTimeMillis(), t});
                            return;
                        }
                        if (this.reconnectCount.getAndIncrement() % 1800 != 0) break block5;
                        logger.warn("client reconnect to server error, lastConnectedTime:{}, currentTime:{}", new Object[]{this.lastConnectedTime, System.currentTimeMillis(), t});
                    }
                }
            };
            this.reconnectExecutorFuture = reconnectExecutorService.scheduleWithFixedDelay(reconnectCommand, 2000L, 10000L, TimeUnit.MILLISECONDS);
        }
    }

    @Override
    public int getOrderNo(String account) {
        JSONObject jsonObject = new JSONObject();
        jsonObject.put("account", (Object)account);
        this.sendMessage(1, jsonObject.toJSONString());
        this.nonAsyncWait();
        return this.orderIdPassport.getOrderId();
    }

    @Override
    public String getOrderNoAsync(String account) {
        JSONObject jsonObject = new JSONObject();
        jsonObject.put("account", (Object)account);
        return this.sendMessage(1, jsonObject.toJSONString());
    }

    private void nonAsyncWait() {
        if (!this.async) {
            try {
                this.orderNoBarrier.await(3L, TimeUnit.SECONDS);
            }
            catch (InterruptedException e) {
                logger.error("connect interrupted exception:", (Throwable)e);
            }
            catch (BrokenBarrierException e) {
                logger.error("connect broken barrier exception:", (Throwable)e);
            }
            catch (TimeoutException e) {
                logger.error("connect timeout exception:", (Throwable)e);
            }
        }
    }

    @Override
    public String previewOrder(OrderParameter orderParameter) {
        return this.sendMessage(2, JSONObject.toJSONString((Object)orderParameter, (SerializeFilter)FastJsonPropertyFilter.getPropertyFilter(), (SerializerFeature[])new SerializerFeature[0]));
    }

    @Override
    public String placeOrder(OrderParameter orderParameter) {
        return this.sendMessage(3, JSONObject.toJSONString((Object)orderParameter, (SerializeFilter)FastJsonPropertyFilter.getPropertyFilter(), (SerializerFeature[])new SerializerFeature[0]));
    }

    @Override
    public String cancelOrder(String account, int orderId) {
        HashMap<String, String> params = new HashMap<String, String>();
        params.put("order_id", orderId + "");
        params.put("account", account);
        return this.sendMessage(4, JSONObject.toJSONString(params));
    }

    @Override
    public String modifyOrder(OrderParameter orderParameter) {
        return this.sendMessage(5, JSONObject.toJSONString((Object)orderParameter, (SerializeFilter)FastJsonPropertyFilter.getPropertyFilter(), (SerializerFeature[])new SerializerFeature[0]));
    }

    @Override
    public String subscribe(Subject subject, List<String> focusKeys) {
        if (!this.isConnected()) {
            this.notConnect();
            return null;
        }
        StompFrame frame = StompMessageUtil.buildSubscribeMessage(subject, new HashSet<String>(focusKeys));
        this.channel.writeAndFlush((Object)frame);
        this.subscribeList.add(subject);
        return frame.headers().getAsString((CharSequence)StompHeaders.ID);
    }

    @Override
    public String subscribe(Subject subject) {
        if (!this.isConnected()) {
            this.notConnect();
            return null;
        }
        StompFrame frame = StompMessageUtil.buildSubscribeMessage(subject);
        this.channel.writeAndFlush((Object)frame);
        this.subscribeList.add(subject);
        return frame.headers().getAsString((CharSequence)StompHeaders.ID);
    }

    @Override
    public String cancelSubscribe(Subject subject) {
        if (!this.isConnected()) {
            this.notConnect();
            return null;
        }
        StompFrame frame = StompMessageUtil.buildUnSubscribeMessage(subject);
        this.channel.writeAndFlush((Object)frame);
        this.subscribeList.remove((Object)subject);
        return frame.headers().getAsString((CharSequence)StompHeaders.ID);
    }

    @Override
    public String getOpenOrders() {
        return this.sendMessage(6, null);
    }

    @Override
    public String getPosition(PositionParameter position) {
        return this.sendMessage(8, null);
    }

    @Override
    public String getAsset(AssetParameter asset) {
        return this.sendMessage(7, null);
    }

    @Override
    public String getAccount(String account) {
        JSONObject jsonObject = new JSONObject();
        jsonObject.put("account", (Object)account);
        return this.sendMessage(9, jsonObject.toJSONString());
    }

    @Override
    public String getMarketState(QuoteParameter parameter) {
        if (parameter == null || parameter.getMarket() == null) {
            logger.info("param error:{}", (Object)parameter);
            return null;
        }
        return this.sendMessage(101, JSONObject.toJSONString((Object)parameter));
    }

    @Override
    public String getAllSymbols(QuoteParameter parameter) {
        if (parameter == null || parameter.getMarket() == null) {
            logger.info("param error:{}", (Object)parameter);
            return null;
        }
        return this.sendMessage(102, JSONObject.toJSONString((Object)parameter));
    }

    @Override
    public String getAllSymbolNames(QuoteParameter parameter) {
        if (parameter == null || parameter.getMarket() == null) {
            logger.info("param error:{}", (Object)parameter);
            return null;
        }
        return this.sendMessage(103, JSONObject.toJSONString((Object)parameter));
    }

    @Override
    public String getBriefInfo(QuoteParameter parameter) {
        if (parameter.getSymbols() == null || parameter.getSymbols().isEmpty() || parameter.getMarket() == null || parameter.getMarket() == Market.ALL) {
            logger.info("param error:{}", (Object)parameter);
            return null;
        }
        return this.sendMessage(104, JSONObject.toJSONString((Object)parameter));
    }

    @Override
    public String getStockDetail(QuoteParameter parameter) {
        if (parameter.getSymbols() == null || parameter.getSymbols().isEmpty() || parameter.getMarket() == null || parameter.getMarket() == Market.ALL) {
            logger.info("param error:{}", (Object)parameter);
            return null;
        }
        return this.sendMessage(105, JSONObject.toJSONString((Object)parameter));
    }

    @Override
    public String getTimeline(QuoteParameter parameter) {
        if (parameter.getSymbols() == null || parameter.getSymbols().isEmpty() || parameter.getPeriod() == null || parameter.getMarket() == null || parameter.getMarket() == Market.ALL) {
            logger.info("param error:{}", (Object)parameter);
            return null;
        }
        return this.sendMessage(106, JSONObject.toJSONString((Object)parameter));
    }

    @Override
    public String getHourTradingTimeline(QuoteParameter parameter) {
        if (parameter.getSymbols() == null || parameter.getSymbols().isEmpty() || parameter.getMarket() == null || parameter.getMarket() == Market.ALL) {
            logger.info("param error:{}", (Object)parameter);
            return null;
        }
        return this.sendMessage(107, JSONObject.toJSONString((Object)parameter));
    }

    @Override
    public String getKline(QuoteParameter parameter) {
        if (parameter.getSymbols() == null || parameter.getSymbols().isEmpty() || parameter.getMarket() == null || parameter.getMarket() == Market.ALL) {
            logger.info("param error:{}", (Object)parameter);
            return null;
        }
        return this.sendMessage(108, JSONObject.toJSONString((Object)parameter));
    }

    @Override
    public String getTradeTick(QuoteParameter parameter) {
        if (parameter.getSymbols() == null || parameter.getSymbols().isEmpty() || parameter.getMarket() == null || parameter.getMarket() == Market.ALL) {
            logger.info("param error:{}", (Object)parameter);
            return null;
        }
        return this.sendMessage(109, JSONObject.toJSONString((Object)parameter));
    }

    @Override
    public String subscribeQuote(Set<String> symbols) {
        if (!this.isConnected()) {
            this.notConnect();
            return null;
        }
        StompFrame frame = StompMessageUtil.buildSubscribeMessage(symbols);
        this.channel.writeAndFlush((Object)frame);
        this.subscribeSymbols.addAll(symbols);
        logger.info("send subscribe quote message, symbols:{}", symbols);
        return frame.headers().getAsString((CharSequence)StompHeaders.ID);
    }

    @Override
    public String subscribeQuote(Set<String> symbols, List<String> focusKeys) {
        if (!this.isConnected()) {
            this.notConnect();
            return null;
        }
        StompFrame frame = StompMessageUtil.buildSubscribeMessage(symbols, new HashSet<String>(focusKeys));
        this.channel.writeAndFlush((Object)frame);
        this.subscribeSymbols.addAll(symbols);
        logger.info("send subscribe quote message, symbols:{},focusKeys:{}", symbols, focusKeys);
        return frame.headers().getAsString((CharSequence)StompHeaders.ID);
    }

    @Override
    public String cancelSubscribeQuote(Set<String> symbols) {
        if (!this.isConnected()) {
            this.notConnect();
            return null;
        }
        StompFrame frame = StompMessageUtil.buildUnSubscribeMessage(symbols);
        this.channel.writeAndFlush((Object)frame);
        this.subscribeSymbols.removeAll(symbols);
        logger.info("send cancel subscribe quote message, symbols:{}.", symbols);
        return frame.headers().getAsString((CharSequence)StompHeaders.ID);
    }

    @Override
    public String getSubscribedSymbols() {
        return this.sendMessage(110, null);
    }

    private String sendMessage(int reqType, String message) {
        if (!this.isConnected()) {
            this.notConnect();
            return null;
        }
        logger.info("reqType:{},send message:{}", (Object)reqType, (Object)message);
        StompFrame frame = StompMessageUtil.buildSendMessage(reqType, message);
        this.channel.writeAndFlush((Object)frame);
        return frame.headers().getAsString((CharSequence)StompHeaders.ID);
    }

    private void notConnect() {
        logger.info("connection is closed.");
    }
}

