/*
 * Decompiled with CFR 0.152.
 */
package com.tigerbrokers.stock.openapi.client.socket;

import com.tigerbrokers.stock.openapi.client.socket.ApiAuthentication;
import com.tigerbrokers.stock.openapi.client.socket.ApiCallbackDecoder;
import com.tigerbrokers.stock.openapi.client.socket.ApiComposeCallback;
import com.tigerbrokers.stock.openapi.client.socket.OrderIdPassport;
import com.tigerbrokers.stock.openapi.client.util.StompMessageUtil;
import io.netty.channel.ChannelHandler;
import io.netty.channel.ChannelHandlerContext;
import io.netty.channel.SimpleChannelInboundHandler;
import io.netty.handler.codec.stomp.StompFrame;
import java.nio.charset.Charset;
import java.util.concurrent.CyclicBarrier;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;

@ChannelHandler.Sharable
public class WebSocketHandler
extends SimpleChannelInboundHandler<StompFrame> {
    private static Logger logger = LoggerFactory.getLogger(WebSocketHandler.class);
    private ApiAuthentication authentication;
    private ApiCallbackDecoder decoder;

    public WebSocketHandler(ApiAuthentication authentication, ApiComposeCallback callback, boolean async, CyclicBarrier cyclicBarrier, OrderIdPassport orderIdPassport) {
        this.authentication = authentication;
        this.decoder = new ApiCallbackDecoder(callback, async, cyclicBarrier, orderIdPassport);
    }

    public void handlerAdded(ChannelHandlerContext ctx) {
    }

    public void channelActive(ChannelHandlerContext ctx) throws Exception {
        ctx.writeAndFlush((Object)StompMessageUtil.buildConnectMessage(this.authentication.getTigerId(), this.authentication.getSign(), this.authentication.getVersion()));
        super.channelActive(ctx);
    }

    public void channelInactive(ChannelHandlerContext ctx) throws Exception {
        logger.info("netty channel inactive!");
        super.channelInactive(ctx);
        ctx.close();
    }

    public void channelRead0(ChannelHandlerContext ctx, StompFrame frame) throws Exception {
        logger.debug("received frame from server: {}", (Object)frame);
        switch (frame.command()) {
            case CONNECTED: {
                if (this.decoder.getCallback() == null) break;
                this.decoder.getCallback().connectAck();
                break;
            }
            case MESSAGE: {
                this.decoder.handle(frame);
                break;
            }
            case RECEIPT: {
                break;
            }
            case ERROR: {
                if (this.decoder.getCallback() == null) break;
                this.decoder.getCallback().error(frame.content().toString(Charset.defaultCharset()));
                break;
            }
            case DISCONNECT: {
                if (this.decoder.getCallback() != null) {
                    this.decoder.getCallback().connectionClosed();
                }
                ctx.close();
                break;
            }
        }
    }

    public void exceptionCaught(ChannelHandlerContext ctx, Throwable cause) {
        logger.error("handler exception caught:", cause);
        ctx.close();
    }
}

