/*
 * Decompiled with CFR 0.152.
 */
package com.tigerbrokers.stock.openapi.client.socket;

import com.alibaba.fastjson.JSON;
import com.alibaba.fastjson.JSONObject;
import com.tigerbrokers.stock.openapi.client.socket.ApiComposeCallback;
import com.tigerbrokers.stock.openapi.client.struct.SubscribedSymbol;
import com.tigerbrokers.stock.openapi.client.struct.enums.QuoteSubject;
import com.tigerbrokers.stock.openapi.client.util.ApiLogger;
import com.tigerbrokers.stock.openapi.client.util.StringUtils;
import io.netty.handler.codec.stomp.StompFrame;
import java.nio.charset.Charset;

public class ApiCallbackDecoder {
    private ApiComposeCallback callback;
    private StompFrame stompFrame;
    private int retType;
    private static final Charset DEFAULT_CHARSET = Charset.forName("UTF-8");

    public ApiCallbackDecoder(ApiComposeCallback callback) {
        this.callback = callback;
    }

    public synchronized void handle(StompFrame stompFrame) {
        String content = stompFrame.content().toString(DEFAULT_CHARSET);
        if (!StringUtils.isEmpty(content) && "Heart_Beat".equals(content)) {
            this.processHeartBeat(content);
            return;
        }
        this.init(stompFrame);
        switch (this.retType) {
            case 10: {
                this.processPosition();
                break;
            }
            case 11: {
                this.processAsset();
                break;
            }
            case 9: {
                this.processOrderStatus();
                break;
            }
            case 110: {
                this.processSubscribeQuoteChange();
                break;
            }
            case 111: {
                this.processGetSubscribedSymbols();
                break;
            }
            case 112: {
                this.processSubscribeEnd();
                break;
            }
            case 113: {
                this.processCancelSubscribeEnd();
                break;
            }
            case -1: {
                break;
            }
            default: {
                this.processDefault();
            }
        }
    }

    private void init(StompFrame stompFrame) {
        this.stompFrame = stompFrame;
        this.retType = stompFrame.headers().getInt((Object)"ret-type");
    }

    public ApiComposeCallback getCallback() {
        return this.callback;
    }

    private void processPosition() {
        String content = this.stompFrame.content().toString(DEFAULT_CHARSET);
        this.callback.positionChange(JSON.parseObject((String)content));
    }

    private void processAsset() {
        String content = this.stompFrame.content().toString(DEFAULT_CHARSET);
        this.callback.assetChange(JSONObject.parseObject((String)content));
    }

    private void processOrderStatus() {
        String content = this.stompFrame.content().toString(DEFAULT_CHARSET);
        this.callback.orderStatusChange(JSONObject.parseObject((String)content));
    }

    private void processSubscribeQuoteChange() {
        String content = this.stompFrame.content().toString(DEFAULT_CHARSET);
        if (content == null) {
            return;
        }
        JSONObject jsonObject = JSONObject.parseObject((String)content);
        if (jsonObject == null) {
            return;
        }
        String type = jsonObject.getString("type");
        if (type == null) {
            return;
        }
        if (type.equals(QuoteSubject.Quote.name())) {
            this.callback.quoteChange(jsonObject);
        } else if (type.equals(QuoteSubject.Option.name())) {
            this.callback.optionChange(jsonObject);
        } else if (type.equals(QuoteSubject.Future.name())) {
            this.callback.futureChange(jsonObject);
        } else {
            this.callback.quoteChange(jsonObject);
        }
    }

    private void processGetSubscribedSymbols() {
        String content = this.stompFrame.content().toString(DEFAULT_CHARSET);
        this.callback.getSubscribedSymbolEnd((SubscribedSymbol)JSONObject.parseObject((String)content, SubscribedSymbol.class));
    }

    private void processSubscribeEnd() {
        String content = this.stompFrame.content().toString(DEFAULT_CHARSET);
        this.callback.subscribeEnd(JSONObject.parseObject((String)content));
    }

    private void processCancelSubscribeEnd() {
        String content = this.stompFrame.content().toString(DEFAULT_CHARSET);
        this.callback.cancelSubscribeEnd(JSONObject.parseObject((String)content));
    }

    private void processDefault() {
        ApiLogger.info("ret-type:{} cannot be processed.", this.retType);
    }

    private void processHeartBeat(String content) {
        this.callback.hearBeat(content);
    }

    public void serverHeartBeatTimeOut(String channelId) {
        this.callback.serverHeartBeatTimeOut(channelId);
    }
}

