/*
 * Decompiled with CFR 0.152.
 */
package com.tigerbrokers.stock.openapi.client.util.builder;

import com.tigerbrokers.stock.openapi.client.struct.enums.Subject;
import com.tigerbrokers.stock.openapi.client.util.SdkVersionUtils;
import io.netty.handler.codec.stomp.DefaultStompHeaders;
import io.netty.handler.codec.stomp.StompHeaders;
import io.netty.util.AsciiString;
import java.util.Collection;
import java.util.Set;

public class StompHeaderBuilder {
    public static final String REQ_TYPE = "req-type";
    public static final String FOCUS_KEYS = "keys";
    public static final String VERSION = "1.0";
    public static final String HOST = "localhost";
    public static final String ACCOUNT = "account";
    public static final String SYMBOLS = "symbols";
    private static AsciiString SDK_VERSION_HEADER = AsciiString.cached((String)"sdk-version");
    private StompHeaders stompHeaders = new DefaultStompHeaders();

    private StompHeaderBuilder() {
    }

    public static StompHeaderBuilder instance() {
        return new StompHeaderBuilder();
    }

    public StompHeaderBuilder version() {
        return this.version(VERSION);
    }

    public StompHeaderBuilder version(String version) {
        this.stompHeaders.set((Object)StompHeaders.ACCEPT_VERSION, (Object)version);
        return this;
    }

    public StompHeaderBuilder sdkVersion() {
        this.stompHeaders.set((Object)SDK_VERSION_HEADER, (Object)SdkVersionUtils.getSdkVersion());
        return this;
    }

    public StompHeaderBuilder host() {
        this.stompHeaders.set((Object)StompHeaders.HOST, (Object)HOST);
        return this;
    }

    public StompHeaderBuilder login(String login) {
        this.stompHeaders.set((Object)StompHeaders.LOGIN, (Object)login);
        return this;
    }

    public StompHeaderBuilder passcode(String passcode) {
        this.stompHeaders.set((Object)StompHeaders.PASSCODE, (Object)passcode);
        return this;
    }

    public StompHeaderBuilder id(int id) {
        this.stompHeaders.set((Object)StompHeaders.ID, (Object)String.valueOf(id));
        return this;
    }

    public StompHeaderBuilder reqType(int reqType) {
        this.stompHeaders.set((Object)REQ_TYPE, (Object)String.valueOf(reqType));
        return this;
    }

    public StompHeaderBuilder subject(Subject subject) {
        this.stompHeaders.set((Object)StompHeaders.SUBSCRIPTION, (Object)subject.name());
        return this;
    }

    public StompHeaderBuilder subject(String subject) {
        this.stompHeaders.set((Object)StompHeaders.SUBSCRIPTION, (Object)subject);
        return this;
    }

    public StompHeaderBuilder focusKeys(Set<String> focusKeys) {
        if (focusKeys != null) {
            this.stompHeaders.set((Object)FOCUS_KEYS, (Object)this.join(focusKeys));
        }
        return this;
    }

    public StompHeaderBuilder account(String account) {
        this.stompHeaders.set((Object)ACCOUNT, (Object)account);
        return this;
    }

    public StompHeaderBuilder heartBeat(int cx, int cy) {
        String value = String.format("%d,%d", cx, cy);
        this.stompHeaders.set((Object)StompHeaders.HEART_BEAT, (Object)value);
        return this;
    }

    public String join(Collection<String> collection) {
        StringBuilder builder = new StringBuilder();
        boolean isFirst = true;
        for (String symbol : collection) {
            if (!isFirst) {
                builder.append(",").append(symbol);
                continue;
            }
            builder.append(symbol);
            isFirst = false;
        }
        return builder.toString();
    }

    public StompHeaderBuilder symbols(Set<String> symbols) {
        this.stompHeaders.set((Object)SYMBOLS, (Object)this.join(symbols));
        return this;
    }

    public StompHeaders build() {
        return this.stompHeaders;
    }
}

