/*
 * Decompiled with CFR 0.152.
 */
package com.tigerbrokers.stock.openapi.client.https.domain.contract.model;

import com.tigerbrokers.stock.openapi.client.config.ClientConfig;
import com.tigerbrokers.stock.openapi.client.https.domain.contract.model.BaseContractModel;
import com.tigerbrokers.stock.openapi.client.struct.enums.SecType;

public class ContractModel
extends BaseContractModel {
    private String symbol;

    public ContractModel() {
    }

    public ContractModel(String symbol) {
        this.symbol = symbol;
        this.setAccount(ClientConfig.DEFAULT_CONFIG.defaultAccount);
        this.setSecType(SecType.STK.name());
    }

    public ContractModel(String symbol, String secType) {
        this(symbol);
        this.setSecType(secType);
    }

    public ContractModel(String symbol, String secType, String currency) {
        this(symbol, secType);
        this.setCurrency(currency);
    }

    public ContractModel(String symbol, String secType, String currency, String expiry, Double strike, String right) {
        this(symbol, secType, currency);
        this.setStrike(strike);
        this.setExpiry(expiry);
        this.setRight(right);
    }

    public String getSymbol() {
        return this.symbol;
    }

    public void setSymbol(String symbol) {
        this.symbol = symbol;
    }

    public static ContractModel getStockModel(String symbol) {
        return new ContractModel(symbol, SecType.STK.name());
    }

    public static ContractModel getOptionModel(String symbol, String expiry, Double strike, String right) {
        return new ContractModel(symbol, SecType.OPT.name(), null, expiry, strike, right);
    }

    public static ContractModel getWarrantModel(String symbol, String expiry, Double strike, String right) {
        return new ContractModel(symbol, SecType.WAR.name(), null, expiry, strike, right);
    }

    public static ContractModel getCbbcModel(String symbol, String expiry, Double strike, String right) {
        return new ContractModel(symbol, SecType.IOPT.name(), null, expiry, strike, right);
    }

    public static ContractModel getFutureModel(String symbol) {
        return new ContractModel(symbol, SecType.FUT.name());
    }
}

