/*
 * Decompiled with CFR 0.152.
 */
package com.tigerbrokers.stock.openapi.client.https.request.quote;

import com.tigerbrokers.stock.openapi.client.https.domain.quote.model.QuoteKlineModel;
import com.tigerbrokers.stock.openapi.client.https.request.TigerCommonRequest;
import com.tigerbrokers.stock.openapi.client.https.request.TigerRequest;
import com.tigerbrokers.stock.openapi.client.https.response.quote.QuoteKlineResponse;
import com.tigerbrokers.stock.openapi.client.struct.enums.KType;
import com.tigerbrokers.stock.openapi.client.struct.enums.RightOption;
import com.tigerbrokers.stock.openapi.client.struct.enums.TimeZoneId;
import java.util.List;

public class QuoteKlineRequest
extends TigerCommonRequest
implements TigerRequest<QuoteKlineResponse> {
    public QuoteKlineRequest() {
        this.setApiVersion("2.0");
        this.setApiMethodName("kline");
    }

    public static QuoteKlineRequest newRequest(List<String> symbols, KType kType) {
        QuoteKlineRequest request = new QuoteKlineRequest();
        QuoteKlineModel model = new QuoteKlineModel(symbols, QuoteKlineRequest.getKType(kType), -1L, -1L);
        request.setApiModel(model);
        return request;
    }

    public static QuoteKlineRequest newRequest(List<String> symbols, KType kType, Long beginTime, Long endTime) {
        QuoteKlineRequest request = new QuoteKlineRequest();
        QuoteKlineModel model = new QuoteKlineModel(symbols, QuoteKlineRequest.getKType(kType), beginTime, endTime);
        request.setApiModel(model);
        return request;
    }

    public static QuoteKlineRequest newRequest(List<String> symbols, KType kType, String beginTime, String endTime) {
        return QuoteKlineRequest.newRequest(symbols, kType, beginTime, endTime, TimeZoneId.NewYork);
    }

    public static QuoteKlineRequest newRequest(List<String> symbols, KType kType, String beginTime, String endTime, TimeZoneId zoneId) {
        QuoteKlineRequest request = new QuoteKlineRequest();
        QuoteKlineModel model = new QuoteKlineModel(symbols, QuoteKlineRequest.getKType(kType), beginTime, endTime, zoneId);
        request.setApiModel(model);
        return request;
    }

    private static String getKType(KType kType) {
        return kType != null ? kType.getValue() : KType.day.getValue();
    }

    public QuoteKlineRequest withLimit(int limit) {
        if (limit > 0 && this.apiModel instanceof QuoteKlineModel) {
            QuoteKlineModel klineModel = (QuoteKlineModel)this.apiModel;
            klineModel.setLimit(limit);
        }
        return this;
    }

    public QuoteKlineRequest withRight(RightOption rightOption) {
        if (rightOption != null && this.apiModel instanceof QuoteKlineModel) {
            QuoteKlineModel klineModel = (QuoteKlineModel)this.apiModel;
            klineModel.setRight(rightOption);
        }
        return this;
    }

    @Override
    public Class<QuoteKlineResponse> getResponseClass() {
        return QuoteKlineResponse.class;
    }
}

