/*
 * Decompiled with CFR 0.152.
 */
package com.tigerbrokers.stock.openapi.client.util;

import com.alibaba.fastjson.JSON;
import com.tigerbrokers.stock.openapi.client.config.ClientConfig;
import com.tigerbrokers.stock.openapi.client.struct.enums.Env;
import com.tigerbrokers.stock.openapi.client.struct.enums.License;
import com.tigerbrokers.stock.openapi.client.struct.enums.Protocol;
import com.tigerbrokers.stock.openapi.client.util.ApiLogger;
import com.tigerbrokers.stock.openapi.client.util.HttpUtils;
import com.tigerbrokers.stock.openapi.client.util.StringUtils;
import io.netty.handler.ssl.OpenSsl;
import io.netty.handler.ssl.SslProvider;
import java.lang.reflect.Field;
import java.net.Inet4Address;
import java.net.Inet6Address;
import java.net.InetAddress;
import java.net.NetworkInterface;
import java.net.UnknownHostException;
import java.util.Collections;
import java.util.Enumeration;
import java.util.HashSet;
import java.util.LinkedHashSet;
import java.util.List;
import java.util.Map;
import java.util.Random;
import java.util.Set;

public class NetworkUtil {
    private static final String GET_DEVICE_ERROR = "Please check if the network connection is disconnected";
    private static final int MAC_ARRAY_LENGTH = 6;
    private static final int MAC_LENGTH = 17;
    private static final Set<String> ONLINE_DOMAIN_SET = new HashSet<String>(){
        {
            this.add("openapi.skytigris.cn");
            this.add("openapi.itiger.com");
        }
    };

    private NetworkUtil() {
    }

    public static String getDeviceId() {
        InetAddress inetAddress = null;
        try {
            inetAddress = NetworkUtil.getLocalHostLANAddress();
        }
        catch (Throwable th) {
            ApiLogger.error("getLocalHostLANAddress failed. {}, {}", (Object)th.getMessage(), (Object)GET_DEVICE_ERROR);
        }
        return NetworkUtil.getMacFromInetAddress(inetAddress);
    }

    public static String getMacFromInetAddress(InetAddress inetAddress) {
        byte[] mac = null;
        if (inetAddress != null) {
            try {
                mac = NetworkInterface.getByInetAddress(inetAddress).getHardwareAddress();
            }
            catch (Throwable th) {
                ApiLogger.info("getHardwareAddress failed. {}", th.getMessage());
            }
        }
        if (mac == null || mac.length != 6) {
            String[] items;
            String ip;
            if (inetAddress != null && inetAddress instanceof Inet6Address) {
                ip = inetAddress.getHostAddress();
                items = ip.split("\\:");
                StringBuilder builder = new StringBuilder();
                for (String item : items) {
                    if (item == null || item.length() == 0 || "0".equals(item)) continue;
                    if (item.length() == 3 || item.length() == 1) {
                        item = "0" + item;
                    }
                    if (item.length() == 4) {
                        builder.append(item, 0, 2).append(':');
                        builder.append(item, 2, 4).append(':');
                        continue;
                    }
                    if (item.length() != 2) continue;
                    builder.append(item, 0, 2).append(':');
                }
                if (builder.length() >= 17) {
                    return builder.substring(0, 17);
                }
            }
            mac = new byte[6];
            if (inetAddress != null && inetAddress instanceof Inet4Address) {
                ip = inetAddress.getHostAddress();
                items = ip.split("\\.");
                for (int i = 0; i < 6; ++i) {
                    mac[i] = (byte)StringUtils.toInt(items[i % items.length], 0);
                }
            } else {
                Random random = new Random(System.currentTimeMillis());
                for (int i = 0; i < 6; ++i) {
                    mac[i] = (byte)random.nextInt(255);
                }
            }
        }
        StringBuilder deviceId = new StringBuilder();
        for (int i = 0; i < mac.length; ++i) {
            String str;
            if (i != 0) {
                deviceId.append(":");
            }
            if ((str = Integer.toHexString(mac[i] & 0xFF)).length() == 1) {
                deviceId.append(0);
            }
            deviceId.append(str);
        }
        return deviceId.toString();
    }

    private static InetAddress getLocalHostLANAddress() throws UnknownHostException {
        try {
            InetAddress candidateAddress = null;
            Enumeration<NetworkInterface> networkInterfaces = NetworkInterface.getNetworkInterfaces();
            while (networkInterfaces.hasMoreElements()) {
                NetworkInterface networkInterface = networkInterfaces.nextElement();
                if (networkInterface.isLoopback() || networkInterface.isVirtual() || networkInterface.isPointToPoint() || !networkInterface.isUp()) continue;
                Enumeration<InetAddress> inetAddresses = networkInterface.getInetAddresses();
                while (inetAddresses.hasMoreElements()) {
                    InetAddress inetAddress = inetAddresses.nextElement();
                    if (inetAddress.isLoopbackAddress()) continue;
                    if (inetAddress.isSiteLocalAddress()) {
                        return inetAddress;
                    }
                    if (candidateAddress != null) continue;
                    candidateAddress = inetAddress;
                }
            }
            if (candidateAddress != null) {
                return candidateAddress;
            }
            InetAddress jdkSuppliedAddress = InetAddress.getLocalHost();
            if (jdkSuppliedAddress == null) {
                throw new UnknownHostException("The JDK InetAddress.getLocalHost() method unexpectedly returned null.");
            }
            return jdkSuppliedAddress;
        }
        catch (Exception e) {
            UnknownHostException unknownHostException = new UnknownHostException("Failed to determine LAN address: " + e);
            unknownHostException.initCause(e);
            throw unknownHostException;
        }
    }

    public static String[] getOpenSslSupportedProtocolsSet(String[] serverSupportedProtocols, SslProvider sslProvider) {
        if (serverSupportedProtocols == null || serverSupportedProtocols.length == 0) {
            ApiLogger.error("Server Supported protocols (OpenSSL) is empty. serverSupportedProtocols:{}", serverSupportedProtocols);
            return serverSupportedProtocols;
        }
        Set<String> supportedProtocolsSet = Collections.emptySet();
        if (sslProvider == SslProvider.OPENSSL) {
            Set localSupportedProtocols = Collections.emptySet();
            try {
                Field supportedProtocolsSetField = OpenSsl.class.getDeclaredField("SUPPORTED_PROTOCOLS_SET");
                if (supportedProtocolsSetField != null) {
                    supportedProtocolsSetField.setAccessible(true);
                    localSupportedProtocols = (Set)supportedProtocolsSetField.get(OpenSsl.class);
                }
            }
            catch (Throwable th) {
                ApiLogger.error("getOpenSslSupportedProtocolsSet exception:{}", (Object)th.getMessage(), (Object)th);
            }
            if (localSupportedProtocols.isEmpty()) {
                ApiLogger.error("Local Supported protocols (OpenSSL): {}, is empty", localSupportedProtocols);
                return null;
            }
            ApiLogger.info("Local Supported protocols (OpenSSL): {}", localSupportedProtocols);
            supportedProtocolsSet = new LinkedHashSet();
            for (String protocol : serverSupportedProtocols) {
                if (!localSupportedProtocols.contains(protocol)) continue;
                supportedProtocolsSet.add(protocol);
            }
        }
        if (supportedProtocolsSet.isEmpty()) {
            String[] supportedProtocols = new String[serverSupportedProtocols.length];
            System.arraycopy(serverSupportedProtocols, 0, supportedProtocols, 0, serverSupportedProtocols.length);
            return supportedProtocols;
        }
        return supportedProtocolsSet.toArray(new String[supportedProtocolsSet.size()]);
    }

    public static boolean isOnlineEnv(String serverUrl) {
        for (String domainName : ONLINE_DOMAIN_SET) {
            if (!serverUrl.contains(domainName)) continue;
            return true;
        }
        return false;
    }

    public static String getHttpServerAddress() {
        return NetworkUtil.refreshAndGetServerAddress(Protocol.HTTP);
    }

    public static String getServerAddress() {
        return NetworkUtil.refreshAndGetServerAddress(ClientConfig.DEFAULT_CONFIG.getSubscribeProtocol());
    }

    public static String getServerAddress(ClientConfig clientConfig) {
        return NetworkUtil.refreshAndGetServerAddress(clientConfig.getSubscribeProtocol());
    }

    private static String refreshAndGetServerAddress(Protocol protocol) {
        Env env = ClientConfig.DEFAULT_CONFIG.getEnv();
        String domainUrl = env == Env.PROD ? "openapi.skytigris.cn" : "openapi-sandbox.skytigris.cn";
        String port = "";
        if (protocol != Protocol.HTTP) {
            port = env == Env.PROD ? (protocol == Protocol.STOMP ? "9887" : "9883") : (protocol == Protocol.STOMP ? "9889" : "9885");
        }
        String data = null;
        try {
            data = HttpUtils.get("https://cg.play-analytics.com/");
        }
        catch (Throwable throwable) {
            // empty catch block
        }
        if (StringUtils.isEmpty(data)) {
            return String.format(protocol.getUrlFormat(), domainUrl, port);
        }
        Map returnMap = null;
        try {
            returnMap = (Map)JSON.parseObject((String)data, Map.class);
        }
        catch (Exception e) {
            ApiLogger.error("domain config response error, data:{}", data);
        }
        if (returnMap == null || returnMap.get("items") == null) {
            return String.format(protocol.getUrlFormat(), domainUrl, port);
        }
        License license = ClientConfig.DEFAULT_CONFIG.getLicense();
        List list = (List)returnMap.get("items");
        boolean match = false;
        for (Map configMap : list) {
            Map dataMap = null;
            Object openapiConfig = configMap.get(env.getConfigFieldName());
            if (openapiConfig instanceof Map) {
                dataMap = (Map)openapiConfig;
            }
            if (dataMap == null) continue;
            for (Map.Entry entry : dataMap.entrySet()) {
                if (Protocol.STOMP.getPortFieldName().equals(entry.getKey()) || Protocol.SOCKET.getPortFieldName().equals(entry.getKey())) {
                    if (!protocol.getPortFieldName().equals(entry.getKey())) continue;
                    port = entry.getValue().toString();
                    continue;
                }
                String value = entry.getValue().toString();
                if (value.startsWith("https://")) {
                    value = value.substring("https://".length());
                }
                if (env == Env.PROD) {
                    ONLINE_DOMAIN_SET.add(value);
                }
                if (license.name().equals(entry.getKey())) {
                    domainUrl = value;
                    match = true;
                }
                if (!"COMMON".equals(entry.getKey()) || match) continue;
                domainUrl = value;
            }
        }
        return String.format(protocol.getUrlFormat(), domainUrl, port);
    }
}

