/*
 * Decompiled with CFR 0.152.
 */
package com.tigerbrokers.stock.openapi.client.https.domain.option.model;

import com.tigerbrokers.stock.openapi.client.https.domain.ApiModel;
import com.tigerbrokers.stock.openapi.client.struct.enums.TimeZoneId;
import com.tigerbrokers.stock.openapi.client.util.DateUtils;
import java.util.Date;

public class OptionChainModel
extends ApiModel {
    private String symbol;
    private Long expiry;

    public OptionChainModel() {
    }

    public OptionChainModel(String symbol, Long expiry) {
        this.symbol = symbol;
        this.expiry = expiry;
    }

    public OptionChainModel(String symbol, String expiry) {
        this.symbol = symbol;
        Date date = DateUtils.getZoneDate(expiry, TimeZoneId.NewYork);
        if (date != null) {
            this.expiry = date.getTime();
        }
    }

    public String getSymbol() {
        return this.symbol;
    }

    public void setSymbol(String symbol) {
        this.symbol = symbol;
    }

    public Long getExpiry() {
        return this.expiry;
    }

    public void setExpiry(Long expiry) {
        this.expiry = expiry;
    }

    public void setExpiry(String expiry) {
        Date date = DateUtils.getZoneDate(expiry, TimeZoneId.NewYork);
        if (date != null) {
            this.expiry = date.getTime();
        }
    }

    public String toString() {
        return "OptionChainModel{symbol='" + this.symbol + '\'' + ", expiry='" + this.expiry + '\'' + '}';
    }
}

