/*
 * Decompiled with CFR 0.152.
 */
package com.tigerbrokers.stock.openapi.client.socket;

import com.tigerbrokers.stock.openapi.client.util.ApiLogger;
import com.tigerbrokers.stock.openapi.client.util.TigerSignature;

public class ApiAuthentication {
    private String tigerId;
    private String sign;
    private String version = "1.0";

    public ApiAuthentication(String tigerId) {
        this.tigerId = tigerId;
    }

    public String getTigerId() {
        return this.tigerId;
    }

    public String getSign() {
        return this.sign;
    }

    public void setSign(String sign) {
        this.sign = sign;
    }

    public String getVersion() {
        return this.version;
    }

    public void setVersion(String version) {
        this.version = version;
    }

    public static ApiAuthentication build(String tigerId, String privateKey) {
        return ApiAuthentication.build(tigerId, privateKey, "1.0");
    }

    public static ApiAuthentication build(String tigerId, String privateKey, String version) {
        ApiAuthentication authentication = new ApiAuthentication(tigerId);
        try {
            String sign = TigerSignature.rsaSign(tigerId, privateKey, "UTF-8");
            authentication.setSign(sign);
            authentication.setVersion(version);
        }
        catch (Exception e) {
            ApiLogger.error("authentication build exception:{}", (Object)e.getMessage(), (Object)e);
            return null;
        }
        return authentication;
    }
}

