/*
 * Decompiled with CFR 0.152.
 */
package com.tigerbrokers.stock.openapi.client.https.validator;

import com.tigerbrokers.stock.openapi.client.TigerApiException;
import com.tigerbrokers.stock.openapi.client.https.domain.ApiModel;
import com.tigerbrokers.stock.openapi.client.https.domain.BatchApiModel;
import com.tigerbrokers.stock.openapi.client.https.domain.contract.model.ContractModel;
import com.tigerbrokers.stock.openapi.client.https.domain.contract.model.ContractsModel;
import com.tigerbrokers.stock.openapi.client.https.domain.financial.model.CorporateActionModel;
import com.tigerbrokers.stock.openapi.client.https.domain.financial.model.FinancialDailyModel;
import com.tigerbrokers.stock.openapi.client.https.domain.financial.model.FinancialReportModel;
import com.tigerbrokers.stock.openapi.client.https.domain.future.model.FutureContinuousContractModel;
import com.tigerbrokers.stock.openapi.client.https.domain.future.model.FutureContractByConCodeModel;
import com.tigerbrokers.stock.openapi.client.https.domain.future.model.FutureContractByExchCodeModel;
import com.tigerbrokers.stock.openapi.client.https.domain.future.model.FutureCurrentContractModel;
import com.tigerbrokers.stock.openapi.client.https.domain.future.model.FutureExchangeModel;
import com.tigerbrokers.stock.openapi.client.https.domain.future.model.FutureKlineModel;
import com.tigerbrokers.stock.openapi.client.https.domain.future.model.FutureRealTimeQuoteModel;
import com.tigerbrokers.stock.openapi.client.https.domain.future.model.FutureTickModel;
import com.tigerbrokers.stock.openapi.client.https.domain.future.model.FutureTradingDateModel;
import com.tigerbrokers.stock.openapi.client.https.domain.option.model.OptionChainModel;
import com.tigerbrokers.stock.openapi.client.https.domain.option.model.OptionChainV3Model;
import com.tigerbrokers.stock.openapi.client.https.domain.option.model.OptionExpirationModel;
import com.tigerbrokers.stock.openapi.client.https.domain.quote.model.QuoteCapitalFlowModel;
import com.tigerbrokers.stock.openapi.client.https.domain.quote.model.QuoteCapitalModel;
import com.tigerbrokers.stock.openapi.client.https.domain.quote.model.QuoteContractModel;
import com.tigerbrokers.stock.openapi.client.https.domain.quote.model.QuoteDepthModel;
import com.tigerbrokers.stock.openapi.client.https.domain.quote.model.QuoteHistoryTimelineModel;
import com.tigerbrokers.stock.openapi.client.https.domain.quote.model.QuoteKlineModel;
import com.tigerbrokers.stock.openapi.client.https.domain.quote.model.QuoteMarketModel;
import com.tigerbrokers.stock.openapi.client.https.domain.quote.model.QuoteStockBrokerModel;
import com.tigerbrokers.stock.openapi.client.https.domain.quote.model.QuoteStockTradeModel;
import com.tigerbrokers.stock.openapi.client.https.domain.quote.model.QuoteTimelineModel;
import com.tigerbrokers.stock.openapi.client.https.domain.quote.model.QuoteTradeTickModel;
import com.tigerbrokers.stock.openapi.client.https.domain.quote.model.TradeCalendarModel;
import com.tigerbrokers.stock.openapi.client.https.domain.trade.model.PrimeAnalyticsAssetModel;
import com.tigerbrokers.stock.openapi.client.https.domain.trade.model.TradeOrderModel;
import com.tigerbrokers.stock.openapi.client.https.validator.BatchRequestValidator;
import com.tigerbrokers.stock.openapi.client.https.validator.ContractRequestValidator;
import com.tigerbrokers.stock.openapi.client.https.validator.CorporateActionRequestValidator;
import com.tigerbrokers.stock.openapi.client.https.validator.FinancialDailyRequestValidator;
import com.tigerbrokers.stock.openapi.client.https.validator.FinancialReportRequestValidator;
import com.tigerbrokers.stock.openapi.client.https.validator.FutureContractRequestValidator;
import com.tigerbrokers.stock.openapi.client.https.validator.FutureExchangeRequestValidator;
import com.tigerbrokers.stock.openapi.client.https.validator.FutureQuoteRequestValidator;
import com.tigerbrokers.stock.openapi.client.https.validator.KlineRequestValidator;
import com.tigerbrokers.stock.openapi.client.https.validator.OptionChainRequestValidator;
import com.tigerbrokers.stock.openapi.client.https.validator.OptionExpirationRequestValidator;
import com.tigerbrokers.stock.openapi.client.https.validator.PlaceOrderRequestValidator;
import com.tigerbrokers.stock.openapi.client.https.validator.PrimeAnalyticsAssetRequestValidator;
import com.tigerbrokers.stock.openapi.client.https.validator.QuoteRequestValidator;
import com.tigerbrokers.stock.openapi.client.https.validator.RequestValidator;
import com.tigerbrokers.stock.openapi.client.https.validator.TradeCalendarRequestValidator;
import java.util.HashMap;
import java.util.Map;

public class ValidatorManager {
    private Map<Class<? extends ApiModel>, RequestValidator> validatorMap = new HashMap<Class<? extends ApiModel>, RequestValidator>();
    private static ValidatorManager single = new ValidatorManager();

    private ValidatorManager() {
        this.validatorMap.put(BatchApiModel.class, new BatchRequestValidator());
        ContractRequestValidator contractRequestValidator = new ContractRequestValidator();
        this.validatorMap.put(ContractModel.class, contractRequestValidator);
        this.validatorMap.put(ContractsModel.class, contractRequestValidator);
        QuoteRequestValidator quoteRequestValidator = new QuoteRequestValidator();
        this.validatorMap.put(QuoteDepthModel.class, quoteRequestValidator);
        this.validatorMap.put(QuoteMarketModel.class, quoteRequestValidator);
        this.validatorMap.put(QuoteStockTradeModel.class, quoteRequestValidator);
        this.validatorMap.put(QuoteContractModel.class, quoteRequestValidator);
        this.validatorMap.put(QuoteTimelineModel.class, quoteRequestValidator);
        this.validatorMap.put(QuoteHistoryTimelineModel.class, quoteRequestValidator);
        this.validatorMap.put(QuoteTradeTickModel.class, quoteRequestValidator);
        this.validatorMap.put(QuoteStockBrokerModel.class, quoteRequestValidator);
        this.validatorMap.put(QuoteCapitalModel.class, quoteRequestValidator);
        this.validatorMap.put(QuoteCapitalFlowModel.class, quoteRequestValidator);
        this.validatorMap.put(TradeCalendarModel.class, new TradeCalendarRequestValidator());
        FutureContractRequestValidator futureContractRequestValidator = new FutureContractRequestValidator();
        this.validatorMap.put(FutureContinuousContractModel.class, futureContractRequestValidator);
        this.validatorMap.put(FutureContractByConCodeModel.class, futureContractRequestValidator);
        this.validatorMap.put(FutureContractByExchCodeModel.class, futureContractRequestValidator);
        this.validatorMap.put(FutureCurrentContractModel.class, futureContractRequestValidator);
        this.validatorMap.put(FutureExchangeModel.class, new FutureExchangeRequestValidator());
        FutureQuoteRequestValidator futureQuoteRequestValidator = new FutureQuoteRequestValidator();
        this.validatorMap.put(FutureRealTimeQuoteModel.class, futureQuoteRequestValidator);
        this.validatorMap.put(FutureTickModel.class, futureQuoteRequestValidator);
        this.validatorMap.put(FutureTradingDateModel.class, futureQuoteRequestValidator);
        OptionChainRequestValidator optionChainRequestValidator = new OptionChainRequestValidator();
        this.validatorMap.put(OptionChainModel.class, optionChainRequestValidator);
        this.validatorMap.put(OptionChainV3Model.class, optionChainRequestValidator);
        this.validatorMap.put(OptionExpirationModel.class, new OptionExpirationRequestValidator());
        this.validatorMap.put(TradeOrderModel.class, new PlaceOrderRequestValidator());
        KlineRequestValidator klineRequestValidator = new KlineRequestValidator();
        this.validatorMap.put(QuoteKlineModel.class, klineRequestValidator);
        this.validatorMap.put(FutureKlineModel.class, klineRequestValidator);
        this.validatorMap.put(PrimeAnalyticsAssetModel.class, new PrimeAnalyticsAssetRequestValidator());
        this.validatorMap.put(CorporateActionModel.class, new CorporateActionRequestValidator());
        this.validatorMap.put(FinancialDailyModel.class, new FinancialDailyRequestValidator());
        this.validatorMap.put(FinancialReportModel.class, new FinancialReportRequestValidator());
    }

    public static ValidatorManager getInstance() {
        return single;
    }

    public void validate(ApiModel apiModel) throws TigerApiException {
        if (apiModel == null) {
            return;
        }
        RequestValidator validator = this.validatorMap.get(apiModel.getClass());
        if (validator == null) {
            return;
        }
        validator.validate(apiModel);
    }
}

