/*
 * Decompiled with CFR 0.152.
 */
package com.tigerbrokers.stock.openapi.client.socket;

import com.google.protobuf.MessageLite;
import com.tigerbrokers.stock.openapi.client.config.ClientConfig;
import com.tigerbrokers.stock.openapi.client.socket.ApiAuthentication;
import com.tigerbrokers.stock.openapi.client.socket.ApiComposeCallback;
import com.tigerbrokers.stock.openapi.client.socket.ApiComposeCallback4Stomp;
import com.tigerbrokers.stock.openapi.client.socket.ProtoSocketHandler;
import com.tigerbrokers.stock.openapi.client.socket.SubscribeAsyncApi;
import com.tigerbrokers.stock.openapi.client.socket.WebSocketHandler;
import com.tigerbrokers.stock.openapi.client.socket.data.pb.Request;
import com.tigerbrokers.stock.openapi.client.socket.data.pb.Response;
import com.tigerbrokers.stock.openapi.client.struct.ClientHeartBeatData;
import com.tigerbrokers.stock.openapi.client.struct.enums.Market;
import com.tigerbrokers.stock.openapi.client.struct.enums.QuoteSubject;
import com.tigerbrokers.stock.openapi.client.struct.enums.Subject;
import com.tigerbrokers.stock.openapi.client.util.ApiLogger;
import com.tigerbrokers.stock.openapi.client.util.FileUtil;
import com.tigerbrokers.stock.openapi.client.util.NetworkUtil;
import com.tigerbrokers.stock.openapi.client.util.ProtoMessageUtil;
import com.tigerbrokers.stock.openapi.client.util.StompMessageUtil;
import com.tigerbrokers.stock.openapi.client.util.StringUtils;
import io.netty.bootstrap.Bootstrap;
import io.netty.channel.Channel;
import io.netty.channel.ChannelFuture;
import io.netty.channel.ChannelHandler;
import io.netty.channel.ChannelInitializer;
import io.netty.channel.ChannelOption;
import io.netty.channel.ChannelPipeline;
import io.netty.channel.EventLoopGroup;
import io.netty.channel.nio.NioEventLoopGroup;
import io.netty.channel.socket.SocketChannel;
import io.netty.channel.socket.nio.NioSocketChannel;
import io.netty.handler.codec.protobuf.ProtobufDecoder;
import io.netty.handler.codec.protobuf.ProtobufEncoder;
import io.netty.handler.codec.protobuf.ProtobufVarint32FrameDecoder;
import io.netty.handler.codec.protobuf.ProtobufVarint32LengthFieldPrepender;
import io.netty.handler.codec.stomp.StompFrame;
import io.netty.handler.codec.stomp.StompHeaders;
import io.netty.handler.codec.stomp.StompSubframeAggregator;
import io.netty.handler.codec.stomp.StompSubframeDecoder;
import io.netty.handler.codec.stomp.StompSubframeEncoder;
import io.netty.handler.ssl.SslContext;
import io.netty.handler.ssl.SslContextBuilder;
import io.netty.handler.ssl.SslProvider;
import io.netty.handler.ssl.util.InsecureTrustManagerFactory;
import io.netty.util.internal.ConcurrentSet;
import java.net.InetSocketAddress;
import java.net.SocketAddress;
import java.net.URI;
import java.net.URISyntaxException;
import java.util.Set;
import java.util.concurrent.CopyOnWriteArraySet;
import java.util.concurrent.CountDownLatch;
import java.util.concurrent.Executors;
import java.util.concurrent.ScheduledFuture;
import java.util.concurrent.ScheduledThreadPoolExecutor;
import java.util.concurrent.ThreadFactory;
import java.util.concurrent.TimeUnit;
import java.util.concurrent.atomic.AtomicBoolean;
import java.util.concurrent.atomic.AtomicInteger;
import javax.net.ssl.SSLException;

public class WebSocketClient
implements SubscribeAsyncApi {
    public static final String SOCKET_ENCODER = "socketEncoder";
    public static final String SOCKET_DECODER = "socketDecoder";
    private static final String[] PROTOCOLS = new String[]{"TLSv1", "TLSv1.1", "TLSv1.2", "TLSv1.3"};
    private ClientConfig clientConfig;
    private SslProvider sslProvider = null;
    private String url;
    private boolean isProtobuf = true;
    private ApiAuthentication authentication;
    private ApiComposeCallback apiComposeCallback;
    private final Set<Subject> subscribeList = new CopyOnWriteArraySet<Subject>();
    private final Set<String> subscribeSymbols = new ConcurrentSet();
    private volatile CountDownLatch connectCountDown = new CountDownLatch(1);
    private EventLoopGroup group = null;
    private Bootstrap bootstrap = null;
    private volatile Channel channel = null;
    private ChannelFuture future = null;
    private SslContext sslCtx;
    private volatile boolean isInitial = false;
    private volatile ScheduledFuture<?> reconnectExecutorFuture = null;
    private ScheduledThreadPoolExecutor reconnectExecutorService = new ScheduledThreadPoolExecutor(1);
    private long lastConnectedTime = System.currentTimeMillis();
    private AtomicInteger reconnectCount = new AtomicInteger(0);
    private AtomicBoolean reconnectErrorLogFlag = new AtomicBoolean(false);
    private static final int CONNECT_TIMEOUT = 5000;
    private static final int OP_TIMEOUT = 5000;
    private static final long SHUTDOWN_TIMEOUT = 900000L;
    private static final int RECONNECT_WARNING_PERIOD = 1800;
    private static final long RECONNECT_DELAY_TIME = 3000L;
    private static final long RECONNECT_INTERVAL_TIME = 10000L;
    private int clientSendInterval = 30000;
    private int clientReceiveInterval = 30000;
    private static final int CLIENT_SEND_INTERVAL_MIN = 10000;
    private static final int CLIENT_RECEIVE_INTERVAL_MIN = 10000;

    private WebSocketClient() {
    }

    public static WebSocketClient getInstance() {
        return SingletonInner.singleton;
    }

    public WebSocketClient sslProvider(SslProvider sslProvider) {
        this.sslProvider = sslProvider;
        return this;
    }

    public WebSocketClient clientConfig(ClientConfig clientConfig) {
        FileUtil.loadConfigFile(clientConfig);
        this.clientConfig = clientConfig;
        this.url = NetworkUtil.getServerAddress(null);
        if (this.sslProvider == null && clientConfig.getSslProvider() != null) {
            this.sslProvider = clientConfig.getSslProvider();
        }
        if (this.authentication == null) {
            ApiAuthentication authentication = ApiAuthentication.build(clientConfig.tigerId, clientConfig.privateKey);
            if (!StringUtils.isEmpty(clientConfig.version)) {
                authentication.setVersion(clientConfig.version);
            }
            this.authentication = authentication;
        }
        return this;
    }

    public WebSocketClient apiComposeCallback(ApiComposeCallback apiComposeCallback) {
        this.apiComposeCallback = apiComposeCallback;
        return this;
    }

    public WebSocketClient clientHeartBeatData(ClientHeartBeatData clientHeartBeatData) {
        if (clientHeartBeatData != null) {
            if (clientHeartBeatData.getSendInterval() >= 0) {
                int n = this.clientSendInterval = clientHeartBeatData.getSendInterval() >= 10000 ? clientHeartBeatData.getSendInterval() : 10000;
            }
            if (clientHeartBeatData.getReceiveInterval() >= 0) {
                this.clientReceiveInterval = clientHeartBeatData.getReceiveInterval() >= 10000 ? clientHeartBeatData.getReceiveInterval() : 10000;
            }
        }
        return this;
    }

    private void checkArgument() {
        if (this.url == null || this.url.isEmpty()) {
            throw new IllegalArgumentException("url is empty.");
        }
        if (this.authentication == null) {
            throw new IllegalArgumentException("authentication info is missing.");
        }
        if (this.apiComposeCallback == null) {
            throw new IllegalArgumentException("apiComposeCallback is missing.");
        }
        if (this.apiComposeCallback instanceof ApiComposeCallback4Stomp) {
            this.isProtobuf = false;
        } else if (this.apiComposeCallback instanceof ApiComposeCallback) {
            this.isProtobuf = true;
        } else {
            throw new IllegalArgumentException("please use ApiComposeCallback's instance.");
        }
        if (this.connectCountDown.getCount() == 0L) {
            this.connectCountDown = new CountDownLatch(1);
        }
    }

    private synchronized void init() throws SSLException {
        if (this.isInitial) {
            return;
        }
        this.group = new NioEventLoopGroup(1);
        this.bootstrap = new Bootstrap();
        if (this.clientConfig.isSslSocket) {
            SslProvider provider = this.sslProvider == null ? SslProvider.OPENSSL : this.sslProvider;
            String[] protocols = NetworkUtil.getSupportedProtocolsSet(PROTOCOLS, provider);
            if (protocols == null || protocols.length == 0) {
                throw new RuntimeException("supported protocols is empty.");
            }
            this.sslCtx = SslContextBuilder.forClient().protocols(protocols).trustManager(InsecureTrustManagerFactory.INSTANCE).sslProvider(provider).build();
        }
        ((Bootstrap)((Bootstrap)((Bootstrap)((Bootstrap)this.bootstrap.group(this.group)).option(ChannelOption.TCP_NODELAY, (Object)true)).option(ChannelOption.SO_KEEPALIVE, (Object)true)).channel(NioSocketChannel.class)).handler((ChannelHandler)new ChannelInitializer<SocketChannel>(){

            protected void initChannel(SocketChannel ch) {
                ChannelPipeline p = ch.pipeline();
                InetSocketAddress address = WebSocketClient.this.getNewServerAddress();
                if (address == null) {
                    throw new RuntimeException("get connect address error.");
                }
                if (((WebSocketClient)WebSocketClient.this).clientConfig.isSslSocket) {
                    p.addLast("sslHandler", (ChannelHandler)WebSocketClient.this.sslCtx.newHandler(ch.alloc(), address.getHostName(), address.getPort()));
                }
                if (WebSocketClient.this.isProtobuf) {
                    ProtoSocketHandler handler = new ProtoSocketHandler(WebSocketClient.this.authentication, WebSocketClient.this.apiComposeCallback, WebSocketClient.this.clientSendInterval, WebSocketClient.this.clientReceiveInterval);
                    p.addLast(WebSocketClient.SOCKET_DECODER, (ChannelHandler)new ProtobufVarint32FrameDecoder());
                    p.addLast(new ChannelHandler[]{new ProtobufDecoder((MessageLite)Response.getDefaultInstance())});
                    p.addLast(new ChannelHandler[]{new ProtobufVarint32LengthFieldPrepender()});
                    p.addLast(WebSocketClient.SOCKET_ENCODER, (ChannelHandler)new ProtobufEncoder());
                    p.addLast("webSocketHandler", (ChannelHandler)handler);
                } else {
                    WebSocketHandler handler = new WebSocketHandler(WebSocketClient.this.authentication, WebSocketClient.this.apiComposeCallback, WebSocketClient.this.clientSendInterval, WebSocketClient.this.clientReceiveInterval);
                    p.addLast(WebSocketClient.SOCKET_ENCODER, (ChannelHandler)new StompSubframeEncoder());
                    p.addLast(WebSocketClient.SOCKET_DECODER, (ChannelHandler)new StompSubframeDecoder());
                    p.addLast("aggregator", (ChannelHandler)new StompSubframeAggregator(65535));
                    p.addLast("webSocketHandler", (ChannelHandler)handler);
                }
            }
        });
        this.isInitial = true;
    }

    public void connectCountDown() {
        this.connectCountDown.countDown();
    }

    public synchronized void connect() {
        try {
            if (this.isConnected()) {
                return;
            }
            this.checkArgument();
            this.initReconnectCommand();
            this.doConnect();
            if (!this.isConnected()) {
                throw new Exception("Failed connect to server.");
            }
            ApiLogger.info("Success connect to server, channel is: {}", this.channel);
            this.reconnectCount.set(0);
            this.reconnectErrorLogFlag.set(false);
        }
        catch (Throwable e) {
            ApiLogger.error("Failed connect to server, cause: ", e);
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    private void doConnect() {
        block14: {
            try {
                long start = System.currentTimeMillis();
                this.init();
                InetSocketAddress address = this.getNewServerAddress();
                if (address == null) {
                    throw new RuntimeException("get connect address error.");
                }
                this.future = this.bootstrap.connect((SocketAddress)address).sync();
                boolean completed = this.future.awaitUninterruptibly(5000L, TimeUnit.MILLISECONDS);
                if (completed && this.future.isSuccess()) {
                    Channel newChannel = this.future.channel();
                    try {
                        Channel oldChannel = this.channel;
                        if (oldChannel != null && oldChannel.isActive()) {
                            ApiLogger.info("close old netty channel:{} , create new netty channel:{} ", oldChannel, newChannel);
                            oldChannel.close();
                        }
                        break block14;
                    }
                    finally {
                        this.channel = newChannel;
                        this.connectCountDown.await(5000L, TimeUnit.MILLISECONDS);
                        if (this.connectCountDown.getCount() > 0L) {
                            this.channel.close();
                        }
                    }
                }
                if (this.future.cause() != null) {
                    throw new Exception("client failed to connect to server, error message is:" + this.future.cause().getMessage(), this.future.cause());
                }
                throw new Exception("client failed to connect to server, client-side timeout: " + (System.currentTimeMillis() - start) + "ms ");
            }
            catch (Exception e) {
                ApiLogger.error("client failed to connect to server: ", e);
            }
            finally {
                if (this.future != null && !this.isConnected()) {
                    this.future.cancel(true);
                }
            }
        }
    }

    private InetSocketAddress getNewServerAddress() {
        InetSocketAddress address;
        String newUrl;
        if (this.clientConfig != null && !this.url.equals(newUrl = NetworkUtil.getServerAddress(this.url)) && (address = this.getSocketAddress(newUrl)) != null) {
            ApiLogger.info("socket url changed. {}-->{}", this.url, newUrl);
            if (this.channel != null && this.channel.pipeline().get("sslHandler") != null) {
                ChannelHandler oldHandler = this.channel.pipeline().get("sslHandler");
                this.channel.pipeline().replace(oldHandler, "sslHandler", (ChannelHandler)this.sslCtx.newHandler(this.channel.alloc(), address.getHostName(), address.getPort()));
                ApiLogger.info("socket url changed. {}-->{}. replace sslHandler", this.url, newUrl);
            }
            this.url = newUrl;
            return address;
        }
        return this.getSocketAddress();
    }

    private InetSocketAddress getSocketAddress() {
        return this.getSocketAddress(this.url);
    }

    private InetSocketAddress getSocketAddress(String urlString) {
        URI uri;
        if (StringUtils.isEmpty(urlString)) {
            ApiLogger.error("url is empty.");
            return null;
        }
        try {
            uri = new URI(urlString);
        }
        catch (URISyntaxException e) {
            ApiLogger.error("uri syntax exception:{}", (Object)urlString, (Object)e);
            return null;
        }
        return new InetSocketAddress(uri.getHost(), uri.getPort());
    }

    public String getUrl() {
        return this.url;
    }

    public boolean isUseProtobuf() {
        return this.isProtobuf;
    }

    public void disconnect() {
        this.closeConnect(true);
    }

    public void closeConnect(boolean sendDisconnectCommand) {
        this.destroyConnectCommand();
        if (sendDisconnectCommand) {
            this.sendDisconnectData();
        }
        try {
            if (this.channel != null) {
                this.channel.close();
            }
            this.channel = null;
        }
        catch (Throwable e) {
            ApiLogger.error(e.getMessage(), e);
        }
        try {
            this.group.shutdownGracefully();
        }
        catch (Throwable t) {
            ApiLogger.error(t.getMessage());
        }
        finally {
            this.isInitial = false;
        }
    }

    private synchronized void sendDisconnectData() {
        if (!this.isConnected()) {
            this.notConnect();
            return;
        }
        Request disconnectData = this.isProtobuf ? ProtoMessageUtil.buildDisconnectMessage() : StompMessageUtil.buildDisconnectMessage(this.authentication.getTigerId());
        ChannelFuture channelFuture = this.channel.writeAndFlush((Object)disconnectData);
        try {
            channelFuture.sync();
            ApiLogger.info("sendDisconnect finished, tiger id:{}", this.authentication.getTigerId());
        }
        catch (InterruptedException e) {
            ApiLogger.error("sendDisconnect error, tiger id:{}", (Object)this.authentication.getTigerId(), (Object)e);
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    private void destroyConnectCommand() {
        WebSocketClient webSocketClient = SingletonInner.singleton;
        synchronized (webSocketClient) {
            try {
                if (this.reconnectExecutorFuture != null && !this.reconnectExecutorFuture.isDone()) {
                    this.reconnectExecutorFuture.cancel(true);
                    this.reconnectExecutorService.purge();
                    this.reconnectExecutorService.shutdownNow();
                }
            }
            catch (Throwable e) {
                ApiLogger.error(e.getMessage(), e);
            }
            this.reconnectCount.set(0);
            this.reconnectErrorLogFlag.set(false);
        }
    }

    public boolean isConnected() {
        if (this.channel == null || this.connectCountDown.getCount() > 0L) {
            return false;
        }
        return this.channel.isActive();
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    private void initReconnectCommand() {
        WebSocketClient webSocketClient = SingletonInner.singleton;
        synchronized (webSocketClient) {
            if (this.reconnectExecutorFuture == null || this.reconnectExecutorFuture.isCancelled()) {
                Runnable reconnectCommand = new Runnable(){

                    @Override
                    public void run() {
                        block5: {
                            try {
                                if (!WebSocketClient.this.isConnected()) {
                                    WebSocketClient.this.connect();
                                } else {
                                    WebSocketClient.this.lastConnectedTime = System.currentTimeMillis();
                                }
                            }
                            catch (Throwable t) {
                                if (System.currentTimeMillis() - WebSocketClient.this.lastConnectedTime > 900000L && !WebSocketClient.this.reconnectErrorLogFlag.get()) {
                                    WebSocketClient.this.reconnectErrorLogFlag.set(true);
                                    ApiLogger.error("client reconnect to server error, lastConnectedTime:{}, currentTime:{}", WebSocketClient.this.lastConnectedTime, System.currentTimeMillis(), t);
                                    return;
                                }
                                if (WebSocketClient.this.reconnectCount.getAndIncrement() % 1800 != 0) break block5;
                                ApiLogger.error("client reconnect to server error, lastConnectedTime:{}, currentTime:{}", WebSocketClient.this.lastConnectedTime, System.currentTimeMillis(), t);
                            }
                        }
                    }
                };
                if (this.reconnectExecutorService.isShutdown()) {
                    this.reconnectExecutorService = new ScheduledThreadPoolExecutor(1, new ThreadFactory(){

                        @Override
                        public Thread newThread(Runnable r) {
                            Thread t = Executors.defaultThreadFactory().newThread(r);
                            t.setDaemon(true);
                            return t;
                        }
                    });
                }
                this.reconnectExecutorFuture = this.reconnectExecutorService.scheduleWithFixedDelay(reconnectCommand, 3000L, 10000L, TimeUnit.MILLISECONDS);
            }
        }
    }

    @Override
    public String subscribe(Subject subject) {
        return this.subscribe(null, subject);
    }

    @Override
    public String subscribe(String account, Subject subject) {
        String returnStr;
        Request subscribeData;
        if (!this.isConnected()) {
            this.notConnect();
            return null;
        }
        if (this.isProtobuf) {
            subscribeData = ProtoMessageUtil.buildSubscribeMessage(account, subject);
            returnStr = String.valueOf(subscribeData.getId());
        } else {
            subscribeData = StompMessageUtil.buildSubscribeMessage(account, subject, null);
            returnStr = ((StompFrame)subscribeData).headers().getAsString((CharSequence)StompHeaders.ID);
        }
        this.channel.writeAndFlush((Object)subscribeData);
        this.subscribeList.add(subject);
        return returnStr;
    }

    @Override
    public String cancelSubscribe(Subject subject) {
        String returnStr;
        Request unsubscribeData;
        if (!this.isConnected()) {
            this.notConnect();
            return null;
        }
        if (this.isProtobuf) {
            unsubscribeData = ProtoMessageUtil.buildUnSubscribeMessage(subject);
            returnStr = String.valueOf(unsubscribeData.getId());
        } else {
            unsubscribeData = StompMessageUtil.buildUnSubscribeMessage(subject);
            returnStr = ((StompFrame)unsubscribeData).headers().getAsString((CharSequence)StompHeaders.ID);
        }
        this.channel.writeAndFlush((Object)unsubscribeData);
        this.subscribeList.remove((Object)subject);
        return returnStr;
    }

    @Override
    public String subscribeQuote(Set<String> symbols) {
        return this.subscribeQuote(symbols, QuoteSubject.Quote);
    }

    @Override
    public String cancelSubscribeQuote(Set<String> symbols) {
        return this.cancelSubscribeQuote(symbols, QuoteSubject.Quote);
    }

    @Override
    public String subscribeTradeTick(Set<String> symbols) {
        return this.subscribeQuote(symbols, QuoteSubject.TradeTick);
    }

    @Override
    public String cancelSubscribeTradeTick(Set<String> symbols) {
        return this.cancelSubscribeQuote(symbols, QuoteSubject.TradeTick);
    }

    @Override
    public String subscribeOption(Set<String> symbols) {
        return this.subscribeQuote(symbols, QuoteSubject.Option);
    }

    @Override
    public String cancelSubscribeOption(Set<String> symbols) {
        return this.cancelSubscribeQuote(symbols, QuoteSubject.Option);
    }

    @Override
    public String subscribeFuture(Set<String> symbols) {
        return this.subscribeQuote(symbols, QuoteSubject.Future);
    }

    @Override
    public String cancelSubscribeFuture(Set<String> symbols) {
        return this.cancelSubscribeQuote(symbols, QuoteSubject.Future);
    }

    @Override
    public String subscribeDepthQuote(Set<String> symbols) {
        return this.subscribeQuote(symbols, QuoteSubject.QuoteDepth);
    }

    @Override
    public String cancelSubscribeDepthQuote(Set<String> symbols) {
        return this.cancelSubscribeQuote(symbols, QuoteSubject.QuoteDepth);
    }

    private String subscribeQuote(Set<String> symbols, QuoteSubject subject) {
        String returnStr;
        Request subscribeData;
        if (!this.isConnected()) {
            this.notConnect();
            return null;
        }
        if (this.isProtobuf) {
            subscribeData = ProtoMessageUtil.buildSubscribeMessage(symbols, subject);
            returnStr = String.valueOf(subscribeData.getId());
        } else {
            subscribeData = StompMessageUtil.buildSubscribeMessage(symbols, subject, null);
            returnStr = ((StompFrame)subscribeData).headers().getAsString((CharSequence)StompHeaders.ID);
        }
        this.channel.writeAndFlush((Object)subscribeData);
        this.subscribeSymbols.addAll(symbols);
        ApiLogger.info("send subscribe [{}] message, symbols:{}", (Object)subject, symbols);
        return returnStr;
    }

    private String cancelSubscribeQuote(Set<String> symbols, QuoteSubject subject) {
        String returnStr;
        Request unsubscribeData;
        if (!this.isConnected()) {
            this.notConnect();
            return null;
        }
        if (this.isProtobuf) {
            unsubscribeData = ProtoMessageUtil.buildUnSubscribeMessage(symbols, subject);
            returnStr = String.valueOf(unsubscribeData.getId());
        } else {
            unsubscribeData = StompMessageUtil.buildUnSubscribeMessage(symbols, subject);
            returnStr = ((StompFrame)unsubscribeData).headers().getAsString((CharSequence)StompHeaders.ID);
        }
        this.channel.writeAndFlush((Object)unsubscribeData);
        this.subscribeSymbols.removeAll(symbols);
        ApiLogger.info("send cancel subscribe [{}] message, symbols:{}.", (Object)subject, symbols);
        return returnStr;
    }

    @Override
    public String subscribeMarketQuote(Market market, QuoteSubject subject) {
        if (!this.isConnected()) {
            this.notConnect();
            return null;
        }
        if (this.isProtobuf) {
            Request subscribeData = ProtoMessageUtil.buildSubscribeMessage(market, subject);
            this.channel.writeAndFlush((Object)subscribeData);
            ApiLogger.info("send subscribe [{}] message, market:{}", (Object)subject, (Object)market);
            return String.valueOf(subscribeData.getId());
        }
        return null;
    }

    @Override
    public String cancelSubscribeMarketQuote(Market market, QuoteSubject subject) {
        if (!this.isConnected()) {
            this.notConnect();
            return null;
        }
        if (this.isProtobuf) {
            Request subscribeData = ProtoMessageUtil.buildUnSubscribeMessage(market, subject);
            this.channel.writeAndFlush((Object)subscribeData);
            ApiLogger.info("send cancel subscribe [{}] message, market:{}", (Object)subject, (Object)market);
            return String.valueOf(subscribeData.getId());
        }
        return null;
    }

    @Override
    public String getSubscribedSymbols() {
        String returnStr;
        Request msgData;
        if (!this.isConnected()) {
            this.notConnect();
            return null;
        }
        ApiLogger.info("send getSubscribedSymbols message");
        if (this.isProtobuf) {
            msgData = ProtoMessageUtil.buildSendMessage();
            returnStr = String.valueOf(msgData.getId());
        } else {
            msgData = StompMessageUtil.buildSendMessage(110, null);
            returnStr = ((StompFrame)msgData).headers().getAsString((CharSequence)StompHeaders.ID);
        }
        this.channel.writeAndFlush((Object)msgData);
        return returnStr;
    }

    private void notConnect() {
        ApiLogger.info("connection is closed.");
    }

    private static class SingletonInner {
        private static WebSocketClient singleton = new WebSocketClient();

        private SingletonInner() {
        }
    }
}

