/*
 * Decompiled with CFR 0.152.
 */
package com.tigerbrokers.stock.openapi.client.util;

import ch.qos.logback.classic.Level;
import ch.qos.logback.classic.Logger;
import ch.qos.logback.classic.LoggerContext;
import ch.qos.logback.classic.encoder.PatternLayoutEncoder;
import ch.qos.logback.core.Appender;
import ch.qos.logback.core.Context;
import ch.qos.logback.core.FileAppender;
import ch.qos.logback.core.encoder.Encoder;
import ch.qos.logback.core.rolling.RollingFileAppender;
import ch.qos.logback.core.rolling.RollingPolicy;
import ch.qos.logback.core.rolling.TimeBasedRollingPolicy;
import com.tigerbrokers.stock.openapi.client.constant.TigerApiConstants;
import com.tigerbrokers.stock.openapi.client.util.DateUtils;
import java.nio.file.Files;
import java.nio.file.LinkOption;
import java.nio.file.Path;
import java.nio.file.Paths;
import java.nio.file.attribute.FileAttribute;
import org.slf4j.LoggerFactory;

public class ApiLogger {
    private static Logger logger = null;
    private static boolean enabled = false;
    private static boolean debugEnabled = false;
    private static boolean infoEnabled = true;
    private static boolean warnEnabled = true;
    private static boolean errorEnabled = true;
    private static final String SPLITTER = "###";
    private static final String LOG_FILE_NAME = "tiger_openapi.log";
    private static final String LOG_FILE_PATTERN = "tiger_openapi.%d{yyyy-MM-dd}.log";

    public static void setEnabled(boolean isEnabled) {
        ApiLogger.setEnabled(isEnabled, null);
    }

    public static void setEnabled(boolean isEnabled, String logPath) {
        Logger root = (Logger)LoggerFactory.getLogger((String)"ROOT");
        root.setLevel(Level.INFO);
        if (isEnabled) {
            ApiLogger.initConfig(logPath);
        }
        enabled = isEnabled;
    }

    private static void initConfig(String logPath) {
        try {
            Path logFilePath = Paths.get(logPath == null ? "log" : logPath, LOG_FILE_NAME);
            Path parentPath = logFilePath.toAbsolutePath().getParent();
            if (Files.notExists(parentPath, new LinkOption[0])) {
                Files.createDirectories(parentPath, new FileAttribute[0]);
            }
            String fullFilename = logFilePath.toAbsolutePath().toString();
            String fullFilenamePattern = Paths.get(parentPath.toAbsolutePath().toString(), LOG_FILE_PATTERN).toAbsolutePath().toString();
            LoggerContext loggerContext = (LoggerContext)LoggerFactory.getILoggerFactory();
            PatternLayoutEncoder encoder = new PatternLayoutEncoder();
            encoder.setContext((Context)loggerContext);
            encoder.setCharset(TigerApiConstants.CHARSET_UTF8);
            encoder.setPattern("%d %level - %msg%n");
            encoder.start();
            RollingFileAppender rollingFileAppender = new RollingFileAppender();
            TimeBasedRollingPolicy timeBasedRollingPolicy = new TimeBasedRollingPolicy();
            timeBasedRollingPolicy.setParent((FileAppender)rollingFileAppender);
            timeBasedRollingPolicy.setContext((Context)loggerContext);
            timeBasedRollingPolicy.setFileNamePattern(fullFilenamePattern);
            timeBasedRollingPolicy.setMaxHistory(30);
            timeBasedRollingPolicy.start();
            rollingFileAppender.setName("TigerOpenApi");
            rollingFileAppender.setContext((Context)loggerContext);
            rollingFileAppender.setRollingPolicy((RollingPolicy)timeBasedRollingPolicy);
            rollingFileAppender.setEncoder((Encoder)encoder);
            rollingFileAppender.start();
            logger = loggerContext.getLogger("com.tigerbrokers.openapi.client");
            logger.addAppender((Appender)rollingFileAppender);
            logger.setLevel(Level.INFO);
        }
        catch (Throwable e) {
            throw new RuntimeException("an error occurred while init log config, error message:{}" + e.getMessage());
        }
    }

    public static void setDebugEnabled(boolean debugEnabled) {
        ApiLogger.debugEnabled = debugEnabled;
    }

    public static void setInfoEnabled(boolean infoEnabled) {
        ApiLogger.infoEnabled = infoEnabled;
    }

    public static void setWarnEnabled(boolean warnEnabled) {
        ApiLogger.warnEnabled = warnEnabled;
    }

    public static void setErrorEnabled(boolean errorEnabled) {
        ApiLogger.errorEnabled = errorEnabled;
    }

    public static void error(String appKey, String method, String version, Exception e) {
        ApiLogger.error(appKey, method, version, null, null, e);
    }

    public static void error(String appKey, String method, String version, String bizContent, String responseData, Exception e) {
        if (!enabled || !errorEnabled) {
            return;
        }
        try {
            StringBuilder builder = new StringBuilder();
            builder.append(DateUtils.printSystemDate());
            builder.append(SPLITTER);
            builder.append(method);
            builder.append(SPLITTER);
            builder.append(version);
            builder.append(SPLITTER);
            builder.append(bizContent);
            builder.append(SPLITTER);
            builder.append(appKey);
            builder.append(SPLITTER);
            builder.append(responseData);
            builder.append(SPLITTER);
            builder.append(e.getMessage());
            logger.error(builder.toString().replaceAll("\r\n", " "));
        }
        catch (Exception ex) {
            throw new RuntimeException("an error occurred while writing the error log, origin error message:{}" + e.getMessage());
        }
    }

    public static void error(String message, Object value, Object exception) {
        if (!enabled || !errorEnabled) {
            return;
        }
        logger.error(message, value, exception);
    }

    public static void error(String message) {
        if (!enabled || !errorEnabled) {
            return;
        }
        logger.error(message);
    }

    public static void error(String message, Object ... value) {
        if (!enabled || !errorEnabled) {
            return;
        }
        logger.error(message, value);
    }

    public static void info(String message) {
        if (!enabled || !infoEnabled) {
            return;
        }
        logger.info(message);
    }

    public static void info(String message, Object value) {
        if (!enabled || !infoEnabled) {
            return;
        }
        logger.info(message, value);
    }

    public static void info(String message, Object value1, Object value2) {
        if (!enabled || !infoEnabled) {
            return;
        }
        logger.info(message, value1, value2);
    }

    public static void info(String message, Object value1, Object value2, Object value3) {
        if (!enabled || !infoEnabled) {
            return;
        }
        logger.info(message, new Object[]{value1, value2, value3});
    }

    public static void warn(String message, Object ... args) {
        if (!enabled || !warnEnabled) {
            return;
        }
        logger.info(message, args);
    }

    public static void debug(String message, Object value) {
        if (!enabled || !debugEnabled) {
            return;
        }
        logger.info(message, value);
    }
}

