/*
 * Decompiled with CFR 0.152.
 */
package com.tigerbrokers.stock.openapi.client.util;

import com.tigerbrokers.stock.openapi.client.config.ClientConfig;
import com.tigerbrokers.stock.openapi.client.util.ApiLogger;
import com.tigerbrokers.stock.openapi.client.util.StringUtils;
import java.io.IOException;
import java.net.ConnectException;
import java.util.HashSet;
import java.util.Set;
import java.util.concurrent.TimeUnit;
import okhttp3.ConnectionPool;
import okhttp3.MediaType;
import okhttp3.OkHttpClient;
import okhttp3.Request;
import okhttp3.RequestBody;
import okhttp3.Response;

public class HttpUtils {
    public static final int CONNECT_TIMEOUT = 5000;
    public static final int SOCKET_TIMEOUT = 5000;
    public static final MediaType JSON = MediaType.parse((String)"application/json; charset=utf-8");
    private static ConnectionPool connectionPool = new ConnectionPool(5, 60L, TimeUnit.SECONDS);
    private static Set<Class<? extends Exception>> retryExceptionSet = new HashSet<Class<? extends Exception>>(){
        {
            this.add(IOException.class);
            this.add(ConnectException.class);
        }
    };
    public static OkHttpClient client = new OkHttpClient.Builder().connectTimeout(5000L, TimeUnit.MILLISECONDS).readTimeout(5000L, TimeUnit.MILLISECONDS).connectionPool(connectionPool).retryOnConnectionFailure(true).build();

    public static String post(String url, String json) throws Exception {
        return HttpUtils.post(url, json, 0);
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public static String post(String url, String json, int retryCount) throws Exception {
        if (url == null || json == null) {
            throw new RuntimeException("request url or json param cannot be null");
        }
        RequestBody body = RequestBody.create((MediaType)JSON, (String)json);
        Request.Builder builder = new Request.Builder().url(url).post(body);
        if (!StringUtils.isEmpty(ClientConfig.DEFAULT_CONFIG.token)) {
            builder.header("Authorization", ClientConfig.DEFAULT_CONFIG.token);
        }
        Request request = builder.build();
        int requstCount = 0;
        String result = null;
        boolean needRetry = retryCount > 0;
        do {
            ++requstCount;
            try {
                Response response = client.newCall(request).execute();
                if (response == null) {
                    ApiLogger.error("HttpUtils response is null");
                    throw new RuntimeException("http response is null");
                }
                if (response.body() == null) {
                    ApiLogger.error("HttpUtils response body is null");
                    throw new RuntimeException("http response body is null");
                }
                result = response.body().string();
                if (result != null && result.indexOf("internal_error:A system error occurred, please try again later") < 0) {
                    return result;
                }
                if (!(needRetry &= requstCount <= retryCount)) continue;
            }
            catch (Exception e) {
                try {
                    ApiLogger.info("HttpUtils execute[{}] times, fail:{}", requstCount, e.getMessage());
                    if (requstCount > retryCount || !retryExceptionSet.contains(e.getClass())) {
                        needRetry = false;
                        throw e;
                    }
                    if (result != null && result.indexOf("internal_error:A system error occurred, please try again later") < 0) {
                        return result;
                    }
                    if (!(needRetry &= requstCount <= retryCount)) continue;
                }
                catch (Throwable throwable) {
                    if (result != null && result.indexOf("internal_error:A system error occurred, please try again later") < 0) {
                        return result;
                    }
                    if (needRetry &= requstCount <= retryCount) {
                        HttpUtils.requestWaitInterval(requstCount);
                    }
                    throw throwable;
                }
                HttpUtils.requestWaitInterval(requstCount);
            }
            HttpUtils.requestWaitInterval(requstCount);
        } while (needRetry);
        return result;
    }

    private static void requestWaitInterval(int requstCount) {
        try {
            TimeUnit.MILLISECONDS.sleep((int)Math.pow(2.0, requstCount) * 100);
        }
        catch (InterruptedException interruptedException) {
            // empty catch block
        }
    }

    public static String get(String url) throws Exception {
        if (url == null) {
            throw new RuntimeException("request url param cannot be null");
        }
        try {
            Request request;
            Response response;
            Request.Builder builder = new Request.Builder().url(url);
            if (!StringUtils.isEmpty(ClientConfig.DEFAULT_CONFIG.token)) {
                builder.header("Authorization", ClientConfig.DEFAULT_CONFIG.token);
            }
            if ((response = client.newCall(request = builder.build()).execute()) == null) {
                ApiLogger.debug("HttpUtils response is null, url:{}", url);
                throw new RuntimeException("http response is null");
            }
            if (response.body() == null) {
                ApiLogger.debug("HttpUtils response body is null, url:{}", url);
                throw new RuntimeException("http response body is null");
            }
            return response.body().string();
        }
        catch (IOException e) {
            ApiLogger.error("HttpUtils execute io exception:{}", (Object)e.getMessage(), (Object)e);
            throw e;
        }
        catch (Exception e) {
            ApiLogger.error("HttpUtils execute exception:{}", (Object)e.getMessage(), (Object)e);
            throw e;
        }
    }
}

