/*
 * Decompiled with CFR 0.152.
 */
package com.tigerbrokers.stock.openapi.client.util;

import com.alibaba.fastjson.JSONException;
import com.alibaba.fastjson.parser.DefaultJSONParser;
import com.alibaba.fastjson.parser.JSONLexer;
import com.alibaba.fastjson.parser.deserializer.ObjectDeserializer;
import com.alibaba.fastjson.util.TypeUtils;
import java.lang.reflect.Type;

public class FastJsonBooleanDeserializer
implements ObjectDeserializer {
    public Boolean deserialze(DefaultJSONParser parser, Type type, Object fieldName) {
        Boolean boolObj;
        JSONLexer lexer = parser.lexer;
        try {
            if (lexer.token() == 6) {
                lexer.nextToken(16);
                boolObj = Boolean.TRUE;
            } else if (lexer.token() == 7) {
                lexer.nextToken(16);
                boolObj = Boolean.FALSE;
            } else if (lexer.token() == 2) {
                int intValue = lexer.intValue();
                lexer.nextToken(16);
                boolObj = intValue == 0 ? Boolean.FALSE : Boolean.TRUE;
            } else {
                Object value = parser.parse();
                if (value == null) {
                    return null;
                }
                boolObj = TypeUtils.castToBoolean((Object)value);
            }
        }
        catch (Exception var7) {
            throw new JSONException("parseBoolean error, field : " + fieldName, (Throwable)var7);
        }
        return boolObj;
    }

    public int getFastMatchToken() {
        return 6;
    }
}

