/*
 * Decompiled with CFR 0.152.
 */
package com.tigerbrokers.stock.openapi.client.config;

import com.tigerbrokers.stock.openapi.client.constant.TigerApiConstants;
import com.tigerbrokers.stock.openapi.client.struct.enums.Env;
import com.tigerbrokers.stock.openapi.client.struct.enums.Language;
import com.tigerbrokers.stock.openapi.client.struct.enums.License;
import com.tigerbrokers.stock.openapi.client.struct.enums.TimeZoneId;
import com.tigerbrokers.stock.openapi.client.util.ApiLogger;
import com.tigerbrokers.stock.openapi.client.util.ConfigFileUtil;
import io.netty.handler.ssl.SslProvider;
import java.io.File;
import java.io.FileInputStream;
import java.io.IOException;

public class ClientConfig {
    private static final Env DEFAULT_ENV = Env.PROD;
    private static final SslProvider DEFAULT_SSLPROVIDER = SslProvider.OPENSSL;
    public static final ClientConfig DEFAULT_CONFIG = new ClientConfig();
    public String configFilePath;
    private Env env = DEFAULT_ENV;
    private SslProvider sslProvider = DEFAULT_SSLPROVIDER;
    public License license;
    public String version = "3";
    public boolean isSslSocket = true;
    public String tigerId = null;
    public String defaultAccount = null;
    public String privateKey = null;
    public volatile String token = null;
    public int refreshTokenIntervalDays;
    public String refreshTokenTime;
    public boolean isAutoGrabPermission = true;
    public boolean isAutoRefreshToken = true;
    public TimeZoneId timeZone = TimeZoneId.Shanghai;
    public Language language = Language.en_US;
    public String secretKey = null;
    public int failRetryCounts = 2;
    public boolean useFullTick = false;

    private ClientConfig() {
    }

    public TimeZoneId getDefaultTimeZone() {
        return this.timeZone == null ? TimeZoneId.Shanghai : this.timeZone;
    }

    public Language getDefaultLanguage() {
        return this.language == null ? Language.en_US : this.language;
    }

    public Env getEnv() {
        return this.env;
    }

    public void setEnv(Env env) {
        if (env == null) {
            return;
        }
        this.env = env;
    }

    public SslProvider getSslProvider() {
        return this.sslProvider;
    }

    public void setSslProvider(SslProvider sslProvider) {
        this.sslProvider = sslProvider;
    }

    @Deprecated
    public String readPrivateKey(String privateKeyFile) {
        String content = "";
        File file = new File(privateKeyFile);
        try (FileInputStream in = new FileInputStream(file);){
            int size = in.available();
            byte[] buffer = new byte[size];
            in.read(buffer);
            content = ConfigFileUtil.processPrivateKey(new String(buffer, TigerApiConstants.CHARSET_UTF8));
        }
        catch (IOException e) {
            ApiLogger.error("read file fail:" + privateKeyFile, e);
        }
        return content;
    }
}

