/*
 * Decompiled with CFR 0.152.
 */
package com.tigerbrokers.stock.openapi.client.https.request.quote;

import com.tigerbrokers.stock.openapi.client.config.ClientConfig;
import com.tigerbrokers.stock.openapi.client.https.domain.quote.model.QuoteContractModel;
import com.tigerbrokers.stock.openapi.client.https.request.TigerCommonRequest;
import com.tigerbrokers.stock.openapi.client.https.request.TigerRequest;
import com.tigerbrokers.stock.openapi.client.https.response.quote.QuoteContractResponse;
import com.tigerbrokers.stock.openapi.client.struct.enums.Language;
import com.tigerbrokers.stock.openapi.client.struct.enums.MethodName;
import com.tigerbrokers.stock.openapi.client.struct.enums.SecType;

public class QuoteContractRequest
extends TigerCommonRequest
implements TigerRequest<QuoteContractResponse> {
    public QuoteContractRequest() {
        this.setApiVersion("2.0");
        this.setApiMethodName(MethodName.QUOTE_CONTRACT);
    }

    public static QuoteContractRequest newRequest(String symbol) {
        return QuoteContractRequest.newRequest(symbol, SecType.WAR);
    }

    public static QuoteContractRequest newRequest(String symbol, SecType secType) {
        return QuoteContractRequest.newRequest(symbol, secType, ClientConfig.DEFAULT_CONFIG.getDefaultLanguage());
    }

    public static QuoteContractRequest newRequest(String symbol, SecType secType, Language lang) {
        QuoteContractRequest request = new QuoteContractRequest();
        QuoteContractModel model = new QuoteContractModel(symbol, secType, lang);
        request.setApiModel(model);
        return request;
    }

    public static QuoteContractRequest newRequest(String symbol, SecType secType, String expiry) {
        QuoteContractRequest request = new QuoteContractRequest();
        QuoteContractModel model = new QuoteContractModel(symbol, secType, expiry);
        request.setApiModel(model);
        return request;
    }

    @Override
    public Class<QuoteContractResponse> getResponseClass() {
        return QuoteContractResponse.class;
    }
}

