/*
 * Decompiled with CFR 0.152.
 */
package com.tigerbrokers.stock.openapi.client.socket;

import com.tigerbrokers.stock.openapi.client.socket.ApiCallbackDecoder;
import com.tigerbrokers.stock.openapi.client.socket.WebSocketClient;
import com.tigerbrokers.stock.openapi.client.util.ApiLogger;
import com.tigerbrokers.stock.openapi.client.util.ProtoMessageUtil;
import com.tigerbrokers.stock.openapi.client.util.StompMessageUtil;
import io.netty.channel.ChannelHandlerContext;
import io.netty.channel.ChannelInboundHandlerAdapter;
import io.netty.handler.timeout.IdleState;
import io.netty.handler.timeout.IdleStateEvent;

public class IdleTriggerHandler
extends ChannelInboundHandlerAdapter {
    private ApiCallbackDecoder apiCallbackDecoder = null;

    public IdleTriggerHandler(ApiCallbackDecoder decoder) {
        this.apiCallbackDecoder = decoder;
    }

    public void userEventTriggered(ChannelHandlerContext ctx, Object evt) throws Exception {
        if (evt instanceof IdleStateEvent) {
            IdleState state = ((IdleStateEvent)evt).state();
            if (IdleState.WRITER_IDLE == state) {
                if (WebSocketClient.getInstance().isUseProtobuf()) {
                    ctx.channel().writeAndFlush((Object)ProtoMessageUtil.buildHeartBeatMessage());
                } else {
                    ctx.channel().writeAndFlush((Object)StompMessageUtil.buildCommonSendMessage("heart-beat"));
                }
            } else if (IdleState.READER_IDLE == state) {
                ApiLogger.warn("server time out:{}", ctx.channel().id().asShortText());
                if (this.apiCallbackDecoder != null) {
                    this.apiCallbackDecoder.serverHeartBeatTimeOut(ctx.channel().id().asShortText());
                }
            }
        } else {
            ctx.fireUserEventTriggered(evt);
        }
    }
}

