/*
 * Decompiled with CFR 0.152.
 */
package com.tigerbrokers.stock.openapi.client.socket;

import com.alibaba.fastjson.JSON;
import com.alibaba.fastjson.JSONObject;
import com.alibaba.fastjson.serializer.SerializerFeature;
import com.tigerbrokers.stock.openapi.client.socket.ApiCallbackDecoder;
import com.tigerbrokers.stock.openapi.client.socket.ApiComposeCallback;
import com.tigerbrokers.stock.openapi.client.socket.ApiComposeCallback4Stomp;
import com.tigerbrokers.stock.openapi.client.struct.SubscribedSymbol;
import com.tigerbrokers.stock.openapi.client.struct.enums.QuoteSubject;
import com.tigerbrokers.stock.openapi.client.util.ApiLogger;
import com.tigerbrokers.stock.openapi.client.util.StringUtils;
import com.tigerbrokers.stock.openapi.client.util.TradeTickUtil;
import io.netty.handler.codec.http.HttpConstants;
import io.netty.handler.codec.stomp.StompFrame;
import io.netty.handler.codec.stomp.StompHeaders;

public class ApiCallbackDecoder4Stomp
extends ApiCallbackDecoder {
    private ApiComposeCallback4Stomp callback;
    private StompFrame stompFrame;
    private int retType;
    private String id;

    public ApiCallbackDecoder4Stomp(ApiComposeCallback4Stomp callback) {
        super(callback);
        this.callback = callback;
    }

    public synchronized void handle(StompFrame stompFrame) {
        String content = stompFrame.content().toString(HttpConstants.DEFAULT_CHARSET);
        if (!StringUtils.isEmpty(content) && "heart-beat".equals(content)) {
            this.processHeartBeat(content);
            return;
        }
        this.init(stompFrame);
        switch (this.retType) {
            case 10: {
                this.processPosition();
                break;
            }
            case 11: {
                this.processAsset();
                break;
            }
            case 9: {
                this.processOrderStatus();
                break;
            }
            case 12: {
                this.processOrderTransaction();
                break;
            }
            case 110: {
                this.processSubscribeQuoteChange();
                break;
            }
            case 109: {
                this.processSubscribeQuoteChange();
                break;
            }
            case 111: {
                this.processGetSubscribedSymbols();
                break;
            }
            case 112: {
                this.processSubscribeEnd();
                break;
            }
            case 113: {
                this.processCancelSubscribeEnd();
                break;
            }
            case 200: {
                this.processErrorEnd();
                break;
            }
            default: {
                this.processDefault();
            }
        }
    }

    private void init(StompFrame stompFrame) {
        this.stompFrame = stompFrame;
        this.retType = stompFrame.headers().getInt((Object)"ret-type");
        this.id = stompFrame.headers().getAsString((CharSequence)"id");
    }

    @Override
    public ApiComposeCallback getCallback() {
        return this.callback;
    }

    private void processPosition() {
        String content = this.stompFrame.content().toString(HttpConstants.DEFAULT_CHARSET);
        this.callback.positionChange(JSON.parseObject((String)content));
    }

    private void processAsset() {
        String content = this.stompFrame.content().toString(HttpConstants.DEFAULT_CHARSET);
        this.callback.assetChange(JSONObject.parseObject((String)content));
    }

    private void processOrderStatus() {
        String content = this.stompFrame.content().toString(HttpConstants.DEFAULT_CHARSET);
        this.callback.orderStatusChange(JSONObject.parseObject((String)content));
    }

    private void processOrderTransaction() {
        String content = this.stompFrame.content().toString(HttpConstants.DEFAULT_CHARSET);
        this.callback.orderTransactionChange(JSONObject.parseObject((String)content));
    }

    private void processSubscribeQuoteChange() {
        String content = this.stompFrame.content().toString(HttpConstants.DEFAULT_CHARSET);
        if (content == null) {
            return;
        }
        JSONObject jsonObject = JSONObject.parseObject((String)content);
        if (jsonObject == null) {
            return;
        }
        String type = jsonObject.getString("type");
        if (type == null) {
            return;
        }
        QuoteSubject subject = QuoteSubject.valueOf(type);
        if (type == null) {
            return;
        }
        switch (subject) {
            case Quote: {
                this.callback.quoteChange(jsonObject);
                break;
            }
            case Option: {
                this.callback.optionChange(jsonObject);
                break;
            }
            case TradeTick: {
                this.callback.tradeTickChange(TradeTickUtil.decodeData(jsonObject));
                break;
            }
            case Future: {
                this.callback.futureChange(jsonObject);
                break;
            }
            case QuoteDepth: {
                this.callback.depthQuoteChange(jsonObject);
                break;
            }
            default: {
                this.callback.quoteChange(jsonObject);
            }
        }
    }

    private void processGetSubscribedSymbols() {
        String content = this.stompFrame.content().toString(HttpConstants.DEFAULT_CHARSET);
        this.callback.getSubscribedSymbolEnd((SubscribedSymbol)JSONObject.parseObject((String)content, SubscribedSymbol.class));
    }

    private void processSubscribeEnd() {
        String subject = this.stompFrame.headers().getAsString((CharSequence)StompHeaders.SUBSCRIPTION);
        String content = this.stompFrame.content().toString(HttpConstants.DEFAULT_CHARSET);
        this.callback.subscribeEnd(StringUtils.toInt(this.id, 0), subject, content);
    }

    private void processCancelSubscribeEnd() {
        String subject = this.stompFrame.headers().getAsString((CharSequence)StompHeaders.SUBSCRIPTION);
        String content = this.stompFrame.content().toString(HttpConstants.DEFAULT_CHARSET);
        this.callback.cancelSubscribeEnd(StringUtils.toInt(this.id, 0), subject, content);
    }

    private void processErrorEnd() {
        if (this.stompFrame != null && this.stompFrame.content() != null) {
            String content = this.stompFrame.content().toString(HttpConstants.DEFAULT_CHARSET);
            this.callback.error(content);
        } else if (this.stompFrame != null) {
            this.callback.error(JSONObject.toJSONString((Object)this.stompFrame, (SerializerFeature[])new SerializerFeature[]{SerializerFeature.WriteEnumUsingToString}));
        } else {
            this.callback.error("unknown error");
        }
    }

    private void processDefault() {
        ApiLogger.info("ret-type:{} cannot be processed.", this.retType);
    }

    @Override
    public void processHeartBeat(String content) {
        this.callback.hearBeat(content);
    }

    @Override
    public void serverHeartBeatTimeOut(String channelId) {
        this.callback.serverHeartBeatTimeOut(channelId);
    }
}

