/*
 * Decompiled with CFR 0.152.
 */
package com.tigerbrokers.stock.openapi.client.https.client;

import com.alibaba.fastjson.JSON;
import com.alibaba.fastjson.JSONObject;
import com.alibaba.fastjson.serializer.SerializerFeature;
import com.tigerbrokers.stock.openapi.client.TigerApiException;
import com.tigerbrokers.stock.openapi.client.config.ClientConfig;
import com.tigerbrokers.stock.openapi.client.https.client.TigerClient;
import com.tigerbrokers.stock.openapi.client.https.client.TokenManager;
import com.tigerbrokers.stock.openapi.client.https.domain.ApiModel;
import com.tigerbrokers.stock.openapi.client.https.domain.BatchApiModel;
import com.tigerbrokers.stock.openapi.client.https.request.TigerCommonRequest;
import com.tigerbrokers.stock.openapi.client.https.request.TigerHttpRequest;
import com.tigerbrokers.stock.openapi.client.https.request.TigerRequest;
import com.tigerbrokers.stock.openapi.client.https.request.user.UserLicenseRequest;
import com.tigerbrokers.stock.openapi.client.https.response.TigerHttpResponse;
import com.tigerbrokers.stock.openapi.client.https.response.TigerResponse;
import com.tigerbrokers.stock.openapi.client.https.response.user.UserLicenseResponse;
import com.tigerbrokers.stock.openapi.client.https.validator.ValidatorManager;
import com.tigerbrokers.stock.openapi.client.struct.enums.AccountType;
import com.tigerbrokers.stock.openapi.client.struct.enums.BizType;
import com.tigerbrokers.stock.openapi.client.struct.enums.Env;
import com.tigerbrokers.stock.openapi.client.struct.enums.License;
import com.tigerbrokers.stock.openapi.client.struct.enums.MethodName;
import com.tigerbrokers.stock.openapi.client.struct.enums.MethodType;
import com.tigerbrokers.stock.openapi.client.struct.enums.TigerApiCode;
import com.tigerbrokers.stock.openapi.client.util.AccountUtil;
import com.tigerbrokers.stock.openapi.client.util.ApiLogger;
import com.tigerbrokers.stock.openapi.client.util.ConfigFileUtil;
import com.tigerbrokers.stock.openapi.client.util.HttpUtils;
import com.tigerbrokers.stock.openapi.client.util.NetworkUtil;
import com.tigerbrokers.stock.openapi.client.util.ReflectionUtil;
import com.tigerbrokers.stock.openapi.client.util.SdkVersionUtils;
import com.tigerbrokers.stock.openapi.client.util.StringUtils;
import com.tigerbrokers.stock.openapi.client.util.TigerSignature;
import com.tigerbrokers.stock.openapi.client.util.builder.AccountParamBuilder;
import java.security.Security;
import java.util.HashMap;
import java.util.Map;
import java.util.concurrent.Executors;
import java.util.concurrent.ScheduledThreadPoolExecutor;
import java.util.concurrent.ThreadFactory;
import java.util.concurrent.TimeUnit;

public class TigerHttpClient
implements TigerClient {
    private String serverUrl;
    private String quoteServerUrl;
    private String paperServerUrl;
    private String tigerId;
    private String privateKey;
    private String tigerPublicKey;
    private String accessToken;
    private String tradeToken;
    private String accountType;
    private String deviceId;
    private int failRetryCounts = 2;
    private static final String ONLINE_PUBLIC_KEY = "MIGfMA0GCSqGSIb3DQEBAQUAA4GNADCBiQKBgQDNF3G8SoEcCZh2rshUbayDgLLrj6rKgzNMxDL2HSnKcB0+GPOsndqSv+a4IBu9+I3fyBp5hkyMMG2+AXugd9pMpy6VxJxlNjhX1MYbNTZJUT4nudki4uh+LMOkIBHOceGNXjgB+cXqmlUnjlqha/HgboeHSnSgpM3dKSJQlIOsDwIDAQAB";
    private static final String SANDBOX_PUBLIC_KEY = "MIGfMA0GCSqGSIb3DQEBAQUAA4GNADCBiQKBgQCbm21i11hgAENGd3/f280PSe4g9YGkS3TEXBYMidihTvHHf+tJ0PYD0o3PruI0hl3qhEjHTAxb75T5YD3SGK4IBhHn/Rk6mhqlGgI+bBrBVYaXixmHfRo75RpUUuWACyeqQkZckgR0McxuW9xRMIa2cXZOoL1E4SL4lXKGhKoWbwIDAQAB";
    private String signType = "RSA";
    private String charset = "UTF-8";
    private static final long REFRESH_URL_INTERVAL_SECONDS = 300L;
    private ScheduledThreadPoolExecutor domainExecutorService;

    private TigerHttpClient() {
    }

    public static TigerHttpClient getInstance() {
        return SingletonInner.singleton;
    }

    public TigerHttpClient clientConfig(ClientConfig clientConfig) {
        ConfigFileUtil.loadConfigFile(clientConfig);
        this.init(clientConfig.tigerId, clientConfig.privateKey);
        if (clientConfig.failRetryCounts <= 5) {
            this.failRetryCounts = Math.max(clientConfig.failRetryCounts, 0);
        }
        TokenManager.getInstance().init(clientConfig);
        this.initDomainRefreshTask();
        if (clientConfig.isAutoGrabPermission) {
            TigerHttpRequest request = new TigerHttpRequest(MethodName.GRAB_QUOTE_PERMISSION);
            request.setBizContent(AccountParamBuilder.instance().buildJsonWithoutDefaultAccount());
            TigerHttpResponse response = this.execute(request);
            ApiLogger.info("tigerId:{}, grab_quote_permission:{}, data:{}", this.tigerId, response.getMessage(), response.getData());
        }
        return this;
    }

    private void init(String tigerId, String privateKey) {
        if (tigerId == null) {
            throw new RuntimeException("tigerId is empty.");
        }
        if (privateKey == null) {
            throw new RuntimeException("privateKey is empty.");
        }
        this.tigerId = tigerId;
        this.privateKey = privateKey;
        this.tigerPublicKey = ClientConfig.DEFAULT_CONFIG.getEnv() == Env.PROD ? ONLINE_PUBLIC_KEY : SANDBOX_PUBLIC_KEY;
        this.deviceId = NetworkUtil.getDeviceId();
        this.initLicense();
        this.refreshUrl();
        if (this.serverUrl == null) {
            throw new RuntimeException("serverUrl is empty.");
        }
    }

    public TigerHttpClient accessToken(String accessToken) {
        this.accessToken = accessToken;
        return this;
    }

    private void initLicense() {
        if (null == ClientConfig.DEFAULT_CONFIG.license) {
            try {
                Map<BizType, String> urlMap = NetworkUtil.getHttpServerAddress(null, this.serverUrl);
                this.serverUrl = StringUtils.defaultIfEmpty(urlMap.get((Object)BizType.COMMON), this.serverUrl);
                UserLicenseRequest request = UserLicenseRequest.newRequest();
                UserLicenseResponse response = this.execute(request);
                if (response.isSuccess() && response.getLicenseItem() != null) {
                    ApiLogger.debug("license:{}", JSON.toJSONString((Object)response.getLicenseItem(), (SerializerFeature[])new SerializerFeature[]{SerializerFeature.WriteEnumUsingToString}));
                    ClientConfig.DEFAULT_CONFIG.license = License.valueOf(response.getLicenseItem().getLicense());
                }
            }
            catch (Exception e) {
                ApiLogger.debug("get license fail. tigerId:{}", this.tigerId);
            }
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    private void initDomainRefreshTask() {
        TigerHttpClient tigerHttpClient = SingletonInner.singleton;
        synchronized (tigerHttpClient) {
            if (this.domainExecutorService == null || this.domainExecutorService.isTerminated()) {
                this.domainExecutorService = new ScheduledThreadPoolExecutor(1, new ThreadFactory(){

                    @Override
                    public Thread newThread(Runnable r) {
                        Thread t = Executors.defaultThreadFactory().newThread(r);
                        t.setDaemon(true);
                        return t;
                    }
                });
                this.domainExecutorService.scheduleWithFixedDelay(new Runnable(){

                    @Override
                    public void run() {
                        TigerHttpClient.this.refreshUrl();
                    }
                }, 300L, 300L, TimeUnit.SECONDS);
            }
        }
    }

    private void refreshUrl() {
        try {
            Map<BizType, String> urlMap = NetworkUtil.getHttpServerAddress(ClientConfig.DEFAULT_CONFIG.license, this.serverUrl);
            String newServerUrl = urlMap.get((Object)BizType.TRADE);
            if (newServerUrl == null) {
                newServerUrl = urlMap.get((Object)BizType.COMMON);
            }
            String newQuoteServerUrl = urlMap.get((Object)BizType.QUOTE) == null ? newServerUrl : urlMap.get((Object)BizType.QUOTE);
            String newPaperServerUrl = urlMap.get((Object)BizType.PAPER) == null ? newServerUrl : urlMap.get((Object)BizType.PAPER);
            this.serverUrl = StringUtils.defaultIfEmpty(newServerUrl, this.serverUrl);
            this.quoteServerUrl = StringUtils.defaultIfEmpty(newQuoteServerUrl, this.quoteServerUrl);
            this.paperServerUrl = StringUtils.defaultIfEmpty(newPaperServerUrl, this.paperServerUrl);
        }
        catch (Throwable t) {
            ApiLogger.error("refresh serverUrl error", t);
        }
    }

    public String getAccessToken() {
        return this.accessToken;
    }

    public void setAccessToken(String accessToken) {
        this.accessToken = accessToken;
    }

    public void setTradeToken(String tradeToken) {
        this.tradeToken = tradeToken;
    }

    public String getTradeToken() {
        return this.tradeToken;
    }

    public void setAccountType(AccountType accountType) {
        if (accountType != null) {
            this.accountType = accountType.name();
        }
    }

    public String getAccountType() {
        return this.accountType;
    }

    @Override
    public <T extends TigerResponse> T execute(TigerRequest<T> request) {
        String param = null;
        String data = null;
        try {
            this.validate(request);
            param = JSONObject.toJSONString(this.buildParams(request), (SerializerFeature[])new SerializerFeature[]{SerializerFeature.WriteEnumUsingToString});
            ApiLogger.debug("request param:{}", param);
            data = HttpUtils.post(this.getServerUrl(request), param, MethodName.PLACE_ORDER == request.getApiMethodName() ? 0 : this.failRetryCounts);
            ApiLogger.debug("response result:{}", data);
            if (StringUtils.isEmpty(data)) {
                throw new TigerApiException(TigerApiCode.EMPTY_DATA_ERROR);
            }
            TigerResponse response = (TigerResponse)JSON.parseObject((String)data, request.getResponseClass());
            if (StringUtils.isEmpty(this.tigerPublicKey) || response.getSign() == null) {
                return (T)response;
            }
            boolean signSuccess = TigerSignature.rsaCheckContent(request.getTimestamp(), response.getSign(), this.tigerPublicKey, this.charset);
            if (!signSuccess) {
                throw new TigerApiException(TigerApiCode.SIGN_CHECK_FAILED);
            }
            return (T)response;
        }
        catch (RuntimeException e) {
            ApiLogger.error("request fail. tigerId:{}, method:{}, param:{}, response:{}", new Object[]{this.tigerId, request == null ? null : request.getApiMethodName(), param, data, e});
            return this.errorResponse(this.tigerId, request, e);
        }
        catch (TigerApiException e) {
            ApiLogger.error("request fail. tigerId:{}, method:{}, param:{}, response:{}", new Object[]{this.tigerId, request == null ? null : request.getApiMethodName(), param, data, e});
            return this.errorResponse(this.tigerId, request, e);
        }
        catch (Exception e) {
            ApiLogger.error("request fail. tigerId:{}, method:{}, param:{}, response:{}", new Object[]{this.tigerId, request == null ? null : request.getApiMethodName(), param, data, e});
            return this.errorResponse(this.tigerId, request, e);
        }
    }

    private <T extends TigerResponse> T errorResponse(String tigerId, TigerRequest<T> request, TigerApiException e) {
        try {
            TigerResponse response = (TigerResponse)request.getResponseClass().newInstance();
            response.setCode(e.getErrCode());
            response.setMessage(e.getErrMsg());
            return (T)response;
        }
        catch (Exception e1) {
            ApiLogger.error(tigerId, new Object[]{request.getApiMethodName(), request.getApiVersion(), e1});
            return null;
        }
    }

    private <T extends TigerResponse> T errorResponse(String tigerId, TigerRequest<T> request, Exception e) {
        try {
            TigerResponse response = (TigerResponse)request.getResponseClass().newInstance();
            response.setCode(TigerApiCode.CLIENT_API_ERROR.getCode());
            response.setMessage(TigerApiCode.CLIENT_API_ERROR.getMessage() + "(" + e.getMessage() + ")");
            return (T)response;
        }
        catch (Exception e1) {
            ApiLogger.error(tigerId, new Object[]{request.getApiMethodName(), request.getApiVersion(), e1});
            return null;
        }
    }

    private Map<String, Object> buildParams(TigerRequest request) {
        HashMap<String, Object> params = new HashMap<String, Object>();
        params.put("method", request.getApiMethodName().getValue());
        params.put("version", request.getApiVersion());
        params.put("sdk-version", SdkVersionUtils.getSdkVersion());
        if (request instanceof TigerHttpRequest) {
            params.put("biz_content", ((TigerHttpRequest)request).getBizContent());
        } else if (request.getApiModel() == null && request instanceof TigerCommonRequest) {
            params.put("biz_content", ((TigerCommonRequest)((Object)request)).getBizContent());
        } else {
            ApiModel apiModel = request.getApiModel();
            if (apiModel instanceof BatchApiModel) {
                params.put("biz_content", JSONObject.toJSONString(((BatchApiModel)apiModel).getItems(), (SerializerFeature[])new SerializerFeature[]{SerializerFeature.WriteEnumUsingToString}));
            } else {
                this.setDefaultSecretKey(apiModel, request.getApiMethodName());
                params.put("biz_content", JSONObject.toJSONString((Object)apiModel, (SerializerFeature[])new SerializerFeature[]{SerializerFeature.WriteEnumUsingToString}));
            }
        }
        params.put("timestamp", request.getTimestamp());
        params.put("charset", this.charset);
        params.put("tiger_id", this.tigerId);
        params.put("sign_type", this.signType);
        if (this.accessToken != null) {
            params.put("access_token", this.accessToken);
        }
        if (this.tradeToken != null) {
            params.put("trade_token", this.tradeToken);
        }
        if (this.accountType != null) {
            params.put("account_type", this.accountType);
        }
        if (this.deviceId != null) {
            params.put("device_id", this.deviceId);
        }
        if (this.tigerId != null) {
            String content = TigerSignature.getSignContent(params);
            params.put("sign", TigerSignature.rsaSign(content, this.privateKey, this.charset));
        }
        return params;
    }

    private void setDefaultSecretKey(ApiModel apiModel, MethodName methodName) {
        if (methodName != null && methodName.getType() == MethodType.TRADE && !StringUtils.isEmpty(apiModel.getAccount()) && !StringUtils.isEmpty(ClientConfig.DEFAULT_CONFIG.secretKey)) {
            ReflectionUtil.checkAndSetDefaultValue(apiModel, "secretKey", "setSecretKey", ClientConfig.DEFAULT_CONFIG.secretKey);
        }
    }

    private void validate(TigerRequest request) throws TigerApiException {
        if (request instanceof TigerHttpRequest) {
            return;
        }
        ValidatorManager.getInstance().validate(request.getApiModel());
    }

    private String getServerUrl(TigerRequest request) {
        String account;
        String url = null;
        MethodType methodType = request.getApiMethodName().getType();
        if (MethodType.QUOTE == methodType) {
            url = this.quoteServerUrl;
        } else if (MethodType.TRADE == methodType && this.paperServerUrl != null && AccountUtil.isVirtualAccount(account = AccountUtil.parseAccount(request))) {
            url = this.paperServerUrl;
        }
        return url == null ? this.serverUrl : url;
    }

    static {
        Security.setProperty("jdk.certpath.disabledAlgorithms", "");
    }

    private static class SingletonInner {
        private static TigerHttpClient singleton = new TigerHttpClient();

        private SingletonInner() {
        }
    }
}

