/*
 * Decompiled with CFR 0.152.
 */
package com.tigerbrokers.stock.openapi.client.util.builder;

import com.tigerbrokers.stock.openapi.client.struct.enums.Subject;
import com.tigerbrokers.stock.openapi.client.util.SdkVersionUtils;
import io.netty.handler.codec.stomp.DefaultStompHeaders;
import io.netty.handler.codec.stomp.StompHeaders;
import io.netty.util.AsciiString;
import java.util.Collection;
import java.util.Set;

public class HeaderBuilder {
    public static final String REQ_TYPE = "req-type";
    public static final String FOCUS_KEYS = "keys";
    public static final String STOMP_VERSION_10 = "1.0";
    public static final String STOMP_VERSION_11 = "1.1";
    public static final String STOMP_VERSION_12 = "1.2";
    public static final String PROTOBUF_VERSION_3 = "3";
    public static final String DEFAULT_VERSION = "3";
    public static final String HOST = "localhost";
    public static final String ACCOUNT = "account";
    public static final String SYMBOLS = "symbols";
    private static AsciiString SDK_VERSION_HEADER = AsciiString.cached((String)"sdk-version");
    private static String USE_VERSION = "3";
    private StompHeaders stompHeaders = new DefaultStompHeaders();

    private HeaderBuilder() {
    }

    public static HeaderBuilder instance() {
        return new HeaderBuilder();
    }

    public static String getUseVersion() {
        return USE_VERSION;
    }

    public static void setUseVersion(String version) {
        if ("3".equals(version) || STOMP_VERSION_12.equals(version) || STOMP_VERSION_11.equals(version) || STOMP_VERSION_10.equals(version)) {
            USE_VERSION = version;
        }
    }

    public HeaderBuilder version(String version) {
        this.stompHeaders.set((Object)StompHeaders.ACCEPT_VERSION, (Object)version);
        return this;
    }

    public HeaderBuilder sdkVersion() {
        this.stompHeaders.set((Object)SDK_VERSION_HEADER, (Object)SdkVersionUtils.getSdkVersion());
        return this;
    }

    public HeaderBuilder host() {
        this.stompHeaders.set((Object)StompHeaders.HOST, (Object)HOST);
        return this;
    }

    public HeaderBuilder login(String login) {
        this.stompHeaders.set((Object)StompHeaders.LOGIN, (Object)login);
        return this;
    }

    public HeaderBuilder passcode(String passcode) {
        this.stompHeaders.set((Object)StompHeaders.PASSCODE, (Object)passcode);
        return this;
    }

    public HeaderBuilder id(int id) {
        this.stompHeaders.set((Object)StompHeaders.ID, (Object)String.valueOf(id));
        return this;
    }

    public HeaderBuilder reqType(int reqType) {
        this.stompHeaders.set((Object)REQ_TYPE, (Object)String.valueOf(reqType));
        return this;
    }

    public HeaderBuilder subject(Subject subject) {
        this.stompHeaders.set((Object)StompHeaders.SUBSCRIPTION, (Object)subject.name());
        return this;
    }

    public HeaderBuilder subject(String subject) {
        this.stompHeaders.set((Object)StompHeaders.SUBSCRIPTION, (Object)subject);
        return this;
    }

    public HeaderBuilder focusKeys(Set<String> focusKeys) {
        if (focusKeys != null && !focusKeys.isEmpty()) {
            this.stompHeaders.set((Object)FOCUS_KEYS, (Object)HeaderBuilder.join(focusKeys));
        }
        return this;
    }

    public HeaderBuilder account(String account) {
        if (null != account) {
            this.stompHeaders.set((Object)ACCOUNT, (Object)account);
        }
        return this;
    }

    public HeaderBuilder heartBeat(int cx, int cy) {
        String value = String.format("%d,%d", cx, cy);
        this.stompHeaders.set((Object)StompHeaders.HEART_BEAT, (Object)value);
        return this;
    }

    public static String join(Collection<String> collection) {
        StringBuilder builder = new StringBuilder();
        boolean isFirst = true;
        for (String symbol : collection) {
            if (!isFirst) {
                builder.append(",").append(symbol);
                continue;
            }
            builder.append(symbol);
            isFirst = false;
        }
        return builder.toString();
    }

    public HeaderBuilder symbols(Set<String> symbols) {
        if (symbols != null && !symbols.isEmpty()) {
            this.stompHeaders.set((Object)SYMBOLS, (Object)HeaderBuilder.join(symbols));
        }
        return this;
    }

    public StompHeaders build() {
        return this.stompHeaders;
    }
}

