/*
 * Decompiled with CFR 0.152.
 */
package com.tigerbrokers.stock.openapi.client.util;

import com.alibaba.fastjson.JSONObject;
import com.tigerbrokers.stock.openapi.client.https.domain.ApiModel;
import com.tigerbrokers.stock.openapi.client.https.domain.BatchApiModel;
import com.tigerbrokers.stock.openapi.client.https.request.TigerCommonRequest;
import com.tigerbrokers.stock.openapi.client.https.request.TigerHttpRequest;
import com.tigerbrokers.stock.openapi.client.https.request.TigerRequest;
import com.tigerbrokers.stock.openapi.client.struct.enums.AccountType;
import com.tigerbrokers.stock.openapi.client.util.ApiLogger;
import com.tigerbrokers.stock.openapi.client.util.StringUtils;

public class AccountUtil {
    private static final int PAPER_ACCOUNT_LEN = 17;

    public static boolean isOmnibusAccount(String account) {
        if (StringUtils.isEmpty(account)) {
            return false;
        }
        try {
            return StringUtils.isNumeric(account) && account.length() < 17;
        }
        catch (Exception e) {
            ApiLogger.error("isOmnibusAccount {}", (Object)e.getMessage(), (Object)e);
            return false;
        }
    }

    public static boolean isVirtualAccount(String account) {
        if (StringUtils.isEmpty(account)) {
            return false;
        }
        try {
            return StringUtils.isNumeric(account) && account.length() == 17;
        }
        catch (Exception e) {
            ApiLogger.error("isVirtualAccount {}", (Object)e.getMessage(), (Object)e);
            return false;
        }
    }

    public static boolean isGlobalAccount(String account) {
        if (StringUtils.isEmpty(account)) {
            return false;
        }
        return account.startsWith("U") || account.startsWith("DU") || account.startsWith("F") || account.startsWith("DF");
    }

    public static AccountType getAccountType(String account) {
        if (AccountUtil.isGlobalAccount(account)) {
            return AccountType.GLOBAL;
        }
        if (AccountUtil.isOmnibusAccount(account)) {
            return AccountType.STANDARD;
        }
        return AccountType.PAPER;
    }

    public static String parseAccount(TigerRequest request) {
        if (null == request) {
            return null;
        }
        String account = null;
        if (request instanceof TigerHttpRequest) {
            String bizContent = ((TigerHttpRequest)request).getBizContent();
            account = (String)JSONObject.parseObject((String)bizContent).get((Object)"account");
        } else if (request.getApiModel() == null && request instanceof TigerCommonRequest) {
            String bizContent = ((TigerCommonRequest)((Object)request)).getBizContent();
            account = (String)JSONObject.parseObject((String)bizContent).get((Object)"account");
        } else if (request.getApiModel() != null) {
            ApiModel apiModel = request.getApiModel();
            if (apiModel instanceof BatchApiModel) {
                apiModel = ((BatchApiModel)apiModel).getItems().get(0);
            }
            account = apiModel.getAccount();
        }
        return account;
    }
}

