/*
 * Decompiled with CFR 0.152.
 */
package com.tigerbrokers.stock.openapi.client.websocket;

import io.netty.buffer.ByteBuf;
import io.netty.buffer.ByteBufAllocator;
import io.netty.buffer.ByteBufUtil;
import io.netty.buffer.Unpooled;
import io.netty.channel.ChannelHandlerContext;
import io.netty.handler.codec.DecoderException;
import io.netty.handler.codec.DecoderResult;
import io.netty.handler.codec.MessageToMessageDecoder;
import io.netty.handler.codec.TooLongFrameException;
import io.netty.handler.codec.http.websocketx.WebSocketFrame;
import io.netty.handler.codec.stomp.DefaultLastStompContentSubframe;
import io.netty.handler.codec.stomp.DefaultStompContentSubframe;
import io.netty.handler.codec.stomp.DefaultStompHeadersSubframe;
import io.netty.handler.codec.stomp.LastStompContentSubframe;
import io.netty.handler.codec.stomp.StompCommand;
import io.netty.handler.codec.stomp.StompHeaders;
import io.netty.util.internal.AppendableCharSequence;
import java.util.List;
import java.util.Locale;

public class WebSocketStompFrameDecoder
extends MessageToMessageDecoder<WebSocketFrame> {
    private static final int DEFAULT_CHUNK_SIZE = 8132;
    private static final int DEFAULT_MAX_LINE_LENGTH = 1024;
    private final int maxLineLength;
    private final int maxChunkSize;
    private final boolean validateHeaders;
    private int alreadyReadChunkSize;
    private LastStompContentSubframe lastContent;
    private long contentLength = -1L;
    private int checkpoint = -1;
    private State state = State.SKIP_CONTROL_CHARACTERS;

    public WebSocketStompFrameDecoder() {
        this(1024, 8132);
    }

    public WebSocketStompFrameDecoder(boolean validateHeaders) {
        this(1024, 8132, validateHeaders);
    }

    public WebSocketStompFrameDecoder(int maxLineLength, int maxChunkSize) {
        this(maxLineLength, maxChunkSize, false);
    }

    public WebSocketStompFrameDecoder(int maxLineLength, int maxChunkSize, boolean validateHeaders) {
        if (maxLineLength <= 0) {
            throw new IllegalArgumentException("maxLineLength must be a positive integer: " + maxLineLength);
        }
        if (maxChunkSize <= 0) {
            throw new IllegalArgumentException("maxChunkSize must be a positive integer: " + maxChunkSize);
        }
        this.maxChunkSize = maxChunkSize;
        this.maxLineLength = maxLineLength;
        this.validateHeaders = validateHeaders;
    }

    protected void decode(ChannelHandlerContext channelHandlerContext, WebSocketFrame msg, List out) throws Exception {
        ByteBuf buffer = msg.content();
        this.doDecode(channelHandlerContext, buffer, out);
    }

    /*
     * Unable to fully structure code
     */
    private void doDecode(ChannelHandlerContext ctx, ByteBuf in, List<Object> out) throws Exception {
        switch (1.$SwitchMap$com$tigerbrokers$stock$openapi$client$websocket$WebSocketStompFrameDecoder$State[this.state.ordinal()]) {
            case 1: {
                WebSocketStompFrameDecoder.skipControlCharacters(in);
                this.checkpoint(State.READ_HEADERS, in);
            }
            case 2: {
                command = StompCommand.UNKNOWN;
                frame = null;
                try {
                    command = this.readCommand(in);
                    frame = new DefaultStompHeadersSubframe(command);
                    this.checkpoint(this.readHeaders(in, frame.headers()), in);
                    out.add(frame);
                    break;
                }
                catch (Exception e) {
                    if (frame == null) {
                        frame = new DefaultStompHeadersSubframe(command);
                    }
                    frame.setDecoderResult(DecoderResult.failure((Throwable)e));
                    out.add(frame);
                    this.checkpoint(State.BAD_FRAME, in);
                    return;
                }
            }
            case 3: {
                in.readableBytes();
                return;
            }
        }
        try {
            switch (1.$SwitchMap$com$tigerbrokers$stock$openapi$client$websocket$WebSocketStompFrameDecoder$State[this.state.ordinal()]) {
                case 4: {
                    toRead = in.readableBytes();
                    if (toRead == 0) {
                        return;
                    }
                    if (toRead > this.maxChunkSize) {
                        toRead = this.maxChunkSize;
                    }
                    if (this.contentLength < 0L) ** GOTO lbl47
                    remainingLength = (int)(this.contentLength - (long)this.alreadyReadChunkSize);
                    if (toRead > remainingLength) {
                        toRead = remainingLength;
                    }
                    chunkBuffer = ByteBufUtil.readBytes((ByteBufAllocator)ctx.alloc(), (ByteBuf)in, (int)toRead);
                    if ((long)(this.alreadyReadChunkSize += toRead) < this.contentLength) ** GOTO lbl44
                    this.lastContent = new DefaultLastStompContentSubframe(chunkBuffer);
                    this.checkpoint(State.FINALIZE_FRAME_READ, in);
                    ** GOTO lbl61
lbl44:
                    // 1 sources

                    out.add(new DefaultStompContentSubframe(chunkBuffer));
                    return;
lbl47:
                    // 1 sources

                    nulIndex = ByteBufUtil.indexOf((ByteBuf)in, (int)in.readerIndex(), (int)in.writerIndex(), (byte)0);
                    if (nulIndex != in.readerIndex()) ** GOTO lbl51
                    this.checkpoint(State.FINALIZE_FRAME_READ, in);
                    ** GOTO lbl61
lbl51:
                    // 1 sources

                    toRead = nulIndex > 0 ? nulIndex - in.readerIndex() : in.writerIndex() - in.readerIndex();
                    chunkBuffer = ByteBufUtil.readBytes((ByteBufAllocator)ctx.alloc(), (ByteBuf)in, (int)toRead);
                    this.alreadyReadChunkSize += toRead;
                    if (nulIndex > 0) {
                        this.lastContent = new DefaultLastStompContentSubframe(chunkBuffer);
                        this.checkpoint(State.FINALIZE_FRAME_READ, in);
                    } else {
                        out.add(new DefaultStompContentSubframe(chunkBuffer));
                        return;
                    }
                }
lbl61:
                // 4 sources

                case 5: {
                    WebSocketStompFrameDecoder.skipNullCharacter(in);
                    if (this.lastContent == null) {
                        this.lastContent = LastStompContentSubframe.EMPTY_LAST_CONTENT;
                    }
                    out.add(this.lastContent);
                    this.resetDecoder(in);
                }
            }
        }
        catch (Exception e) {
            errorContent = new DefaultLastStompContentSubframe(Unpooled.EMPTY_BUFFER);
            errorContent.setDecoderResult(DecoderResult.failure((Throwable)e));
            out.add(errorContent);
            this.checkpoint(State.BAD_FRAME, in);
        }
    }

    private StompCommand readCommand(ByteBuf in) {
        String commandStr = this.readLine(in, 16);
        StompCommand command = null;
        try {
            command = StompCommand.valueOf((String)commandStr);
        }
        catch (IllegalArgumentException illegalArgumentException) {
            // empty catch block
        }
        if (command == null) {
            commandStr = commandStr.toUpperCase(Locale.US);
            try {
                command = StompCommand.valueOf((String)commandStr);
            }
            catch (IllegalArgumentException illegalArgumentException) {
                // empty catch block
            }
        }
        if (command == null) {
            throw new DecoderException("failed to read command from channel");
        }
        return command;
    }

    private State readHeaders(ByteBuf buffer, StompHeaders headers) {
        boolean headerRead;
        AppendableCharSequence buf = new AppendableCharSequence(128);
        while (headerRead = this.readHeader(headers, buf, buffer)) {
        }
        if (headers.contains((Object)StompHeaders.CONTENT_LENGTH)) {
            this.contentLength = WebSocketStompFrameDecoder.getContentLength(headers, 0L);
            if (this.contentLength == 0L) {
                return State.FINALIZE_FRAME_READ;
            }
        }
        return State.READ_CONTENT;
    }

    private static long getContentLength(StompHeaders headers, long defaultValue) {
        long contentLength = headers.getLong((Object)StompHeaders.CONTENT_LENGTH, defaultValue);
        if (contentLength < 0L) {
            throw new DecoderException(StompHeaders.CONTENT_LENGTH + " must be non-negative");
        }
        return contentLength;
    }

    private static void skipNullCharacter(ByteBuf buffer) {
        byte b = buffer.readByte();
        if (b != 0) {
            throw new IllegalStateException("unexpected byte in buffer " + b + " while expecting NULL byte");
        }
    }

    private static void skipControlCharacters(ByteBuf buffer) {
        byte b;
        while ((b = buffer.readByte()) == 13 || b == 10) {
        }
        buffer.readerIndex(buffer.readerIndex() - 1);
    }

    private String readLine(ByteBuf buffer, int initialBufferSize) {
        AppendableCharSequence buf = new AppendableCharSequence(initialBufferSize);
        int lineLength = 0;
        while (true) {
            byte nextByte;
            if ((nextByte = buffer.readByte()) == 13) {
                continue;
            }
            if (nextByte == 10) {
                return buf.toString();
            }
            if (lineLength >= this.maxLineLength) {
                this.invalidLineLength();
            }
            ++lineLength;
            buf.append((char)nextByte);
        }
    }

    private boolean readHeader(StompHeaders headers, AppendableCharSequence buf, ByteBuf buffer) {
        buf.reset();
        int lineLength = 0;
        String key = null;
        boolean valid = false;
        while (true) {
            byte nextByte;
            if ((nextByte = buffer.readByte()) == 58 && key == null) {
                key = buf.toString();
                valid = true;
                buf.reset();
                continue;
            }
            if (nextByte == 13) continue;
            if (nextByte == 10) {
                if (key == null && lineLength == 0) {
                    return false;
                }
                if (valid) {
                    headers.add((Object)key, (Object)buf.toString());
                } else if (this.validateHeaders) {
                    this.invalidHeader(key, buf.toString());
                }
                return true;
            }
            if (lineLength >= this.maxLineLength) {
                this.invalidLineLength();
            }
            if (nextByte == 58 && key != null) {
                valid = false;
            }
            ++lineLength;
            buf.append((char)nextByte);
        }
    }

    private void invalidHeader(String key, String value) {
        String line = key != null ? key + ":" + value : value;
        throw new IllegalArgumentException("a header value or name contains a prohibited character ':', " + line);
    }

    private void invalidLineLength() {
        throw new TooLongFrameException("An STOMP line is larger than " + this.maxLineLength + " bytes.");
    }

    private void resetDecoder(ByteBuf in) {
        this.checkpoint(State.SKIP_CONTROL_CHARACTERS, in);
        this.contentLength = -1L;
        this.alreadyReadChunkSize = 0;
        this.lastContent = null;
    }

    protected void checkpoint(State state, ByteBuf buf) {
        this.checkpoint = buf.readerIndex();
        this.state = state;
    }

    static enum State {
        SKIP_CONTROL_CHARACTERS,
        READ_HEADERS,
        READ_CONTENT,
        FINALIZE_FRAME_READ,
        BAD_FRAME,
        INVALID_CHUNK;

    }
}

