/*
 * Decompiled with CFR 0.152.
 */
package com.tigerbrokers.stock.openapi.client.util;

import com.alibaba.fastjson.JSONObject;
import com.alibaba.fastjson.serializer.SerializerFeature;
import com.google.protobuf.Message;
import com.tigerbrokers.stock.openapi.client.socket.ApiCallbackDecoder;
import com.tigerbrokers.stock.openapi.client.socket.ApiCallbackDecoder4Stomp;
import com.tigerbrokers.stock.openapi.client.socket.IdleTriggerHandler;
import com.tigerbrokers.stock.openapi.client.socket.WebSocketClient;
import com.tigerbrokers.stock.openapi.client.socket.data.pb.Response;
import com.tigerbrokers.stock.openapi.client.struct.enums.TigerApiCode;
import com.tigerbrokers.stock.openapi.client.util.ApiLogger;
import com.tigerbrokers.stock.openapi.client.util.ProtoMessageUtil;
import com.tigerbrokers.stock.openapi.client.util.StringUtils;
import com.tigerbrokers.stock.openapi.client.util.builder.HeaderBuilder;
import io.netty.channel.ChannelHandler;
import io.netty.channel.ChannelHandlerContext;
import io.netty.handler.codec.stomp.StompFrame;
import io.netty.handler.codec.stomp.StompHeaders;
import io.netty.handler.timeout.IdleStateHandler;
import java.nio.charset.Charset;
import java.util.concurrent.TimeUnit;

public class ApiCallbackDecoderUtils {
    public static final String IDLE_STATE_HANDLER = "idleStateHandler";
    public static final String IDLE_TRIGGER_HANDLER = "idleTriggerHandler";

    public static void executor(ChannelHandlerContext ctx, StompFrame frame, ApiCallbackDecoder4Stomp decoder) throws Exception {
        if (null == decoder || null == ctx) {
            return;
        }
        switch (frame.command()) {
            case CONNECTED: {
                WebSocketClient wcClient = WebSocketClient.getWcClientByChannel(ctx.channel());
                ApiLogger.info("connect token validation success:{}, {}", frame, ApiCallbackDecoderUtils.buildMsgSuffix(ctx, wcClient));
                if (null != wcClient) {
                    wcClient.connectCountDown();
                }
                if (decoder.getCallback() == null) break;
                HeaderBuilder.setUseVersion(frame.headers().getAsString((CharSequence)"version"));
                String value = frame.headers().getAsString((CharSequence)StompHeaders.HEART_BEAT);
                if (!StringUtils.isEmpty(value)) {
                    String[] arrayValue = value.split(",");
                    if (null != arrayValue && arrayValue.length >= 2) {
                        int serverReceiveInterval;
                        int serverSendInterval = StringUtils.isEmpty(arrayValue[0]) ? 0 : Integer.valueOf(arrayValue[0]);
                        int n = serverReceiveInterval = StringUtils.isEmpty(arrayValue[1]) ? 0 : Integer.valueOf(arrayValue[1]);
                        if ((serverSendInterval > 0 || serverReceiveInterval > 0) && null == ctx.channel().pipeline().get(IDLE_STATE_HANDLER)) {
                            serverSendInterval = serverSendInterval == 0 ? 0 : serverSendInterval + 1000;
                            serverReceiveInterval = serverReceiveInterval == 0 ? 0 : serverReceiveInterval - 1000;
                            ctx.channel().pipeline().addBefore("socketEncoder", IDLE_STATE_HANDLER, (ChannelHandler)new IdleStateHandler((long)serverSendInterval, (long)serverReceiveInterval, 0L, TimeUnit.MILLISECONDS));
                            ctx.channel().pipeline().addAfter(IDLE_STATE_HANDLER, IDLE_TRIGGER_HANDLER, (ChannelHandler)new IdleTriggerHandler(wcClient, decoder));
                        }
                        decoder.getCallback().connectionAck(serverSendInterval, serverReceiveInterval);
                        break;
                    }
                    decoder.getCallback().connectionAck();
                    break;
                }
                decoder.getCallback().connectionAck();
                break;
            }
            case MESSAGE: {
                decoder.handle(frame);
                break;
            }
            case RECEIPT: {
                break;
            }
            case ERROR: {
                WebSocketClient client = WebSocketClient.getWcClientByChannel(ctx.channel());
                String userInfo = ApiCallbackDecoderUtils.buildMsgSuffix(ctx, client);
                if (decoder.getCallback() == null) break;
                if (frame != null && frame.content() != null) {
                    String content = frame.content().toString(Charset.defaultCharset());
                    try {
                        JSONObject jsonObject = JSONObject.parseObject((String)content);
                        if (jsonObject.getIntValue("code") == TigerApiCode.CONNECTION_KICK_OUT_ERROR.getCode()) {
                            String errMessage = jsonObject.getString("message");
                            StringBuilder msgBuilder = new StringBuilder(StringUtils.isEmpty(errMessage) ? TigerApiCode.CONNECTION_KICK_OUT_ERROR.getMessage() : errMessage);
                            msgBuilder.append(userInfo);
                            ApiLogger.info(msgBuilder.toString());
                            if (null != client) {
                                client.closeConnect();
                            }
                            decoder.getCallback().connectionKickout(TigerApiCode.CONNECTION_KICK_OUT_ERROR.getCode(), msgBuilder.toString());
                            return;
                        }
                    }
                    catch (Throwable throwable) {
                        // empty catch block
                    }
                    decoder.getCallback().error(content + userInfo);
                    break;
                }
                if (frame != null) {
                    decoder.getCallback().error(JSONObject.toJSONString((Object)frame, (SerializerFeature[])new SerializerFeature[]{SerializerFeature.WriteEnumUsingToString}) + userInfo);
                    break;
                }
                decoder.getCallback().error("unknown error" + userInfo);
                break;
            }
            case DISCONNECT: {
                if (decoder.getCallback() != null) {
                    decoder.getCallback().connectionClosed();
                }
                ctx.close();
                break;
            }
            case UNKNOWN: {
                ctx.close();
                break;
            }
        }
    }

    public static void executor(ChannelHandlerContext ctx, Response response, ApiCallbackDecoder decoder) {
        if (null == decoder || null == ctx || null == response || null == response.getCommand()) {
            return;
        }
        switch (response.getCommand()) {
            case CONNECTED: {
                WebSocketClient wcClient = WebSocketClient.getWcClientByChannel(ctx.channel());
                ApiLogger.info("connect token validation success:{}, {}", ProtoMessageUtil.toJson((Message)response), ApiCallbackDecoderUtils.buildMsgSuffix(ctx, wcClient));
                if (null != wcClient) {
                    wcClient.connectCountDown();
                }
                ApiCallbackDecoderUtils.receiveConnected(ctx, decoder, response.getMsg());
                break;
            }
            case HEARTBEAT: {
                decoder.processHeartBeat("heart-beat");
                break;
            }
            case MESSAGE: {
                decoder.handle(response);
                break;
            }
            case ERROR: {
                ApiCallbackDecoderUtils.processError(ctx, decoder, response);
                break;
            }
            case DISCONNECT: {
                if (decoder.getCallback() != null) {
                    decoder.getCallback().connectionClosed();
                }
                ctx.close();
                break;
            }
            case UNKNOWN: {
                ctx.close();
                break;
            }
        }
    }

    public static void receiveConnected(ChannelHandlerContext ctx, ApiCallbackDecoder decoder, String msg) {
        if (decoder.getCallback() != null && !StringUtils.isEmpty(msg)) {
            JSONObject jsonObject = JSONObject.parseObject((String)msg);
            HeaderBuilder.setUseVersion(jsonObject.getString("version"));
            String value = jsonObject.getString("heart-beat");
            if (!StringUtils.isEmpty(value)) {
                String[] arrayValue = value.split(",");
                if (null != arrayValue && arrayValue.length >= 2) {
                    int serverReceiveInterval;
                    int serverSendInterval = StringUtils.isEmpty(arrayValue[0]) ? 0 : Integer.valueOf(arrayValue[0]);
                    int n = serverReceiveInterval = StringUtils.isEmpty(arrayValue[1]) ? 0 : Integer.valueOf(arrayValue[1]);
                    if ((serverSendInterval > 0 || serverReceiveInterval > 0) && null == ctx.channel().pipeline().get(IDLE_STATE_HANDLER)) {
                        serverSendInterval = serverSendInterval == 0 ? 0 : serverSendInterval + 1000;
                        serverReceiveInterval = serverReceiveInterval == 0 ? 0 : serverReceiveInterval - 1000;
                        ctx.channel().pipeline().addBefore("socketEncoder", IDLE_STATE_HANDLER, (ChannelHandler)new IdleStateHandler((long)serverSendInterval, (long)serverReceiveInterval, 0L, TimeUnit.MILLISECONDS));
                        ctx.channel().pipeline().addAfter(IDLE_STATE_HANDLER, IDLE_TRIGGER_HANDLER, (ChannelHandler)new IdleTriggerHandler(WebSocketClient.getWcClientByChannel(ctx.channel()), decoder));
                    }
                    decoder.getCallback().connectionAck(serverSendInterval, serverReceiveInterval);
                } else {
                    decoder.getCallback().connectionAck();
                }
            } else {
                decoder.getCallback().connectionAck();
            }
        }
    }

    public static void processError(ChannelHandlerContext ctx, ApiCallbackDecoder decoder, Response response) {
        WebSocketClient wcClient = WebSocketClient.getWcClientByChannel(ctx.channel());
        String userInfo = ApiCallbackDecoderUtils.buildMsgSuffix(ctx, wcClient);
        if (decoder.getCallback() != null) {
            if (response.getCode() > 0) {
                try {
                    if (response.getCode() == TigerApiCode.CONNECTION_KICK_OUT_ERROR.getCode()) {
                        StringBuilder msgBuilder = new StringBuilder(response.getMsg() == null ? TigerApiCode.CONNECTION_KICK_OUT_ERROR.getMessage() : response.getMsg());
                        msgBuilder.append(" ").append(userInfo);
                        ApiLogger.info(msgBuilder.toString());
                        if (null != wcClient) {
                            wcClient.closeConnect();
                        }
                        decoder.getCallback().connectionKickout(response.getCode(), msgBuilder.toString());
                        return;
                    }
                }
                catch (Throwable throwable) {
                    // empty catch block
                }
                decoder.getCallback().error(response.getId(), response.getCode(), response.getMsg() + " " + userInfo);
            } else if (response.getMsg() != null) {
                decoder.getCallback().error(response.getMsg() + " " + userInfo);
            } else {
                decoder.getCallback().error("unknown error. " + userInfo);
            }
        }
    }

    private static String buildMsgSuffix(ChannelHandlerContext ctx, WebSocketClient wcClient) {
        return "[channel:" + ctx.channel().id().asShortText() + ", tigerId:" + (wcClient == null ? "" : wcClient.getClientConfig().tigerId) + ']';
    }
}

