/*
 * Decompiled with CFR 0.152.
 */
package com.tigerbrokers.stock.openapi.client.https.domain.quote.model;

import com.alibaba.fastjson.annotation.JSONField;
import com.tigerbrokers.stock.openapi.client.config.ClientConfig;
import com.tigerbrokers.stock.openapi.client.https.domain.quote.model.QuoteSymbolModel;
import com.tigerbrokers.stock.openapi.client.struct.enums.RightOption;
import com.tigerbrokers.stock.openapi.client.struct.enums.TimeZoneId;
import com.tigerbrokers.stock.openapi.client.util.DateUtils;
import java.util.Date;
import java.util.List;

public class QuoteKlineModel
extends QuoteSymbolModel {
    @JSONField(name="period")
    private String kType;
    private String right;
    @JSONField(name="begin_time")
    private Long beginTime;
    @JSONField(name="end_time")
    private Long endTime;
    private Integer limit;
    @JSONField(name="page_token")
    private String pageToken;

    public QuoteKlineModel() {
    }

    public QuoteKlineModel(List<String> symbols, String kType) {
        super(symbols);
        this.kType = kType;
    }

    public QuoteKlineModel(List<String> symbols, String kType, Long beginTime, Long endTime) {
        super(symbols);
        this.kType = kType;
        this.beginTime = beginTime;
        this.endTime = endTime;
    }

    public QuoteKlineModel(List<String> symbols, String kType, String beginTime, String endTime) {
        super(symbols);
        this.kType = kType;
        this.setBeginTime(beginTime);
        this.setEndTime(endTime);
    }

    public QuoteKlineModel(List<String> symbols, String kType, String beginTime, String endTime, TimeZoneId zoneId) {
        super(symbols);
        this.kType = kType;
        this.setBeginTime(beginTime, zoneId);
        this.setEndTime(endTime, zoneId);
    }

    public String getkType() {
        return this.kType;
    }

    public void setkType(String kType) {
        this.kType = kType;
    }

    public String getRight() {
        return this.right;
    }

    public void setRight(RightOption right) {
        this.right = right == null ? null : right.name();
    }

    public void setRight(String right) {
        this.right = right;
    }

    public Long getBeginTime() {
        return this.beginTime;
    }

    public void setBeginTime(Long beginTime) {
        this.beginTime = beginTime;
    }

    public void setBeginTime(String beginTime) {
        this.setBeginTime(beginTime, ClientConfig.DEFAULT_CONFIG.getDefaultTimeZone());
    }

    public void setBeginTime(String beginTime, TimeZoneId zoneId) {
        Date date = DateUtils.getZoneDate(beginTime, zoneId);
        if (date != null) {
            this.beginTime = date.getTime();
        }
    }

    public Long getEndTime() {
        return this.endTime;
    }

    public void setEndTime(Long endTime) {
        this.endTime = endTime;
    }

    public void setEndTime(String endTime) {
        this.setEndTime(endTime, ClientConfig.DEFAULT_CONFIG.getDefaultTimeZone());
    }

    public void setEndTime(String endTime, TimeZoneId zoneId) {
        Date date = DateUtils.getZoneDate(endTime, zoneId);
        if (date != null) {
            this.endTime = date.getTime();
        }
    }

    public Integer getLimit() {
        return this.limit;
    }

    public void setLimit(Integer limit) {
        this.limit = limit;
    }

    public String getPageToken() {
        return this.pageToken;
    }

    public void setPageToken(String pageToken) {
        this.pageToken = pageToken;
    }
}

