/*
 * Decompiled with CFR 0.152.
 */
package com.tigerbrokers.stock.openapi.client.https.request;

import com.tigerbrokers.stock.openapi.client.https.domain.ApiModel;
import com.tigerbrokers.stock.openapi.client.https.request.TigerRequest;
import com.tigerbrokers.stock.openapi.client.https.response.TigerHttpResponse;
import com.tigerbrokers.stock.openapi.client.struct.enums.MethodName;
import com.tigerbrokers.stock.openapi.client.struct.enums.TimeZoneId;
import com.tigerbrokers.stock.openapi.client.util.DateUtils;
import java.time.LocalDateTime;
import java.time.ZoneId;
import java.time.format.DateTimeFormatter;

public class TigerHttpRequest
implements TigerRequest<TigerHttpResponse> {
    private String apiVersion = "1.0";
    private String tigerId;
    private String signType;
    private MethodName apiMethodName;
    private String bizContent;
    private String charset;
    private String timestamp;
    private String sign;

    @Deprecated
    public TigerHttpRequest(String apiMethodName) {
        this(MethodName.getMethodNameByValue(apiMethodName));
    }

    public TigerHttpRequest(MethodName apiMethodName) {
        this.apiMethodName = apiMethodName;
        DateTimeFormatter dtf = DateUtils.DATETIME_FORMAT;
        this.timestamp = dtf.format(LocalDateTime.now(ZoneId.of(TimeZoneId.Shanghai.getZoneId())));
    }

    @Override
    public String getApiVersion() {
        return this.apiVersion;
    }

    @Override
    public Class<TigerHttpResponse> getResponseClass() {
        return TigerHttpResponse.class;
    }

    @Override
    public void setApiVersion(String apiVersion) {
        this.apiVersion = apiVersion;
    }

    @Override
    public MethodName getApiMethodName() {
        return this.apiMethodName;
    }

    public String getTigerId() {
        return this.tigerId;
    }

    public void setTigerId(String tigerId) {
        this.tigerId = tigerId;
    }

    public String getSignType() {
        return this.signType;
    }

    public void setSignType(String signType) {
        this.signType = signType;
    }

    public String getBizContent() {
        return this.bizContent;
    }

    public void setBizContent(String bizContent) {
        this.bizContent = bizContent;
    }

    public String getCharset() {
        return this.charset;
    }

    public void setCharset(String charset) {
        this.charset = charset;
    }

    @Override
    public String getTimestamp() {
        return this.timestamp;
    }

    @Override
    public void setApiModel(ApiModel apiModel) {
        throw new UnsupportedOperationException();
    }

    @Override
    public ApiModel getApiModel() {
        return null;
    }

    @Override
    public void setTimestamp(String timestamp) {
        this.timestamp = timestamp;
    }

    public String getSign() {
        return this.sign;
    }

    public void setSign(String sign) {
        this.sign = sign;
    }
}

