/*
 * Decompiled with CFR 0.152.
 */
package com.tigerbrokers.stock.openapi.client.https.client;

import com.alibaba.fastjson.JSONObject;
import com.tigerbrokers.stock.openapi.client.config.ClientConfig;
import com.tigerbrokers.stock.openapi.client.https.client.DefaultRefreshTokenCallback;
import com.tigerbrokers.stock.openapi.client.https.client.RefreshTokenCallback;
import com.tigerbrokers.stock.openapi.client.https.client.TigerHttpClient;
import com.tigerbrokers.stock.openapi.client.https.request.user.UserTokenRefreshRequest;
import com.tigerbrokers.stock.openapi.client.https.response.user.UserTokenResponse;
import com.tigerbrokers.stock.openapi.client.struct.enums.TimeZoneId;
import com.tigerbrokers.stock.openapi.client.util.ApiLogger;
import com.tigerbrokers.stock.openapi.client.util.ConfigFileUtil;
import com.tigerbrokers.stock.openapi.client.util.DateUtils;
import com.tigerbrokers.stock.openapi.client.util.StringUtils;
import com.tigerbrokers.stock.openapi.client.util.watch.FileWatchedService;
import com.tigerbrokers.stock.openapi.client.util.watch.TokenFileWatched;
import java.nio.file.Path;
import java.nio.file.Paths;
import java.time.format.DateTimeFormatter;
import java.util.ArrayList;
import java.util.List;
import java.util.Map;
import java.util.concurrent.Executors;
import java.util.concurrent.ScheduledThreadPoolExecutor;
import java.util.concurrent.ThreadFactory;
import java.util.concurrent.TimeUnit;

public class TokenManager {
    private final TigerHttpClient tigerHttpClient;
    private final int defaultRefreshIntervalDays = 5;
    private long refreshIntervalMs = TimeUnit.DAYS.toMillis(5L);
    private ScheduledThreadPoolExecutor executorService;
    private final List<RefreshTokenCallback> callbackList = new ArrayList<RefreshTokenCallback>();
    private final RefreshTokenCallback defaultCallback = new DefaultRefreshTokenCallback();

    public TokenManager(TigerHttpClient client) {
        this.tigerHttpClient = client;
    }

    public void destroy() {
        if (this.executorService != null && !this.executorService.isShutdown()) {
            this.executorService.shutdown();
        }
        this.callbackList.clear();
    }

    public void init() {
        long tokenCreateTime;
        long initialDelay;
        ClientConfig config = this.tigerHttpClient.getClientConfig();
        if (config == null) {
            return;
        }
        this.register(this.defaultCallback);
        this.loadTokenFile(config);
        this.addTokenFileWatch(config);
        if (!config.isAutoRefreshToken) {
            return;
        }
        this.executorService = new ScheduledThreadPoolExecutor(1, new ThreadFactory(){

            @Override
            public Thread newThread(Runnable r) {
                Thread t = Executors.defaultThreadFactory().newThread(r);
                t.setDaemon(true);
                return t;
            }
        });
        if (config.refreshTokenIntervalDays > 0) {
            this.refreshIntervalMs = TimeUnit.DAYS.toMillis(config.refreshTokenIntervalDays);
        }
        if ((initialDelay = (tokenCreateTime = ConfigFileUtil.tryGetCreateTime(config.token)) + this.refreshIntervalMs - System.currentTimeMillis()) <= 0L) {
            this.refreshToken();
            tokenCreateTime = ConfigFileUtil.tryGetCreateTime(config.token);
            initialDelay = tokenCreateTime + this.refreshIntervalMs - System.currentTimeMillis();
        }
        initialDelay = this.getDelayTime(config.refreshTokenTime, initialDelay);
        this.executorService.scheduleWithFixedDelay(new Runnable(){

            @Override
            public void run() {
                TokenManager.this.refreshToken();
            }
        }, initialDelay, this.refreshIntervalMs, TimeUnit.MILLISECONDS);
        if (!StringUtils.isEmpty(config.token)) {
            ApiLogger.info("init auto refresh token task success");
        }
    }

    public void register(RefreshTokenCallback callback) {
        if (callback != null && !this.callbackList.contains(callback)) {
            this.callbackList.add(callback);
        }
    }

    public void unregister(RefreshTokenCallback callback) {
        if (callback != null) {
            this.callbackList.remove(callback);
        }
    }

    public List<RefreshTokenCallback> getCallbackList() {
        return this.callbackList;
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    private void refreshToken() {
        ClientConfig clientConfig = this.tigerHttpClient.getClientConfig();
        if (StringUtils.isEmpty(clientConfig.token) && !this.loadTokenFile(clientConfig)) {
            return;
        }
        long tokenCreateTime = ConfigFileUtil.tryGetCreateTime(clientConfig.token);
        if (tokenCreateTime == 0L) {
            ApiLogger.warn("local token is invalid:{}, refreshToken ignore", clientConfig.token);
            return;
        }
        if (tokenCreateTime + this.refreshIntervalMs - System.currentTimeMillis() > 0L) {
            ApiLogger.info("refreshToken last update time:{}, ignore", DateUtils.printDateTime(tokenCreateTime, DateTimeFormatter.ofPattern("yyyy-MM-dd HH:mm:ss"), clientConfig.timeZone));
            return;
        }
        UserTokenRefreshRequest request = new UserTokenRefreshRequest();
        int count = 5;
        String oldToken = clientConfig.token;
        do {
            try {
                UserTokenResponse response = this.tigerHttpClient.execute(request);
                if (response.isSuccess()) {
                    ApiLogger.info("refreshToken success. return:" + JSONObject.toJSONString((Object)response.getUserToken()));
                    for (RefreshTokenCallback callback : this.callbackList) {
                        callback.tokenChange(clientConfig, oldToken, response.getUserToken());
                    }
                    break;
                }
                TimeUnit.SECONDS.sleep(5L);
            }
            catch (Throwable th) {
                ApiLogger.warn("refreshToken fail. " + th.getMessage(), new Object[0]);
            }
            finally {
                --count;
            }
        } while (count > 0);
    }

    public boolean loadTokenFile(ClientConfig clientConfig) {
        if (!ConfigFileUtil.checkFile(clientConfig.configFilePath, "tiger_openapi_token.properties", false)) {
            return false;
        }
        Path tokenFilePath = Paths.get(clientConfig.configFilePath.trim(), "tiger_openapi_token.properties");
        Map<String, String> dataMap = ConfigFileUtil.readPropertiesFile(tokenFilePath);
        String token = dataMap.get("token");
        if (StringUtils.isEmpty(token)) {
            return false;
        }
        clientConfig.token = token;
        return true;
    }

    private long getTimeInMillis(long baseTimestamp, String time) {
        if (StringUtils.isEmpty(time)) {
            return -1L;
        }
        TimeZoneId timeZoneId = this.tigerHttpClient.getClientConfig().getDefaultTimeZone();
        Long timestamp = DateUtils.getTimestamp(DateUtils.printDate(baseTimestamp, timeZoneId) + " " + time, timeZoneId);
        return timestamp == null ? -1L : timestamp;
    }

    private long getDelayTime(String time, long initialDelay) {
        long delayTime;
        initialDelay = initialDelay <= 0L ? 0L : initialDelay;
        long baseTimestamp = System.currentTimeMillis();
        long refreshTimestamp = this.getTimeInMillis(baseTimestamp, time);
        if (refreshTimestamp < 0L) {
            return initialDelay;
        }
        if (initialDelay > 0L) {
            refreshTimestamp = this.getTimeInMillis(baseTimestamp += initialDelay, time);
        }
        if ((delayTime = refreshTimestamp - baseTimestamp + initialDelay) < 0L) {
            delayTime += TimeUnit.DAYS.toMillis(1L);
        }
        return delayTime;
    }

    public void addTokenFileWatch(ClientConfig config) {
        try {
            if (null == config || StringUtils.isEmpty(config.configFilePath)) {
                return;
            }
            if (ConfigFileUtil.checkFile(config.configFilePath, "tiger_openapi_token.properties", false)) {
                Path configFilePath = Paths.get(config.configFilePath, new String[0]);
                TokenFileWatched tokenFileListener = new TokenFileWatched(config, this);
                final FileWatchedService fileWatchedService = new FileWatchedService(configFilePath, tokenFileListener);
                new Thread(){

                    @Override
                    public void run() {
                        fileWatchedService.watch();
                    }
                }.start();
                ApiLogger.info("addTokenFileWatch success.");
            }
        }
        catch (Exception e) {
            ApiLogger.error("addTokenFileWatch fail.", e);
        }
    }
}

