/*
 * Decompiled with CFR 0.152.
 */
package com.tigerbrokers.stock.openapi.client.https.request.trade;

import com.tigerbrokers.stock.openapi.client.config.ClientConfig;
import com.tigerbrokers.stock.openapi.client.https.domain.ApiModel;
import com.tigerbrokers.stock.openapi.client.https.domain.contract.item.ContractItem;
import com.tigerbrokers.stock.openapi.client.https.domain.trade.item.ContractLeg;
import com.tigerbrokers.stock.openapi.client.https.domain.trade.model.TradeOrderModel;
import com.tigerbrokers.stock.openapi.client.https.request.TigerCommonRequest;
import com.tigerbrokers.stock.openapi.client.https.request.TigerRequest;
import com.tigerbrokers.stock.openapi.client.https.response.trade.TradeOrderPreviewResponse;
import com.tigerbrokers.stock.openapi.client.struct.TagValue;
import com.tigerbrokers.stock.openapi.client.struct.enums.ActionType;
import com.tigerbrokers.stock.openapi.client.struct.enums.AttachType;
import com.tigerbrokers.stock.openapi.client.struct.enums.ComboType;
import com.tigerbrokers.stock.openapi.client.struct.enums.Currency;
import com.tigerbrokers.stock.openapi.client.struct.enums.Language;
import com.tigerbrokers.stock.openapi.client.struct.enums.MethodName;
import com.tigerbrokers.stock.openapi.client.struct.enums.OrderType;
import com.tigerbrokers.stock.openapi.client.struct.enums.SecType;
import com.tigerbrokers.stock.openapi.client.struct.enums.TimeInForce;
import com.tigerbrokers.stock.openapi.client.struct.enums.TradeSession;
import com.tigerbrokers.stock.openapi.client.struct.enums.TradingSessionType;
import com.tigerbrokers.stock.openapi.client.util.AccountUtil;
import com.tigerbrokers.stock.openapi.client.util.StringUtils;
import java.util.ArrayList;
import java.util.List;

public class TradeOrderPreviewRequest
extends TigerCommonRequest
implements TigerRequest<TradeOrderPreviewResponse> {
    public TradeOrderPreviewRequest() {
        this.setApiVersion("1.0");
        this.setApiMethodName(MethodName.PREVIEW_ORDER);
    }

    public static TradeOrderPreviewRequest buildMarketOrder(ContractItem contract, ActionType action, Integer quantity) {
        return TradeOrderPreviewRequest.buildMarketOrder(ClientConfig.DEFAULT_CONFIG.defaultAccount, contract, action, quantity);
    }

    public static TradeOrderPreviewRequest buildMarketOrder(String account, ContractItem contract, ActionType action, Integer quantity) {
        TradeOrderModel tradeOrderModel = TradeOrderPreviewRequest.buildTradeOrderModel(account, contract, action, TradeOrderPreviewRequest.convertToLong(quantity), null);
        tradeOrderModel.setOrderType(OrderType.MKT);
        return TradeOrderPreviewRequest.newRequest(tradeOrderModel);
    }

    public static TradeOrderPreviewRequest buildMarketOrder(ContractItem contract, ActionType action, Long quantity, Integer quantityScale) {
        return TradeOrderPreviewRequest.buildMarketOrder(ClientConfig.DEFAULT_CONFIG.defaultAccount, contract, action, quantity, quantityScale);
    }

    public static TradeOrderPreviewRequest buildMarketOrder(String account, ContractItem contract, ActionType action, Long quantity, Integer quantityScale) {
        TradeOrderModel tradeOrderModel = TradeOrderPreviewRequest.buildTradeOrderModel(account, contract, action, quantity, quantityScale);
        tradeOrderModel.setOrderType(OrderType.MKT);
        return TradeOrderPreviewRequest.newRequest(tradeOrderModel);
    }

    public static TradeOrderPreviewRequest buildLimitOrder(ContractItem contract, ActionType action, Integer quantity, Double limitPrice) {
        return TradeOrderPreviewRequest.buildLimitOrder(ClientConfig.DEFAULT_CONFIG.defaultAccount, contract, action, quantity, limitPrice);
    }

    public static TradeOrderPreviewRequest buildLimitOrder(String account, ContractItem contract, ActionType action, Integer quantity, Double limitPrice) {
        return TradeOrderPreviewRequest.buildLimitOrder(account, contract, action, quantity, limitPrice, (Double)0.0);
    }

    public static TradeOrderPreviewRequest buildLimitOrder(String account, ContractItem contract, ActionType action, Integer quantity, Double limitPrice, Double adjustLimit) {
        TradeOrderModel tradeOrderModel = TradeOrderPreviewRequest.buildTradeOrderModel(account, contract, action, TradeOrderPreviewRequest.convertToLong(quantity), null);
        tradeOrderModel.setOrderType(OrderType.LMT);
        tradeOrderModel.setLimitPrice(limitPrice);
        tradeOrderModel.setAdjustLimit(adjustLimit);
        return TradeOrderPreviewRequest.newRequest(tradeOrderModel);
    }

    public static TradeOrderPreviewRequest buildLimitOrder(ContractItem contract, ActionType action, Long quantity, Integer quantityScale, Double limitPrice) {
        return TradeOrderPreviewRequest.buildLimitOrder(ClientConfig.DEFAULT_CONFIG.defaultAccount, contract, action, quantity, quantityScale, limitPrice);
    }

    public static TradeOrderPreviewRequest buildLimitOrder(String account, ContractItem contract, ActionType action, Long quantity, Integer quantityScale, Double limitPrice) {
        return TradeOrderPreviewRequest.buildLimitOrder(account, contract, action, quantity, quantityScale, limitPrice, 0.0);
    }

    public static TradeOrderPreviewRequest buildLimitOrder(String account, ContractItem contract, ActionType action, Long quantity, Integer quantityScale, Double limitPrice, Double adjustLimit) {
        TradeOrderModel tradeOrderModel = TradeOrderPreviewRequest.buildTradeOrderModel(account, contract, action, quantity, quantityScale);
        tradeOrderModel.setOrderType(OrderType.LMT);
        tradeOrderModel.setLimitPrice(limitPrice);
        tradeOrderModel.setAdjustLimit(adjustLimit);
        return TradeOrderPreviewRequest.newRequest(tradeOrderModel);
    }

    public static TradeOrderPreviewRequest buildStopOrder(ContractItem contract, ActionType action, Integer quantity, Double auxPrice) {
        return TradeOrderPreviewRequest.buildStopOrder(ClientConfig.DEFAULT_CONFIG.defaultAccount, contract, action, quantity, auxPrice);
    }

    public static TradeOrderPreviewRequest buildStopOrder(String account, ContractItem contract, ActionType action, Integer quantity, Double auxPrice) {
        return TradeOrderPreviewRequest.buildStopOrder(account, contract, action, quantity, auxPrice, (Double)0.0);
    }

    public static TradeOrderPreviewRequest buildStopOrder(String account, ContractItem contract, ActionType action, Integer quantity, Double auxPrice, Double adjustLimit) {
        TradeOrderModel tradeOrderModel = TradeOrderPreviewRequest.buildTradeOrderModel(account, contract, action, TradeOrderPreviewRequest.convertToLong(quantity), null);
        tradeOrderModel.setOrderType(OrderType.STP);
        tradeOrderModel.setAuxPrice(auxPrice);
        tradeOrderModel.setAdjustLimit(adjustLimit);
        return TradeOrderPreviewRequest.newRequest(tradeOrderModel);
    }

    public static TradeOrderPreviewRequest buildStopOrder(ContractItem contract, ActionType action, Long quantity, Integer quantityScale, Double auxPrice) {
        return TradeOrderPreviewRequest.buildStopOrder(ClientConfig.DEFAULT_CONFIG.defaultAccount, contract, action, quantity, quantityScale, auxPrice);
    }

    public static TradeOrderPreviewRequest buildStopOrder(String account, ContractItem contract, ActionType action, Long quantity, Integer quantityScale, Double auxPrice) {
        return TradeOrderPreviewRequest.buildStopOrder(account, contract, action, quantity, quantityScale, auxPrice, 0.0);
    }

    public static TradeOrderPreviewRequest buildStopOrder(String account, ContractItem contract, ActionType action, Long quantity, Integer quantityScale, Double auxPrice, Double adjustLimit) {
        TradeOrderModel tradeOrderModel = TradeOrderPreviewRequest.buildTradeOrderModel(account, contract, action, quantity, quantityScale);
        tradeOrderModel.setOrderType(OrderType.STP);
        tradeOrderModel.setAuxPrice(auxPrice);
        tradeOrderModel.setAdjustLimit(adjustLimit);
        return TradeOrderPreviewRequest.newRequest(tradeOrderModel);
    }

    public static TradeOrderPreviewRequest buildStopLimitOrder(ContractItem contract, ActionType action, Integer quantity, Double limitPrice, Double auxPrice) {
        return TradeOrderPreviewRequest.buildStopLimitOrder(ClientConfig.DEFAULT_CONFIG.defaultAccount, contract, action, quantity, limitPrice, auxPrice);
    }

    public static TradeOrderPreviewRequest buildStopLimitOrder(String account, ContractItem contract, ActionType action, Integer quantity, Double limitPrice, Double auxPrice) {
        return TradeOrderPreviewRequest.buildStopLimitOrder(account, contract, action, quantity, limitPrice, auxPrice, (Double)0.0);
    }

    public static TradeOrderPreviewRequest buildStopLimitOrder(String account, ContractItem contract, ActionType action, Integer quantity, Double limitPrice, Double auxPrice, Double adjustLimit) {
        TradeOrderModel tradeOrderModel = TradeOrderPreviewRequest.buildTradeOrderModel(account, contract, action, TradeOrderPreviewRequest.convertToLong(quantity), null);
        tradeOrderModel.setOrderType(OrderType.STP_LMT);
        tradeOrderModel.setLimitPrice(limitPrice);
        tradeOrderModel.setAuxPrice(auxPrice);
        tradeOrderModel.setAdjustLimit(adjustLimit);
        return TradeOrderPreviewRequest.newRequest(tradeOrderModel);
    }

    public static TradeOrderPreviewRequest buildStopLimitOrder(ContractItem contract, ActionType action, Long quantity, Integer quantityScale, Double limitPrice, Double auxPrice) {
        return TradeOrderPreviewRequest.buildStopLimitOrder(ClientConfig.DEFAULT_CONFIG.defaultAccount, contract, action, quantity, quantityScale, limitPrice, auxPrice);
    }

    public static TradeOrderPreviewRequest buildStopLimitOrder(String account, ContractItem contract, ActionType action, Long quantity, Integer quantityScale, Double limitPrice, Double auxPrice) {
        return TradeOrderPreviewRequest.buildStopLimitOrder(account, contract, action, quantity, quantityScale, limitPrice, auxPrice, 0.0);
    }

    public static TradeOrderPreviewRequest buildStopLimitOrder(String account, ContractItem contract, ActionType action, Long quantity, Integer quantityScale, Double limitPrice, Double auxPrice, Double adjustLimit) {
        TradeOrderModel tradeOrderModel = TradeOrderPreviewRequest.buildTradeOrderModel(account, contract, action, quantity, quantityScale);
        tradeOrderModel.setOrderType(OrderType.STP_LMT);
        tradeOrderModel.setLimitPrice(limitPrice);
        tradeOrderModel.setAuxPrice(auxPrice);
        tradeOrderModel.setAdjustLimit(adjustLimit);
        return TradeOrderPreviewRequest.newRequest(tradeOrderModel);
    }

    public static TradeOrderPreviewRequest buildTrailOrder(ContractItem contract, ActionType action, Integer quantity, Double trailingPercent, Double auxPrice) {
        return TradeOrderPreviewRequest.buildTrailOrder(ClientConfig.DEFAULT_CONFIG.defaultAccount, contract, action, quantity, trailingPercent, auxPrice);
    }

    public static TradeOrderPreviewRequest buildTrailOrder(String account, ContractItem contract, ActionType action, Integer quantity, Double trailingPercent, Double auxPrice) {
        TradeOrderModel tradeOrderModel = TradeOrderPreviewRequest.buildTradeOrderModel(account, contract, action, TradeOrderPreviewRequest.convertToLong(quantity), null);
        tradeOrderModel.setOrderType(OrderType.TRAIL);
        tradeOrderModel.setTrailingPercent(trailingPercent);
        tradeOrderModel.setAuxPrice(auxPrice);
        return TradeOrderPreviewRequest.newRequest(tradeOrderModel);
    }

    public static TradeOrderPreviewRequest buildTrailOrder(ContractItem contract, ActionType action, Long quantity, Integer quantityScale, Double trailingPercent, Double auxPrice) {
        return TradeOrderPreviewRequest.buildTrailOrder(ClientConfig.DEFAULT_CONFIG.defaultAccount, contract, action, quantity, quantityScale, trailingPercent, auxPrice);
    }

    public static TradeOrderPreviewRequest buildTrailOrder(String account, ContractItem contract, ActionType action, Long quantity, Integer quantityScale, Double trailingPercent, Double auxPrice) {
        TradeOrderModel tradeOrderModel = TradeOrderPreviewRequest.buildTradeOrderModel(account, contract, action, quantity, quantityScale);
        tradeOrderModel.setOrderType(OrderType.TRAIL);
        tradeOrderModel.setTrailingPercent(trailingPercent);
        tradeOrderModel.setAuxPrice(auxPrice);
        return TradeOrderPreviewRequest.newRequest(tradeOrderModel);
    }

    public static TradeOrderPreviewRequest buildAmountOrder(String account, ContractItem contract, ActionType action, Double cashAmount) {
        TradeOrderModel tradeOrderModel = TradeOrderPreviewRequest.buildTradeOrderModel(account, contract, action, null, null);
        tradeOrderModel.setOrderType(OrderType.MKT);
        tradeOrderModel.setCashAmount(cashAmount);
        return TradeOrderPreviewRequest.newRequest(tradeOrderModel);
    }

    public static TradeOrderModel buildTradeOrderModel(String account, ContractItem contract, ActionType action, Long quantity, Integer quantityScale) {
        if (contract == null) {
            throw new IllegalArgumentException("parameter 'contract' is null");
        }
        TradeOrderModel model = new TradeOrderModel();
        model.setAccount(account);
        model.setAction(action);
        model.setTotalQuantity(quantity);
        model.setTotalQuantityScale(quantityScale);
        model.setSymbol(contract.getSymbol());
        model.setCurrency(contract.getCurrency() == null ? null : Currency.valueOf(contract.getCurrency()));
        model.setSecType(contract.getSecType() == null ? null : SecType.valueOf(contract.getSecType()));
        model.setExchange(contract.getExchange());
        model.setMarket(contract.getMarket());
        model.setLocalSymbol(contract.getLocalSymbol());
        model.setExpiry(contract.getExpiry());
        model.setStrike(contract.getStrike() == null ? null : contract.getStrike().toString());
        model.setRight(contract.getRight());
        model.setMultiplier(contract.getMultiplier() == null ? null : Float.valueOf(contract.getMultiplier().floatValue()));
        if (model.getSecType() == SecType.FUT) {
            if (AccountUtil.isGlobalAccount(account)) {
                if (!StringUtils.isEmpty(contract.getType())) {
                    model.setSymbol(contract.getType());
                }
                if (StringUtils.isEmpty(model.getExpiry()) && !StringUtils.isEmpty(contract.getLastTradingDate())) {
                    model.setExpiry(contract.getLastTradingDate());
                }
            } else {
                model.setExpiry(null);
            }
        }
        return model;
    }

    public static TradeOrderPreviewRequest buildMultiLegOrder(String account, List<ContractLeg> contractLegs, ComboType comboType, ActionType action, Integer quantity, OrderType orderType, Double limitPrice, Double auxPrice, Double trailingPercent) {
        return TradeOrderPreviewRequest.buildMultiLegOrder(account, contractLegs, comboType, action, TradeOrderPreviewRequest.convertToLong(quantity), null, orderType, limitPrice, auxPrice, trailingPercent);
    }

    public static TradeOrderPreviewRequest buildMultiLegOrder(String account, List<ContractLeg> contractLegs, ComboType comboType, ActionType action, Long quantity, Integer quantityScale, OrderType orderType, Double limitPrice, Double auxPrice, Double trailingPercent) {
        if (contractLegs == null) {
            throw new IllegalArgumentException("parameter 'contractLegs' is null");
        }
        if (orderType == null) {
            throw new IllegalArgumentException("parameter 'orderType' is null");
        }
        TradeOrderModel model = new TradeOrderModel();
        model.setSecType(SecType.MLEG);
        model.setComboType(comboType.name());
        model.setAccount(StringUtils.isEmpty(account) ? ClientConfig.DEFAULT_CONFIG.defaultAccount : account);
        model.setAction(action);
        model.setTotalQuantity(quantity);
        model.setTotalQuantityScale(quantityScale);
        model.setContractLegs(contractLegs);
        model.setOrderType(orderType);
        model.setLimitPrice(limitPrice);
        model.setAuxPrice(auxPrice);
        model.setTrailingPercent(trailingPercent);
        model.setTimeInForce(TimeInForce.DAY);
        return TradeOrderPreviewRequest.newRequest(model);
    }

    public static TradeOrderPreviewRequest buildTWAPOrder(String account, String symbol, ActionType action, Integer quantity, Long startTime, Long endTime, Double limitPrice) {
        return TradeOrderPreviewRequest.buildWAPOrder(account, symbol, action, quantity, OrderType.TWAP, startTime, endTime, null, limitPrice);
    }

    public static TradeOrderPreviewRequest buildVWAPOrder(String account, String symbol, ActionType action, Integer quantity, Long startTime, Long endTime, Double participationRate, Double limitPrice) {
        return TradeOrderPreviewRequest.buildWAPOrder(account, symbol, action, quantity, OrderType.VWAP, startTime, endTime, participationRate, limitPrice);
    }

    public static TradeOrderPreviewRequest buildWAPOrder(String account, String symbol, ActionType action, Integer quantity, OrderType orderType, Long startTime, Long endTime, Double participationRate, Double limitPrice) {
        return TradeOrderPreviewRequest.buildWAPOrder(account, symbol, action, TradeOrderPreviewRequest.convertToLong(quantity), null, orderType, startTime, endTime, participationRate, limitPrice);
    }

    public static TradeOrderPreviewRequest buildWAPOrder(String account, String symbol, ActionType action, Long quantity, Integer quantityScale, OrderType orderType, Long startTime, Long endTime, Double participationRate, Double limitPrice) {
        if (OrderType.TWAP != orderType && OrderType.VWAP != orderType) {
            throw new IllegalArgumentException("parameter 'orderType' must be ['TWAP', 'VWAP']");
        }
        TradeOrderModel model = new TradeOrderModel();
        model.setOutsideRth(Boolean.FALSE);
        model.setSecType(SecType.STK);
        model.setAccount(StringUtils.isEmpty(account) ? ClientConfig.DEFAULT_CONFIG.defaultAccount : account);
        model.setAction(action);
        model.setTotalQuantity(quantity);
        model.setTotalQuantityScale(quantityScale);
        model.setSymbol(symbol);
        model.setOrderType(orderType);
        model.setLimitPrice(limitPrice);
        model.setTimeInForce(TimeInForce.DAY);
        model.setAlgoStrategy(orderType.name());
        model.addAlgoParam(TagValue.buildTagValue("start_time", startTime));
        model.addAlgoParam(TagValue.buildTagValue("end_time", endTime));
        if (OrderType.VWAP == orderType) {
            model.addAlgoParam(TagValue.buildTagValue("participation_rate", participationRate));
        }
        return TradeOrderPreviewRequest.newRequest(model);
    }

    public static TradeOrderPreviewRequest buildOCABracketsOrder(ContractItem contract, ActionType action, Integer quantity, Double profitTakerPrice, TimeInForce profitTakerTif, Boolean profitTakerRth, Double stopLossPrice, Double stopLossLimitPrice, TimeInForce stopLossTif, Boolean stopLossRth) {
        return TradeOrderPreviewRequest.buildOCABracketsOrder(ClientConfig.DEFAULT_CONFIG.defaultAccount, contract, action, TradeOrderPreviewRequest.convertToLong(quantity), null, profitTakerPrice, profitTakerTif, profitTakerRth, stopLossPrice, stopLossLimitPrice, stopLossTif, stopLossRth);
    }

    public static TradeOrderPreviewRequest buildOCABracketsOrder(String account, ContractItem contract, ActionType action, Long quantity, Integer quantityScale, Double profitTakerPrice, TimeInForce profitTakerTif, Boolean profitTakerRth, Double stopLossPrice, Double stopLossLimitPrice, TimeInForce stopLossTif, Boolean stopLossRth) {
        TradeOrderModel profitTakerOrder = TradeOrderPreviewRequest.buildTradeOrderModel(account, contract, action, quantity, quantityScale);
        profitTakerOrder.setOrderType(OrderType.LMT);
        profitTakerOrder.setLimitPrice(profitTakerPrice);
        profitTakerOrder.setTimeInForce(profitTakerTif);
        profitTakerOrder.setOutsideRth(profitTakerRth);
        TradeOrderModel stopLossOrder = TradeOrderPreviewRequest.buildTradeOrderModel(account, contract, action, quantity, quantityScale);
        if (stopLossLimitPrice == null) {
            stopLossOrder.setOrderType(OrderType.STP);
        } else {
            stopLossOrder.setOrderType(OrderType.STP_LMT);
            stopLossOrder.setLimitPrice(stopLossLimitPrice);
        }
        stopLossOrder.setAuxPrice(stopLossPrice);
        stopLossOrder.setTimeInForce(stopLossTif);
        stopLossOrder.setOutsideRth(stopLossRth);
        ArrayList<TradeOrderModel> ocaOrders = new ArrayList<TradeOrderModel>();
        ocaOrders.add(profitTakerOrder);
        ocaOrders.add(stopLossOrder);
        TradeOrderModel tradeOrderModel = new TradeOrderModel();
        tradeOrderModel.setOcaOrders(ocaOrders);
        tradeOrderModel.setAccount(account);
        return TradeOrderPreviewRequest.newRequest(tradeOrderModel);
    }

    public static TradeOrderPreviewRequest newRequest(TradeOrderModel model) {
        TradeOrderPreviewRequest request = new TradeOrderPreviewRequest();
        request.setApiModel(model);
        return request;
    }

    public static void addProfitTakerOrder(TradeOrderPreviewRequest tradeOrderRequest, Double profitTakerPrice, TimeInForce profitTakerTif, Boolean profitTakerRth) {
        TradeOrderModel model = (TradeOrderModel)tradeOrderRequest.getApiModel();
        model.setAttachType(AttachType.PROFIT);
        model.setProfitTakerPrice(profitTakerPrice);
        model.setProfitTakerTif(profitTakerTif);
        model.setProfitTakerRth(profitTakerRth);
    }

    public static void addStopLossOrder(TradeOrderPreviewRequest tradeOrderRequest, Double stopLossPrice, TimeInForce stopLossTif) {
        TradeOrderModel model = (TradeOrderModel)tradeOrderRequest.getApiModel();
        model.setAttachType(AttachType.LOSS);
        model.setStopLossOrderType(OrderType.STP);
        model.setStopLossPrice(stopLossPrice);
        model.setStopLossTif(stopLossTif);
    }

    public static void addStopLossLimitOrder(TradeOrderPreviewRequest tradeOrderRequest, Double stopLossPrice, Double stopLossLimitPrice, TimeInForce stopLossTif) {
        TradeOrderModel model = (TradeOrderModel)tradeOrderRequest.getApiModel();
        model.setAttachType(AttachType.LOSS);
        model.setStopLossOrderType(OrderType.STP_LMT);
        model.setStopLossPrice(stopLossPrice);
        model.setStopLossLimitPrice(stopLossLimitPrice);
        model.setStopLossTif(stopLossTif);
    }

    public static void addStopLossTrailOrder(TradeOrderPreviewRequest tradeOrderRequest, Double stopLossTrailingPercent, Double stopLossTrailingAmount, TimeInForce stopLossTif) {
        TradeOrderModel model = (TradeOrderModel)tradeOrderRequest.getApiModel();
        model.setAttachType(AttachType.LOSS);
        model.setStopLossOrderType(OrderType.TRAIL);
        model.setStopLossTrailingPercent(stopLossTrailingPercent);
        model.setStopLossTrailingAmount(stopLossTrailingAmount);
        model.setStopLossTif(stopLossTif);
    }

    public static void addBracketsOrder(TradeOrderPreviewRequest tradeOrderRequest, Double profitTakerPrice, TimeInForce profitTakerTif, Boolean profitTakerRth, Double stopLossPrice, TimeInForce stopLossTif) {
        TradeOrderPreviewRequest.addBracketsOrder(tradeOrderRequest, profitTakerPrice, profitTakerTif, profitTakerRth, stopLossPrice, null, stopLossTif);
    }

    public static void addBracketsOrder(TradeOrderPreviewRequest tradeOrderRequest, Double profitTakerPrice, TimeInForce profitTakerTif, Boolean profitTakerRth, Double stopLossPrice, Double stopLossLimitPrice, TimeInForce stopLossTif) {
        TradeOrderModel model = (TradeOrderModel)tradeOrderRequest.getApiModel();
        model.setAttachType(AttachType.BRACKETS);
        model.setProfitTakerPrice(profitTakerPrice);
        model.setProfitTakerTif(profitTakerTif);
        model.setProfitTakerRth(profitTakerRth);
        model.setStopLossPrice(stopLossPrice);
        model.setStopLossLimitPrice(stopLossLimitPrice);
        model.setStopLossTif(stopLossTif);
    }

    public TradeOrderPreviewRequest setOrderId(Integer orderId) {
        TradeOrderModel model = (TradeOrderModel)this.getApiModel();
        model.setOrderId(orderId);
        return this;
    }

    public TradeOrderPreviewRequest setAccount(String account) {
        TradeOrderModel model = (TradeOrderModel)this.getApiModel();
        model.setAccount(account);
        return this;
    }

    public TradeOrderPreviewRequest setSecretKey(String secretKey) {
        TradeOrderModel model = (TradeOrderModel)this.getApiModel();
        model.setSecretKey(secretKey);
        return this;
    }

    public TradeOrderPreviewRequest setSymbol(String symbol) {
        TradeOrderModel model = (TradeOrderModel)this.getApiModel();
        model.setSymbol(symbol);
        return this;
    }

    public TradeOrderPreviewRequest setSecType(SecType secType) {
        TradeOrderModel model = (TradeOrderModel)this.getApiModel();
        model.setSecType(secType);
        return this;
    }

    public TradeOrderPreviewRequest setAction(ActionType action) {
        TradeOrderModel model = (TradeOrderModel)this.getApiModel();
        model.setAction(action);
        return this;
    }

    public TradeOrderPreviewRequest setCurrency(Currency currency) {
        TradeOrderModel model = (TradeOrderModel)this.getApiModel();
        model.setCurrency(currency);
        return this;
    }

    public TradeOrderPreviewRequest setTotalQuantity(Long totalQuantity) {
        TradeOrderModel model = (TradeOrderModel)this.getApiModel();
        model.setTotalQuantity(totalQuantity);
        return this;
    }

    public TradeOrderPreviewRequest setTotalQuantityScale(Integer totalQuantityScale) {
        TradeOrderModel model = (TradeOrderModel)this.getApiModel();
        model.setTotalQuantityScale(totalQuantityScale);
        return this;
    }

    public TradeOrderPreviewRequest setCashAmount(Double cashAmount) {
        TradeOrderModel model = (TradeOrderModel)this.getApiModel();
        model.setCashAmount(cashAmount);
        return this;
    }

    public TradeOrderPreviewRequest setOrderType(OrderType orderType) {
        TradeOrderModel model = (TradeOrderModel)this.getApiModel();
        model.setOrderType(orderType);
        return this;
    }

    public TradeOrderPreviewRequest setLimitPrice(Double limitPrice) {
        TradeOrderModel model = (TradeOrderModel)this.getApiModel();
        model.setLimitPrice(limitPrice);
        return this;
    }

    public TradeOrderPreviewRequest setAdjustLimit(Double adjustLimit) {
        TradeOrderModel model = (TradeOrderModel)this.getApiModel();
        model.setAdjustLimit(adjustLimit);
        return this;
    }

    public TradeOrderPreviewRequest setAuxPrice(Double auxPrice) {
        TradeOrderModel model = (TradeOrderModel)this.getApiModel();
        model.setAuxPrice(auxPrice);
        return this;
    }

    public TradeOrderPreviewRequest setTrailingPercent(Double trailingPercent) {
        TradeOrderModel model = (TradeOrderModel)this.getApiModel();
        model.setTrailingPercent(trailingPercent);
        return this;
    }

    public TradeOrderPreviewRequest setOutsideRth(Boolean outsideRth) {
        TradeOrderModel model = (TradeOrderModel)this.getApiModel();
        model.setOutsideRth(outsideRth);
        return this;
    }

    public TradeOrderPreviewRequest setMarket(String market) {
        TradeOrderModel model = (TradeOrderModel)this.getApiModel();
        model.setMarket(market);
        return this;
    }

    public TradeOrderPreviewRequest setExchange(String exchange) {
        TradeOrderModel model = (TradeOrderModel)this.getApiModel();
        model.setExchange(exchange);
        return this;
    }

    public TradeOrderPreviewRequest setExpiry(String expiry) {
        TradeOrderModel model = (TradeOrderModel)this.getApiModel();
        model.setExpiry(expiry);
        return this;
    }

    public TradeOrderPreviewRequest setStrike(String strike) {
        TradeOrderModel model = (TradeOrderModel)this.getApiModel();
        model.setStrike(strike);
        return this;
    }

    public TradeOrderPreviewRequest setRight(String right) {
        TradeOrderModel model = (TradeOrderModel)this.getApiModel();
        model.setRight(right);
        return this;
    }

    public TradeOrderPreviewRequest setMultiplier(Float multiplier) {
        TradeOrderModel model = (TradeOrderModel)this.getApiModel();
        model.setMultiplier(multiplier);
        return this;
    }

    public TradeOrderPreviewRequest setLocalSymbol(String localSymbol) {
        TradeOrderModel model = (TradeOrderModel)this.getApiModel();
        model.setLocalSymbol(localSymbol);
        return this;
    }

    public TradeOrderPreviewRequest setAllocAccounts(List<String> allocAccounts) {
        TradeOrderModel model = (TradeOrderModel)this.getApiModel();
        model.setAllocAccounts(allocAccounts);
        return this;
    }

    public TradeOrderPreviewRequest setAllocShares(List<Double> allocShares) {
        TradeOrderModel model = (TradeOrderModel)this.getApiModel();
        model.setAllocShares(allocShares);
        return this;
    }

    public TradeOrderPreviewRequest setAlgoStrategy(String algoStrategy) {
        TradeOrderModel model = (TradeOrderModel)this.getApiModel();
        model.setAlgoStrategy(algoStrategy);
        return this;
    }

    public TradeOrderPreviewRequest setAlgoParams(List<TagValue> algoParams) {
        TradeOrderModel model = (TradeOrderModel)this.getApiModel();
        model.setAlgoParams(algoParams);
        return this;
    }

    public TradeOrderPreviewRequest setAttachType(AttachType attachType) {
        TradeOrderModel model = (TradeOrderModel)this.getApiModel();
        model.setAttachType(attachType);
        return this;
    }

    public TradeOrderPreviewRequest setProfitTakerOrderId(Integer profitTakerOrderId) {
        TradeOrderModel model = (TradeOrderModel)this.getApiModel();
        model.setProfitTakerOrderId(profitTakerOrderId);
        return this;
    }

    public TradeOrderPreviewRequest setProfitTakerPrice(Double profitTakerPrice) {
        TradeOrderModel model = (TradeOrderModel)this.getApiModel();
        model.setProfitTakerPrice(profitTakerPrice);
        return this;
    }

    public TradeOrderPreviewRequest setProfitTakerTif(TimeInForce profitTakerTif) {
        TradeOrderModel model = (TradeOrderModel)this.getApiModel();
        model.setProfitTakerTif(profitTakerTif);
        return this;
    }

    public TradeOrderPreviewRequest setProfitTakerRth(Boolean profitTakerRth) {
        TradeOrderModel model = (TradeOrderModel)this.getApiModel();
        model.setProfitTakerRth(profitTakerRth);
        return this;
    }

    public TradeOrderPreviewRequest setStopLossOrderType(OrderType stopLossOrderType) {
        TradeOrderModel model = (TradeOrderModel)this.getApiModel();
        model.setStopLossOrderType(stopLossOrderType);
        return this;
    }

    public TradeOrderPreviewRequest setStopLossOrderId(Integer stopLossOrderId) {
        TradeOrderModel model = (TradeOrderModel)this.getApiModel();
        model.setStopLossOrderId(stopLossOrderId);
        return this;
    }

    public TradeOrderPreviewRequest setStopLossPrice(Double stopLossPrice) {
        TradeOrderModel model = (TradeOrderModel)this.getApiModel();
        model.setStopLossPrice(stopLossPrice);
        return this;
    }

    public TradeOrderPreviewRequest setStopLossLimitPrice(Double stopLossLimitPrice) {
        TradeOrderModel model = (TradeOrderModel)this.getApiModel();
        model.setStopLossLimitPrice(stopLossLimitPrice);
        return this;
    }

    public TradeOrderPreviewRequest setStopLossTif(TimeInForce stopLossTif) {
        TradeOrderModel model = (TradeOrderModel)this.getApiModel();
        model.setStopLossTif(stopLossTif);
        return this;
    }

    public TradeOrderPreviewRequest setStopLossTrailingPercent(Double stopLossTrailingPercent) {
        TradeOrderModel model = (TradeOrderModel)this.getApiModel();
        model.setStopLossTrailingPercent(stopLossTrailingPercent);
        return this;
    }

    public TradeOrderPreviewRequest setStopLossTrailingAmount(Double stopLossTrailingAmount) {
        TradeOrderModel model = (TradeOrderModel)this.getApiModel();
        model.setStopLossTrailingAmount(stopLossTrailingAmount);
        return this;
    }

    public TradeOrderPreviewRequest withUserMark(String userMark) {
        return this.setUserMark(userMark);
    }

    public TradeOrderPreviewRequest setUserMark(String userMark) {
        TradeOrderModel model = (TradeOrderModel)this.getApiModel();
        model.setUserMark(userMark);
        return this;
    }

    public TradeOrderPreviewRequest setTimeInForce(TimeInForce timeInForce) {
        TradeOrderModel model = (TradeOrderModel)this.getApiModel();
        model.setTimeInForce(timeInForce);
        return this;
    }

    public TradeOrderPreviewRequest setExpireTime(Long expireTime) {
        TradeOrderModel model = (TradeOrderModel)this.getApiModel();
        model.setExpireTime(expireTime);
        return this;
    }

    @Deprecated
    public TradeOrderPreviewRequest setTradingSessionType(TradeSession tradingSessionType) {
        TradeOrderModel model = (TradeOrderModel)this.getApiModel();
        if (TradeSession.OverNight == tradingSessionType) {
            model.setTradingSessionType(TradingSessionType.OVERNIGHT);
        }
        return this;
    }

    public TradeOrderPreviewRequest setTradingSessionType(TradingSessionType tradingSessionType) {
        TradeOrderModel model = (TradeOrderModel)this.getApiModel();
        model.setTradingSessionType(tradingSessionType);
        return this;
    }

    public TradeOrderPreviewRequest setLang(Language lang) {
        ApiModel model = this.getApiModel();
        model.setLang(lang);
        return this;
    }

    public TradeOrderPreviewRequest setAuctionOrder(OrderType orderType, TimeInForce timeInForce) {
        if (orderType == OrderType.AM || orderType == OrderType.AL) {
            TradeOrderModel model = (TradeOrderModel)this.getApiModel();
            model.setOrderType(orderType);
            model.setTimeInForce(timeInForce == TimeInForce.OPG ? timeInForce : TimeInForce.DAY);
        }
        return this;
    }

    private static Long convertToLong(Integer arg) {
        return null == arg ? null : Long.valueOf(arg.longValue());
    }

    @Override
    public Class<TradeOrderPreviewResponse> getResponseClass() {
        return TradeOrderPreviewResponse.class;
    }
}

