/*
 * Decompiled with CFR 0.152.
 */
package com.tigerbrokers.stock.openapi.client.socket;

import com.tigerbrokers.stock.openapi.client.config.ClientConfig;
import com.tigerbrokers.stock.openapi.client.util.ApiLogger;
import com.tigerbrokers.stock.openapi.client.util.TigerSignature;

public class ApiAuthentication {
    private ClientConfig clientConfig;
    private String tigerId;
    private String sign;
    private String version = "3";

    public ApiAuthentication(ClientConfig clientConfig) {
        this.clientConfig = clientConfig;
        this.tigerId = clientConfig.tigerId;
    }

    public ClientConfig getClientConfig() {
        return this.clientConfig;
    }

    public String getTigerId() {
        return this.tigerId;
    }

    public String getSign() {
        return this.sign;
    }

    public void setSign(String sign) {
        this.sign = sign;
    }

    public String getVersion() {
        return this.version;
    }

    public void setVersion(String version) {
        this.version = version;
    }

    public static ApiAuthentication build(ClientConfig clientConfig) {
        return ApiAuthentication.build(clientConfig, clientConfig.privateKey, "3");
    }

    public static ApiAuthentication build(ClientConfig clientConfig, String privateKey) {
        return ApiAuthentication.build(clientConfig, privateKey, "3");
    }

    public static ApiAuthentication build(ClientConfig clientConfig, String privateKey, String version) {
        ApiAuthentication authentication = new ApiAuthentication(clientConfig);
        try {
            String sign = TigerSignature.rsaSign(clientConfig.tigerId, privateKey, "UTF-8");
            authentication.setSign(sign);
            authentication.setVersion(version);
        }
        catch (Exception e) {
            ApiLogger.error("authentication build exception:{}", (Object)e.getMessage(), (Object)e);
            return null;
        }
        return authentication;
    }
}

