/*
 * Decompiled with CFR 0.152.
 */
package com.tigerbrokers.stock.openapi.client.https.request.financial;

import com.tigerbrokers.stock.openapi.client.config.ClientConfig;
import com.tigerbrokers.stock.openapi.client.https.domain.financial.model.FinancialExchangeRateModel;
import com.tigerbrokers.stock.openapi.client.https.request.TigerCommonRequest;
import com.tigerbrokers.stock.openapi.client.https.request.TigerRequest;
import com.tigerbrokers.stock.openapi.client.https.response.financial.FinancialExchangeRateResponse;
import com.tigerbrokers.stock.openapi.client.struct.enums.MethodName;
import com.tigerbrokers.stock.openapi.client.struct.enums.TimeZoneId;
import com.tigerbrokers.stock.openapi.client.util.DateUtils;
import java.util.Date;
import java.util.List;

public class FinancialExchangeRateRequest
extends TigerCommonRequest
implements TigerRequest<FinancialExchangeRateResponse> {
    public FinancialExchangeRateRequest() {
        this.setApiMethodName(MethodName.FINANCIAL_EXCHANGE_RATE);
    }

    public static FinancialExchangeRateRequest newRequest(List<String> currencyList, String beginDate, String endDate) {
        return FinancialExchangeRateRequest.newRequest(currencyList, beginDate, endDate, ClientConfig.DEFAULT_CONFIG.getDefaultTimeZone());
    }

    public static FinancialExchangeRateRequest newRequest(List<String> currencyList, String beginDate, String endDate, TimeZoneId zoneId) {
        return FinancialExchangeRateRequest.newRequest(currencyList, DateUtils.getZoneDate(beginDate, zoneId), DateUtils.getZoneDate(endDate, zoneId));
    }

    public static FinancialExchangeRateRequest newRequest(List<String> currencyList, Date beginDate, Date endDate) {
        FinancialExchangeRateRequest request = new FinancialExchangeRateRequest();
        FinancialExchangeRateModel model = new FinancialExchangeRateModel();
        model.setCurrencyList(currencyList);
        model.setBeginDate(beginDate);
        model.setEndDate(endDate);
        request.setApiModel(model);
        return request;
    }

    @Override
    public FinancialExchangeRateModel getApiModel() {
        if (this.apiModel == null) {
            this.apiModel = new FinancialExchangeRateModel();
        }
        return (FinancialExchangeRateModel)this.apiModel;
    }

    public FinancialExchangeRateRequest currencyList(List<String> currencyList) {
        this.getApiModel().setCurrencyList(currencyList);
        return this;
    }

    public FinancialExchangeRateRequest beginDate(Date beginDate) {
        this.getApiModel().setBeginDate(beginDate);
        return this;
    }

    public FinancialExchangeRateRequest beginDate(String beginDate, TimeZoneId zoneId) {
        this.getApiModel().setBeginDate(DateUtils.getZoneDate(beginDate, zoneId));
        return this;
    }

    public FinancialExchangeRateRequest endDate(Date endDate) {
        this.getApiModel().setEndDate(endDate);
        return this;
    }

    public FinancialExchangeRateRequest endDate(String endDate, TimeZoneId zoneId) {
        this.getApiModel().setEndDate(DateUtils.getZoneDate(endDate, zoneId));
        return this;
    }

    @Override
    public Class<FinancialExchangeRateResponse> getResponseClass() {
        return FinancialExchangeRateResponse.class;
    }
}

