/*
 * Decompiled with CFR 0.152.
 */
package com.tigerbrokers.stock.openapi.client.https.request.trade;

import com.tigerbrokers.stock.openapi.client.config.ClientConfig;
import com.tigerbrokers.stock.openapi.client.https.domain.trade.model.AggregateAssetModel;
import com.tigerbrokers.stock.openapi.client.https.domain.trade.model.PrimeAssetModel;
import com.tigerbrokers.stock.openapi.client.https.request.TigerCommonRequest;
import com.tigerbrokers.stock.openapi.client.https.request.TigerRequest;
import com.tigerbrokers.stock.openapi.client.https.response.trade.AggregateAssetResponse;
import com.tigerbrokers.stock.openapi.client.struct.enums.Currency;
import com.tigerbrokers.stock.openapi.client.struct.enums.MethodName;

public class AggregateAssetRequest
extends TigerCommonRequest
implements TigerRequest<AggregateAssetResponse> {
    public AggregateAssetRequest() {
        this.setApiVersion("1.0");
        this.setApiMethodName(MethodName.AGGREGATE_ASSETS);
    }

    public static AggregateAssetRequest buildAggregateAssetRequest(String account, String segType) {
        AggregateAssetRequest request = new AggregateAssetRequest();
        request.setApiModel(new AggregateAssetModel(account, segType));
        return request;
    }

    public static AggregateAssetRequest buildAggregateAssetRequest(String account, String segType, String secretKey) {
        AggregateAssetRequest request = new AggregateAssetRequest();
        request.setApiModel(new AggregateAssetModel(account, segType, secretKey));
        return request;
    }

    public static AggregateAssetRequest buildAggregateAssetRequest(String account, String segType, String secretKey, Currency baseCurrency) {
        AggregateAssetRequest request = new AggregateAssetRequest();
        AggregateAssetModel model = new AggregateAssetModel(account, segType, baseCurrency.name(), secretKey);
        model.setBaseCurrency(baseCurrency.name());
        request.setApiModel(model);
        return request;
    }

    @Override
    public AggregateAssetModel getApiModel() {
        if (this.apiModel == null) {
            this.apiModel = new PrimeAssetModel(ClientConfig.DEFAULT_CONFIG.defaultAccount);
        }
        return (AggregateAssetModel)this.apiModel;
    }

    @Override
    public Class<AggregateAssetResponse> getResponseClass() {
        return AggregateAssetResponse.class;
    }
}

