/*
 * Decompiled with CFR 0.152.
 */
package com.tigerbrokers.stock.openapi.client.socket;

import com.google.protobuf.Message;
import com.tigerbrokers.stock.openapi.client.socket.ApiAuthentication;
import com.tigerbrokers.stock.openapi.client.socket.ApiCallbackDecoder;
import com.tigerbrokers.stock.openapi.client.socket.ApiComposeCallback;
import com.tigerbrokers.stock.openapi.client.socket.data.pb.Request;
import com.tigerbrokers.stock.openapi.client.socket.data.pb.Response;
import com.tigerbrokers.stock.openapi.client.socket.executor.MessageCallbackExecutor;
import com.tigerbrokers.stock.openapi.client.util.ApiCallbackDecoderUtils;
import com.tigerbrokers.stock.openapi.client.util.ApiLogger;
import com.tigerbrokers.stock.openapi.client.util.ProtoMessageUtil;
import io.netty.channel.ChannelFuture;
import io.netty.channel.ChannelFutureListener;
import io.netty.channel.ChannelHandler;
import io.netty.channel.ChannelHandlerContext;
import io.netty.channel.SimpleChannelInboundHandler;
import io.netty.util.concurrent.GenericFutureListener;

@ChannelHandler.Sharable
public class ProtoSocketHandler
extends SimpleChannelInboundHandler<Response> {
    private ApiAuthentication authentication;
    private ApiCallbackDecoder decoder;
    private int clientSendInterval = 0;
    private int clientReceiveInterval = 0;
    public static final int HEART_BEAT_SPAN = 1000;

    public ProtoSocketHandler(ApiAuthentication authentication, ApiComposeCallback callback) {
        this.authentication = authentication;
        this.decoder = new ApiCallbackDecoder(callback);
    }

    public ProtoSocketHandler(ApiAuthentication authentication, ApiComposeCallback callback, MessageCallbackExecutor executor, int sendInterval, int receiveInterval) {
        this.authentication = authentication;
        this.decoder = new ApiCallbackDecoder(callback, executor);
        this.clientSendInterval = sendInterval;
        this.clientReceiveInterval = receiveInterval;
    }

    public void channelActive(final ChannelHandlerContext ctx) throws Exception {
        Request connect = ProtoMessageUtil.buildConnectMessage(this.authentication.getTigerId(), this.authentication.getSign(), this.authentication.getVersion(), this.clientSendInterval == 0 ? 0 : this.clientSendInterval + 1000, this.clientReceiveInterval == 0 ? 0 : this.clientReceiveInterval - 1000, this.authentication.getClientConfig().useFullTick);
        ApiLogger.info("netty channel active. channel:{}, preparing to send connect token:{}", ctx.channel().id().asShortText(), ProtoMessageUtil.toJson((Message)connect.getConnect()));
        ctx.writeAndFlush((Object)connect).addListener((GenericFutureListener)new ChannelFutureListener(){

            public void operationComplete(ChannelFuture future) {
                if (future.isSuccess()) {
                    ApiLogger.info("send connect token successfully. channel:{}", ctx.channel().id().asShortText());
                } else {
                    ApiLogger.error("failed to send connect token. channel:{}, isDone:{}, cause:{}", ctx.channel().id().asShortText(), future.isDone(), future.cause() == null ? null : future.cause().getMessage());
                }
            }
        });
        super.channelActive(ctx);
    }

    public void channelInactive(ChannelHandlerContext ctx) throws Exception {
        ApiLogger.info("netty channel inactive! channel:{}", ctx.channel().id().asShortText());
        super.channelInactive(ctx);
        ctx.close();
    }

    public void channelRead0(ChannelHandlerContext ctx, Response msg) throws Exception {
        ApiLogger.debug("received msg from server: {}", ProtoMessageUtil.toJson((Message)msg));
        try {
            ApiCallbackDecoderUtils.executor(ctx, msg, this.decoder);
        }
        catch (Throwable th) {
            ApiLogger.error("api callback fail. response:{}", (Object)ProtoMessageUtil.toJson((Message)msg), (Object)th);
        }
    }

    public void exceptionCaught(ChannelHandlerContext ctx, Throwable cause) {
        ApiLogger.error("handler exception caught, channel:{}", (Object)ctx.channel().id(), (Object)cause);
        ctx.close();
    }
}

