/*
 * Decompiled with CFR 0.152.
 */
package com.tigerbrokers.stock.openapi.client.util.watch;

import com.tigerbrokers.stock.openapi.client.util.ApiLogger;
import com.tigerbrokers.stock.openapi.client.util.watch.FileWatchedListener;
import java.io.IOException;
import java.nio.file.FileSystems;
import java.nio.file.Path;
import java.nio.file.StandardWatchEventKinds;
import java.nio.file.WatchEvent;
import java.nio.file.WatchKey;
import java.nio.file.WatchService;
import java.util.List;

public class FileWatchedService {
    private WatchService watchService = FileSystems.getDefault().newWatchService();
    private FileWatchedListener listener;

    public FileWatchedService(Path path, FileWatchedListener listener) throws IOException {
        path.register(this.watchService, StandardWatchEventKinds.ENTRY_CREATE, StandardWatchEventKinds.ENTRY_DELETE, StandardWatchEventKinds.ENTRY_MODIFY, StandardWatchEventKinds.OVERFLOW);
        this.listener = listener;
    }

    public void watch() {
        while (true) {
            try {
                WatchKey watchKey;
                do {
                    watchKey = this.watchService.take();
                    List<WatchEvent<?>> watchEventList = watchKey.pollEvents();
                    for (WatchEvent<Path> watchEvent : watchEventList) {
                        WatchEvent.Kind<?> kind = watchEvent.kind();
                        WatchEvent<Path> curEvent = watchEvent;
                        if (kind == StandardWatchEventKinds.ENTRY_MODIFY) {
                            this.listener.onModified(curEvent);
                            continue;
                        }
                        if (kind == StandardWatchEventKinds.ENTRY_CREATE) {
                            this.listener.onCreated(curEvent);
                            continue;
                        }
                        if (kind == StandardWatchEventKinds.ENTRY_DELETE) {
                            this.listener.onDeleted(curEvent);
                            continue;
                        }
                        if (kind != StandardWatchEventKinds.OVERFLOW) continue;
                        this.listener.onOverflowed(curEvent);
                    }
                } while (watchKey.reset());
            }
            catch (Throwable th) {
                ApiLogger.error("watch file fail", th);
                continue;
            }
            break;
        }
    }
}

