/*
 * Decompiled with CFR 0.152.
 */
package com.tigerbrokers.stock.openapi.client.https.request.option;

import com.tigerbrokers.stock.openapi.client.https.domain.option.model.OptionAnalysisModel;
import com.tigerbrokers.stock.openapi.client.https.domain.option.model.OptionAnalysisRequestModel;
import com.tigerbrokers.stock.openapi.client.https.request.TigerCommonRequest;
import com.tigerbrokers.stock.openapi.client.https.request.TigerRequest;
import com.tigerbrokers.stock.openapi.client.https.response.option.OptionAnalysisResponse;
import com.tigerbrokers.stock.openapi.client.struct.enums.Market;
import com.tigerbrokers.stock.openapi.client.struct.enums.MethodName;
import com.tigerbrokers.stock.openapi.client.struct.enums.OptionAnalysisPeriod;
import java.util.ArrayList;
import java.util.List;

public class OptionAnalysisRequest
extends TigerCommonRequest
implements TigerRequest<OptionAnalysisResponse> {
    public OptionAnalysisRequest() {
        this.setApiVersion("2.0");
        this.setApiMethodName(MethodName.OPTION_ANALYSIS);
    }

    public OptionAnalysisRequest(List<OptionAnalysisModel> symbols, Market market) {
        this();
        OptionAnalysisRequestModel model = new OptionAnalysisRequestModel(symbols);
        model.setMarket(market == null ? Market.US : market);
        this.setApiModel(model);
    }

    public static OptionAnalysisRequest newRequest(List<OptionAnalysisModel> symbols, Market market) {
        return new OptionAnalysisRequest(symbols, market);
    }

    public static OptionAnalysisRequest of(String symbol, String period) {
        return OptionAnalysisRequest.of(symbol, period, Market.US);
    }

    public static OptionAnalysisRequest of(String symbol, String period, Market market) {
        ArrayList<OptionAnalysisModel> items = new ArrayList<OptionAnalysisModel>();
        items.add(new OptionAnalysisModel(symbol, period));
        return new OptionAnalysisRequest(items, market);
    }

    public static OptionAnalysisRequest of(String symbol, OptionAnalysisPeriod period) {
        return OptionAnalysisRequest.of(symbol, period, Market.US);
    }

    public static OptionAnalysisRequest of(String symbol, OptionAnalysisPeriod period, Market market) {
        ArrayList<OptionAnalysisModel> items = new ArrayList<OptionAnalysisModel>();
        items.add(new OptionAnalysisModel(symbol, period));
        return new OptionAnalysisRequest(items, market);
    }

    public OptionAnalysisRequest market(Market market) {
        OptionAnalysisRequestModel model = this.getApiModel();
        if (model != null) {
            model.setMarket(market == null ? Market.US : market);
        }
        return this;
    }

    @Override
    public OptionAnalysisRequestModel getApiModel() {
        return (OptionAnalysisRequestModel)super.getApiModel();
    }

    @Override
    public Class<OptionAnalysisResponse> getResponseClass() {
        return OptionAnalysisResponse.class;
    }
}

