/*
 * Decompiled with CFR 0.152.
 */
package com.tigerbrokers.stock.openapi.client.https.request.quote;

import com.tigerbrokers.stock.openapi.client.config.ClientConfig;
import com.tigerbrokers.stock.openapi.client.https.domain.quote.model.QuoteKlineModel;
import com.tigerbrokers.stock.openapi.client.https.request.TigerCommonRequest;
import com.tigerbrokers.stock.openapi.client.https.request.TigerRequest;
import com.tigerbrokers.stock.openapi.client.https.response.quote.QuoteKlineResponse;
import com.tigerbrokers.stock.openapi.client.struct.enums.KType;
import com.tigerbrokers.stock.openapi.client.struct.enums.MethodName;
import com.tigerbrokers.stock.openapi.client.struct.enums.RightOption;
import com.tigerbrokers.stock.openapi.client.struct.enums.TimeZoneId;
import com.tigerbrokers.stock.openapi.client.struct.enums.TradeSession;
import java.util.List;

public class QuoteKlineRequest
extends TigerCommonRequest
implements TigerRequest<QuoteKlineResponse> {
    public QuoteKlineRequest() {
        this.setApiVersion("2.0");
        this.setApiMethodName(MethodName.KLINE);
    }

    public static QuoteKlineRequest newRequest(List<String> symbols, KType kType) {
        QuoteKlineRequest request = new QuoteKlineRequest();
        QuoteKlineModel model = new QuoteKlineModel(symbols, QuoteKlineRequest.getKType(kType), -1L, -1L);
        request.setApiModel(model);
        return request;
    }

    public static QuoteKlineRequest newRequest(List<String> symbols, KType kType, Long beginTime, Long endTime) {
        QuoteKlineRequest request = new QuoteKlineRequest();
        QuoteKlineModel model = new QuoteKlineModel(symbols, QuoteKlineRequest.getKType(kType), beginTime, endTime);
        request.setApiModel(model);
        return request;
    }

    public static QuoteKlineRequest newRequest(List<String> symbols, KType kType, String beginTime, String endTime) {
        return QuoteKlineRequest.newRequest(symbols, kType, beginTime, endTime, ClientConfig.DEFAULT_CONFIG.getDefaultTimeZone());
    }

    public static QuoteKlineRequest newRequest(List<String> symbols, KType kType, String beginTime, String endTime, Boolean withFundamental) {
        return QuoteKlineRequest.newRequest(symbols, kType, beginTime, endTime, ClientConfig.DEFAULT_CONFIG.getDefaultTimeZone(), withFundamental);
    }

    public static QuoteKlineRequest newRequest(List<String> symbols, KType kType, String beginTime, String endTime, TimeZoneId zoneId) {
        QuoteKlineRequest request = new QuoteKlineRequest();
        QuoteKlineModel model = new QuoteKlineModel(symbols, QuoteKlineRequest.getKType(kType), beginTime, endTime, zoneId);
        request.setApiModel(model);
        return request;
    }

    public static QuoteKlineRequest newRequest(List<String> symbols, KType kType, String beginTime, String endTime, TimeZoneId zoneId, Boolean withFundamental) {
        QuoteKlineRequest request = new QuoteKlineRequest();
        QuoteKlineModel model = new QuoteKlineModel(symbols, QuoteKlineRequest.getKType(kType), beginTime, endTime, zoneId);
        model.setWithFundamental(withFundamental);
        request.setApiModel(model);
        return request;
    }

    private static String getKType(KType kType) {
        return kType != null ? kType.getValue() : KType.day.getValue();
    }

    @Override
    public QuoteKlineModel getApiModel() {
        if (this.apiModel == null) {
            this.apiModel = new QuoteKlineModel();
        }
        return (QuoteKlineModel)this.apiModel;
    }

    public QuoteKlineRequest withDate(String date) {
        this.getApiModel().setDate(date);
        return this;
    }

    public QuoteKlineRequest withLimit(int limit) {
        if (limit > 0) {
            this.getApiModel().setLimit(limit);
        }
        return this;
    }

    public QuoteKlineRequest withRight(RightOption rightOption) {
        if (rightOption != null) {
            this.getApiModel().setRight(rightOption);
        }
        return this;
    }

    public QuoteKlineRequest withRight(String rightOption) {
        if (rightOption != null) {
            this.getApiModel().setRight(rightOption);
        }
        return this;
    }

    public void setTradeSession(TradeSession tradeSession) {
        this.getApiModel().setTradeSession(tradeSession);
    }

    public void withPageToken(String pageToken) {
        this.getApiModel().setPageToken(pageToken);
    }

    public QuoteKlineRequest withFundamental(Boolean withFundamental) {
        this.getApiModel().setWithFundamental(withFundamental);
        return this;
    }

    @Override
    public Class<QuoteKlineResponse> getResponseClass() {
        return QuoteKlineResponse.class;
    }
}

