/*
 * Decompiled with CFR 0.152.
 */
package com.tigerbrokers.stock.openapi.client.util;

import com.tigerbrokers.stock.openapi.client.util.ApiLogger;
import java.lang.reflect.Field;
import java.lang.reflect.InvocationTargetException;
import java.lang.reflect.Method;

public class ReflectionUtil {
    public static void checkAndSetDefaultValue(Object bean, String fieldName, String setMethodName, Object defaultValue) {
        try {
            Class<?> clazz = bean.getClass();
            Method setNameMethod = ReflectionUtil.getMethod(clazz, setMethodName, defaultValue.getClass());
            if (setNameMethod != null) {
                setNameMethod.invoke(bean, defaultValue);
                return;
            }
            Field field = clazz.getDeclaredField(fieldName);
            if (field == null) {
                return;
            }
            field.setAccessible(true);
            Object value = field.get(bean);
            if (value == null) {
                field.set(bean, defaultValue);
            }
        }
        catch (IllegalAccessException | NoSuchFieldException | InvocationTargetException e) {
            ApiLogger.error("checkAndSetDefaultValue failed:{}", (Object)e.getMessage(), (Object)e);
        }
    }

    public static Method getMethod(Class<?> clazz, String methodName, Class<?> parameterType) {
        try {
            return clazz.getMethod(methodName, parameterType);
        }
        catch (NoSuchMethodException e) {
            return null;
        }
    }
}

