/*
 * Decompiled with CFR 0.152.
 */
package io.github.tuzon.java.csv.api;

import io.github.tuzon.java.csv.api.CsvApiBase;
import io.github.tuzon.java.csv.enums.CellsSplitterEnum;
import io.github.tuzon.java.csv.exceptions.CsvOperationException;
import io.github.tuzon.projects.core.expections.InvalidValueException;
import io.github.tuzon.projects.core.utils.StringUtil;
import java.io.File;
import java.io.FileOutputStream;
import java.io.IOException;
import java.io.OutputStream;
import java.io.OutputStreamWriter;
import java.io.PrintWriter;
import java.io.Writer;
import java.util.List;

public class CsvWriterApi
extends CsvApiBase {
    private int rowSize = -1;
    private boolean isCsvSaved = false;
    private boolean isSetHeaders = false;
    private Writer writer = null;
    private PrintWriter printWriter = null;

    public CsvWriterApi(String filePath) {
        this(filePath, CELLS_DEFAULT_SPLITTER);
    }

    public CsvWriterApi(String filePath, CellsSplitterEnum cellsSplitter) {
        this(filePath, cellsSplitter.getChar());
    }

    public CsvWriterApi(String filePath, char cellsSplitter) {
        super(filePath, cellsSplitter);
    }

    public void setHeaders(List<String> headerList) throws CsvOperationException, InvalidValueException {
        if (this.isSetHeaders) {
            throw new CsvOperationException("Headers already set and cannot set more than one time");
        }
        if (this.isCsvSaved()) {
            throw new CsvOperationException("Headers cannot be set after save CSV file");
        }
        CsvWriterApi.validateNotNull(headerList);
        this.isSetHeaders = true;
        this.headerList = headerList;
        this.updateRowSizeAfterUpdateHeaderList();
    }

    public void addRow(List<String> row) throws InvalidValueException, CsvOperationException {
        if (this.isCsvSaved()) {
            throw new CsvOperationException("Row cannot be added because CSV file [" + this.filePath + "] already saved");
        }
        CsvWriterApi.validateNotNull(row);
        this.updateRowSizeBeforeUpdateRow(row);
        this.csvRows.add(row);
    }

    public void addRow(List<String> row, int index) throws InvalidValueException, IndexOutOfBoundsException, CsvOperationException {
        if (this.isCsvSaved()) {
            throw new CsvOperationException("Row cannot be added because CSV file [" + this.filePath + "] already saved");
        }
        CsvWriterApi.validateNotNull(row);
        CsvWriterApi.validateNotNegative((int)index);
        if (row.size() <= index) {
            throw new IndexOutOfBoundsException("Index [" + index + "] cannot be out of bound from row size [" + row.size() + "]");
        }
        this.updateRowSizeBeforeUpdateRow(row);
        this.csvRows.add(index, row);
    }

    public void addRows(List<List<String>> rowList) throws InvalidValueException, CsvOperationException {
        CsvWriterApi.validateNotNull(rowList);
        for (List<String> row : rowList) {
            this.addRow(row);
        }
    }

    public void removeRow(int index) throws InvalidValueException, IndexOutOfBoundsException, CsvOperationException {
        if (this.isCsvSaved()) {
            throw new CsvOperationException("Row cannot be removed because CSV file [" + this.filePath + "] already saved");
        }
        CsvWriterApi.validateNotNegative((int)index);
        if (this.csvRows.size() <= index) {
            throw new IndexOutOfBoundsException("Index [" + index + "] is out of bound from CSV rows amount [" + this.csvRows + "]");
        }
        this.csvRows.remove(index);
    }

    public void save() throws IOException, CsvOperationException {
        if (this.isCsvSaved()) {
            throw new CsvOperationException("CSV file [" + this.filePath + "] already been saved");
        }
        try {
            this.openFileAndSetPrintWriter();
            this.writeCsvHeadersRowToFile();
            this.writeCsvRowsToFile();
        }
        finally {
            this.isCsvSaved = true;
            this.closeFile();
        }
    }

    public boolean isCsvSaved() {
        return this.isCsvSaved;
    }

    private void closeFile() {
        try {
            if (this.printWriter != null) {
                this.printWriter.close();
            }
            if (this.writer != null) {
                this.writer.close();
            }
        }
        catch (Exception exception) {
        }
        finally {
            this.writer = null;
            this.printWriter = null;
        }
    }

    private void writeCsvRowsToFile() {
        for (List row : this.csvRows) {
            this.printWriter.println(this.convertCsvRowToFileRow(row));
        }
    }

    private void writeCsvHeadersRowToFile() {
        if (!this.headerList.isEmpty()) {
            this.printWriter.println(this.convertCsvRowToFileRow(this.headerList));
        }
    }

    private void openFileAndSetPrintWriter() throws IOException {
        File file = new File(this.filePath);
        this.writer = new OutputStreamWriter((OutputStream)new FileOutputStream(file), "UTF-8");
        this.printWriter = new PrintWriter(this.writer);
    }

    private void updateRowSizeBeforeUpdateRow(List<String> row) throws InvalidValueException {
        if (this.rowSize != -1) {
            if (this.rowSize != row.size()) {
                throw new InvalidValueException("Current row size [" + row.size() + "] is different from CSV previous updated row size [" + this.rowSize + "]");
            }
        } else {
            this.rowSize = row.size();
        }
    }

    private void updateRowSizeAfterUpdateHeaderList() throws InvalidValueException {
        if (this.rowSize != -1) {
            if (this.rowSize != this.headerList.size()) {
                throw new InvalidValueException("Headers amount [" + this.headerList.size() + "] is different from CSV previous updated rows size [" + this.rowSize + "]");
            }
        } else {
            this.rowSize = this.headerList.size();
        }
    }

    private String convertCsvRowToFileRow(List<String> csvRow) {
        StringBuffer rowToFile = new StringBuffer();
        for (String cell : csvRow) {
            cell = this.updateCellIfContainInvertedCommans(cell);
            cell = this.delimitWithInvertedCommasIfComplexCell(cell);
            rowToFile.append(cell).append(this.cellsSplitter);
        }
        return StringUtil.removeLastChar((String)rowToFile.toString());
    }

    private String updateCellIfContainInvertedCommans(String cell) {
        return cell.replace("\"", "\"\"");
    }

    private String delimitWithInvertedCommasIfComplexCell(String cell) {
        if (cell.contains("\n") || cell.contains("\"") || cell.indexOf(this.cellsSplitter) >= 0) {
            cell = "\"" + cell + "\"";
        }
        return cell;
    }
}

