/*
 * Decompiled with CFR 0.152.
 */
package io.github.tuzon.java.csv.api;

import io.github.tuzon.java.csv.api.CsvApiBase;
import io.github.tuzon.java.csv.enums.CellsSplitterEnum;
import io.github.tuzon.projects.core.expections.InvalidValueException;
import io.github.tuzon.projects.core.utils.StringUtil;
import java.io.BufferedReader;
import java.io.File;
import java.io.FileInputStream;
import java.io.FileNotFoundException;
import java.io.IOException;
import java.io.InputStream;
import java.io.InputStreamReader;
import java.nio.charset.StandardCharsets;
import java.util.ArrayList;
import java.util.List;

public class CsvReaderApi
extends CsvApiBase {
    public static final boolean CSV_CONTAIN_HEADERS = true;
    private String cell = "";
    private List<String> cellsInLine = new ArrayList<String>();
    private boolean isCellInInvertedComma = false;

    public CsvReaderApi(String filePath) throws IOException {
        this(filePath, CELLS_DEFAULT_SPLITTER);
    }

    public CsvReaderApi(String filePath, CellsSplitterEnum cellsSplitter) throws IOException {
        this(filePath, cellsSplitter.getChar());
    }

    public CsvReaderApi(String filePath, boolean isCsvContainHeaders) throws IOException {
        this(filePath, CELLS_DEFAULT_SPLITTER, isCsvContainHeaders);
    }

    public CsvReaderApi(String filePath, char cellsSplitter) throws IOException {
        this(filePath, cellsSplitter, true);
    }

    public CsvReaderApi(String filePath, char cellsSplitter, boolean isCsvContainHeaders) throws IOException {
        super(filePath, cellsSplitter);
        this.parseCsv(filePath);
        if (isCsvContainHeaders) {
            this.setHeaderList();
        }
    }

    public int getRowsAmount() {
        if (this.csvRows == null) {
            return -1;
        }
        return this.csvRows.size();
    }

    public boolean isCsvEmpty() {
        return this.getRowsAmount() < 1;
    }

    public List<String> getHeaderList() {
        return this.headerList;
    }

    public int getColumnIndex(String headerName) {
        for (int i = 0; i < this.headerList.size(); ++i) {
            if (!((String)this.headerList.get(i)).equals(headerName)) continue;
            return i;
        }
        return -1;
    }

    public int getRowIndex(String headerName, String value) throws IndexOutOfBoundsException {
        int columnIndex = this.getColumnIndex(headerName);
        if (columnIndex == -1) {
            return -1;
        }
        for (int i = 0; i < this.csvRows.size(); ++i) {
            List row = (List)this.csvRows.get(i);
            if (row.size() <= columnIndex) {
                throw new IndexOutOfBoundsException("Column index [" + columnIndex + "] in CSV file [" + this.getPath() + "] exceed of row size [" + row.size() + "]");
            }
            if (!((String)row.get(columnIndex)).equals(value)) continue;
            return i;
        }
        return -1;
    }

    public List<String> getColumn(String headerName) {
        ArrayList<String> columnValues = new ArrayList<String>();
        int index = this.getColumnIndex(headerName);
        if (index == -1) {
            return null;
        }
        for (List row : this.csvRows) {
            columnValues.add((String)row.get(index));
        }
        return columnValues;
    }

    public String getFieldValue(String headerName, int rowIndex) throws InvalidValueException, IndexOutOfBoundsException {
        if (rowIndex < 0) {
            throw new InvalidValueException("Index value [" + rowIndex + "] should not be negative");
        }
        List<String> columnFields = this.getColumn(headerName);
        if (columnFields == null) {
            return null;
        }
        if (rowIndex >= columnFields.size()) {
            throw new IndexOutOfBoundsException("Index [" + rowIndex + "] is out of bound. CSV [" + this.getPath() + "] cells amount for header [" + columnFields + "] is [" + columnFields.size() + "]");
        }
        return columnFields.get(rowIndex);
    }

    public List<List<String>> getRows() {
        return this.csvRows;
    }

    public List<String> getRow(int index) throws InvalidValueException, IndexOutOfBoundsException {
        if (index < 0) {
            throw new InvalidValueException("Index value [" + index + "] should not be negative");
        }
        if (index >= this.getRowsAmount()) {
            throw new IndexOutOfBoundsException("Index [" + index + "] is out of bound. CSV [" + this.getPath() + "] rows amount [" + this.getRowsAmount() + "]");
        }
        return (List)this.csvRows.get(index);
    }

    public String getPath() {
        return this.filePath;
    }

    private void parseCsv(String path) throws IOException {
        BufferedReader buff = null;
        try {
            buff = new BufferedReader(new InputStreamReader((InputStream)new FileInputStream(new File(path)), StandardCharsets.UTF_8));
            String row = "";
            while (row != null) {
                row = buff.readLine();
                if (row == null) continue;
                this.parsePreFormattedRow(row);
                if (this.isCellInInvertedComma) continue;
                this.csvRows.add(this.cellsInLine);
                this.cellsInLine = new ArrayList<String>();
            }
        }
        catch (FileNotFoundException e) {
            throw new FileNotFoundException("CSV file [" + path + "] was not found");
        }
        finally {
            if (buff != null) {
                try {
                    buff.close();
                }
                catch (IOException iOException) {}
            }
        }
    }

    private void parsePreFormattedRow(String row) {
        List preFormattedCellList = StringUtil.split((String)row, (char)this.cellsSplitter);
        for (int i = 0; i < preFormattedCellList.size(); ++i) {
            String preFormattedCell = (String)preFormattedCellList.get(i);
            if (this.isCellInInvertedComma) {
                this.parsePreCellWhenItIsInInvertedComma(i, preFormattedCell);
                continue;
            }
            this.parsePreCellWhenItIsNotInInvertedComma(preFormattedCell);
        }
    }

    private void parsePreCellWhenItIsInInvertedComma(int preFormattedCellIndex, String preFormattedCellInRow) {
        this.cell = preFormattedCellIndex == 0 ? this.cell + "\n" + preFormattedCellInRow : this.cell + this.cellsSplitter + preFormattedCellInRow;
        boolean isOddInvertedCommas = this.isOddInvertedCommasFromEnd(preFormattedCellInRow);
        if (isOddInvertedCommas) {
            this.isCellInInvertedComma = false;
            this.cell = this.removeCsvInvertedCommasInCell(this.cell);
            this.cellsInLine.add(this.cell);
            this.cell = "";
        }
    }

    private void parsePreCellWhenItIsNotInInvertedComma(String preFormattedCell) {
        if (preFormattedCell.isEmpty()) {
            this.cellsInLine.add("");
        } else if (preFormattedCell.startsWith("\"")) {
            this.parseCellStartWithInvertedComma(preFormattedCell);
        } else {
            this.cellsInLine.add(preFormattedCell);
        }
    }

    private void parseCellStartWithInvertedComma(String preFormattedCell) {
        boolean isOddInvertedCommas = this.isOddInvertedCommasFromBegin(preFormattedCell);
        if (isOddInvertedCommas) {
            if (this.isOddInvertedCommasFromEnd(preFormattedCell) && preFormattedCell.length() > 1) {
                this.cellsInLine.add(this.removeCsvInvertedCommasInCell(preFormattedCell));
            } else {
                this.isCellInInvertedComma = true;
                this.cell = preFormattedCell;
            }
        } else {
            this.cellsInLine.add(this.removeCsvInvertedCommasInCell(preFormattedCell));
        }
    }

    private boolean isOddInvertedCommasFromBegin(String cell) {
        char c;
        if (cell == null) {
            return false;
        }
        if (!cell.startsWith("\"")) {
            return false;
        }
        int count = 0;
        for (int i = 0; i < cell.length() && (c = cell.charAt(i)) == '\"'; ++i) {
            ++count;
        }
        return Math.abs(count) % 2 == 1;
    }

    private boolean isOddInvertedCommasFromEnd(String raw) {
        char c;
        if (raw == null) {
            return false;
        }
        if (!raw.endsWith("\"")) {
            return false;
        }
        int count = 0;
        for (int i = raw.length() - 1; i >= 0 && (c = raw.charAt(i)) == '\"'; --i) {
            ++count;
        }
        return Math.abs(count) % 2 == 1;
    }

    private String removeCsvInvertedCommasInCell(String cell) {
        if (cell == null) {
            return null;
        }
        if (cell.isEmpty()) {
            return "";
        }
        cell = cell.substring(1, cell.length() - 1);
        cell = cell.replaceAll("\"\"", "\"");
        return cell;
    }

    private void setHeaderList() {
        if (this.csvRows != null && this.csvRows.size() > 0) {
            this.headerList = (List)this.csvRows.get(0);
            this.csvRows.remove(0);
        }
    }
}

