/*
 * Decompiled with CFR 0.152.
 */
package io.github.vinogradoff.testdatabroker.client;

import io.github.vinogradoff.testdatabroker.client.TestDataBrokerClient;
import java.io.IOException;
import okhttp3.OkHttpClient;
import okhttp3.Request;
import okhttp3.RequestBody;

public class DefaultTestDataBrokerClient
implements TestDataBrokerClient {
    OkHttpClient client = new OkHttpClient();
    String baseUrl;

    public DefaultTestDataBrokerClient() {
        this.baseUrl = "http://localhost:8080";
    }

    public DefaultTestDataBrokerClient(String baseUrl) {
        this.baseUrl = baseUrl;
    }

    @Override
    public void writeData(String dictionary, String key, String value) throws IOException {
        RequestBody body = RequestBody.create((byte[])new byte[0]);
        Request req = new Request.Builder().url(this.baseUrl + "/api/write/" + dictionary + "/" + key + "?value=" + value).post(body).build();
        this.client.newCall(req).execute();
    }

    @Override
    public String readData(String dictionary, String key) throws IOException {
        Request req = new Request.Builder().url(this.baseUrl + "/api/read/" + dictionary + "/" + key).build();
        return this.client.newCall(req).execute().body().string();
    }

    @Override
    public String claimData(String dictionary, String key) throws IOException {
        RequestBody body = RequestBody.create((byte[])new byte[0]);
        Request req = new Request.Builder().url(this.baseUrl + "/api/claim/" + dictionary + "/" + key).put(body).build();
        return this.client.newCall(req).execute().body().string();
    }
}

